/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mount;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mount.MountdBase;
import org.apache.hadoop.oncrpc.RpcProgram;
import org.apache.hadoop.oncrpc.SimpleTcpServer;
import org.apache.hadoop.oncrpc.SimpleUdpServer;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.ShutdownHookManager;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class MountdBase {
    public static final Log LOG = LogFactory.getLog(MountdBase.class);
    private final RpcProgram rpcProgram;
    private int udpBoundPort;
    private int tcpBoundPort;
    public static final int SHUTDOWN_HOOK_PRIORITY = 10;

    public RpcProgram getRpcProgram() {
        return this.rpcProgram;
    }

    public MountdBase(RpcProgram program) throws IOException {
        this.rpcProgram = program;
    }

    private void startUDPServer() {
        SimpleUdpServer udpServer = new SimpleUdpServer(this.rpcProgram.getPort(), (SimpleChannelUpstreamHandler)this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        udpServer.run();
        this.udpBoundPort = udpServer.getBoundPort();
    }

    private void startTCPServer() {
        SimpleTcpServer tcpServer = new SimpleTcpServer(this.rpcProgram.getPort(), this.rpcProgram, 1);
        this.rpcProgram.startDaemons();
        tcpServer.run();
        this.tcpBoundPort = tcpServer.getBoundPort();
    }

    public void start(boolean register) {
        this.startUDPServer();
        this.startTCPServer();
        if (register) {
            ShutdownHookManager.get().addShutdownHook((Runnable)new Unregister(this, null), 10);
            try {
                this.rpcProgram.register(17, this.udpBoundPort);
                this.rpcProgram.register(6, this.tcpBoundPort);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Failed to start the server. Cause:", e);
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    static /* synthetic */ int access$100(MountdBase x0) {
        return x0.udpBoundPort;
    }

    static /* synthetic */ RpcProgram access$200(MountdBase x0) {
        return x0.rpcProgram;
    }

    static /* synthetic */ int access$300(MountdBase x0) {
        return x0.tcpBoundPort;
    }
}

