/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.nfs.nfs3.request;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.nfs.nfs3.FileHandle;
import org.apache.hadoop.nfs.nfs3.request.RequestWithHandle;
import org.apache.hadoop.oncrpc.XDR;

public class READ3Request
extends RequestWithHandle {
    private final long offset;
    private final int count;

    public READ3Request(XDR xdr) throws IOException {
        super(xdr);
        this.offset = xdr.readHyper();
        this.count = xdr.readInt();
    }

    @VisibleForTesting
    public READ3Request(FileHandle handle, long offset, int count) {
        super(handle);
        this.offset = offset;
        this.count = count;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void serialize(XDR xdr) {
        this.handle.serialize(xdr);
        xdr.writeLongAsHyper(this.offset);
        xdr.writeInt(this.count);
    }
}

