/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.portmap;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.portmap.RpcProgramPortmap;
import org.apache.hadoop.util.StringUtils;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;

final class Portmap {
    private static final Log LOG = LogFactory.getLog(Portmap.class);
    private static final int DEFAULT_IDLE_TIME_MILLISECONDS = 5000;
    private ConnectionlessBootstrap udpServer;
    private ServerBootstrap tcpServer;
    private ChannelGroup allChannels = new DefaultChannelGroup();
    private Channel udpChannel;
    private Channel tcpChannel;
    private final RpcProgramPortmap handler = new RpcProgramPortmap(this.allChannels);

    Portmap() {
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(Portmap.class, (String[])args, (Log)LOG);
        int port = 111;
        Portmap pm = new Portmap();
        try {
            pm.start(5000, (SocketAddress)new InetSocketAddress(111), (SocketAddress)new InetSocketAddress(111));
        }
        catch (Throwable e) {
            LOG.fatal((Object)("Failed to start the server. Cause:" + e.getMessage()));
            pm.shutdown();
            System.exit(-1);
        }
    }

    void shutdown() {
        this.allChannels.close().awaitUninterruptibly();
        this.tcpServer.releaseExternalResources();
        this.udpServer.releaseExternalResources();
    }

    @VisibleForTesting
    SocketAddress getTcpServerLocalAddress() {
        return this.tcpChannel.getLocalAddress();
    }

    @VisibleForTesting
    SocketAddress getUdpServerLoAddress() {
        return this.udpChannel.getLocalAddress();
    }

    @VisibleForTesting
    RpcProgramPortmap getHandler() {
        return this.handler;
    }

    void start(int idleTimeMilliSeconds, SocketAddress tcpAddress, SocketAddress udpAddress) {
        this.tcpServer = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool()));
        this.tcpServer.setPipelineFactory((ChannelPipelineFactory)new /* Unavailable Anonymous Inner Class!! */);
        this.udpServer = new ConnectionlessBootstrap((ChannelFactory)new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool()));
        this.udpServer.setPipeline(Channels.pipeline((ChannelHandler[])new ChannelHandler[]{RpcUtil.STAGE_RPC_MESSAGE_PARSER, this.handler, RpcUtil.STAGE_RPC_UDP_RESPONSE}));
        this.tcpChannel = this.tcpServer.bind(tcpAddress);
        this.udpChannel = this.udpServer.bind(udpAddress);
        this.allChannels.add((Object)this.tcpChannel);
        this.allChannels.add((Object)this.udpChannel);
        LOG.info((Object)("Portmap server started at tcp://" + this.tcpChannel.getLocalAddress() + ", udp://" + this.udpChannel.getLocalAddress()));
    }

    static /* synthetic */ RpcProgramPortmap access$000(Portmap x0) {
        return x0.handler;
    }
}

