/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.oncrpc.RpcAcceptedReply;
import org.apache.hadoop.oncrpc.RpcCall;
import org.apache.hadoop.oncrpc.RpcInfo;
import org.apache.hadoop.oncrpc.RpcResponse;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.apache.hadoop.oncrpc.SimpleUdpClient;
import org.apache.hadoop.oncrpc.XDR;
import org.apache.hadoop.oncrpc.security.Verifier;
import org.apache.hadoop.portmap.PortmapMapping;
import org.apache.hadoop.portmap.PortmapRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;

public abstract class RpcProgram
extends SimpleChannelUpstreamHandler {
    private static final Log LOG = LogFactory.getLog(RpcProgram.class);
    public static final int RPCB_PORT = 111;
    private final String program;
    private final String host;
    private int port;
    private final int progNumber;
    private final int lowProgVersion;
    private final int highProgVersion;

    protected RpcProgram(String program, String host, int port, int progNumber, int lowProgVersion, int highProgVersion) {
        this.program = program;
        this.host = host;
        this.port = port;
        this.progNumber = progNumber;
        this.lowProgVersion = lowProgVersion;
        this.highProgVersion = highProgVersion;
    }

    public void register(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info((Object)("The bound port is " + boundPort + ", different with configured port " + this.port));
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, true);
        }
    }

    public void unregister(int transport, int boundPort) {
        if (boundPort != this.port) {
            LOG.info((Object)("The bound port is " + boundPort + ", different with configured port " + this.port));
            this.port = boundPort;
        }
        for (int vers = this.lowProgVersion; vers <= this.highProgVersion; ++vers) {
            PortmapMapping mapEntry = new PortmapMapping(this.progNumber, vers, transport, this.port);
            this.register(mapEntry, false);
        }
    }

    protected void register(PortmapMapping mapEntry, boolean set) {
        XDR mappingRequest = PortmapRequest.create((PortmapMapping)mapEntry, (boolean)set);
        SimpleUdpClient registrationClient = new SimpleUdpClient(this.host, 111, mappingRequest);
        try {
            registrationClient.run();
        }
        catch (IOException e) {
            String request = set ? "Registration" : "Unregistration";
            LOG.error((Object)(request + " failure with " + this.host + ":" + this.port + ", portmap entry: " + mapEntry));
            throw new RuntimeException(request + " failure");
        }
    }

    public void startDaemons() {
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        RpcInfo info = (RpcInfo)e.getMessage();
        RpcCall call = (RpcCall)info.header();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.program + " procedure #" + call.getProcedure()));
        }
        if (this.progNumber != call.getProgram()) {
            LOG.warn((Object)("Invalid RPC call program " + call.getProgram()));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance((int)call.getXid(), (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROG_UNAVAIL, (Verifier)Verifier.VERIFIER_NONE);
            XDR out = new XDR();
            reply.write(out);
            ChannelBuffer b = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(b, info.remoteAddress());
            RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
            return;
        }
        int ver = call.getVersion();
        if (ver < this.lowProgVersion || ver > this.highProgVersion) {
            LOG.warn((Object)("Invalid RPC call version " + ver));
            RpcAcceptedReply reply = RpcAcceptedReply.getInstance((int)call.getXid(), (RpcAcceptedReply.AcceptState)RpcAcceptedReply.AcceptState.PROG_MISMATCH, (Verifier)Verifier.VERIFIER_NONE);
            XDR out = new XDR();
            reply.write(out);
            out.writeInt(this.lowProgVersion);
            out.writeInt(this.highProgVersion);
            ChannelBuffer b = ChannelBuffers.wrappedBuffer((ByteBuffer)out.asReadOnlyWrap().buffer());
            RpcResponse rsp = new RpcResponse(b, info.remoteAddress());
            RpcUtil.sendRpcResponse((ChannelHandlerContext)ctx, (RpcResponse)rsp);
            return;
        }
        this.handleInternal(ctx, info);
    }

    protected abstract void handleInternal(ChannelHandlerContext var1, RpcInfo var2);

    public String toString() {
        return "Rpc program: " + this.program + " at " + this.host + ":" + this.port;
    }

    protected abstract boolean isIdempotent(RpcCall var1);

    public int getPort() {
        return this.port;
    }
}

