/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.minikdc;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.SchemaLoader;
import org.apache.directory.api.ldap.schemaextractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaloader.LdifSchemaLoader;
import org.apache.directory.api.ldap.schemamanager.impl.DefaultSchemaManager;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InstanceLayout;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.schema.SchemaPartition;
import org.apache.directory.server.core.kerberos.KeyDerivationInterceptor;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmIndex;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmPartition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MiniKdc {
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String SUN_SECURITY_KRB5_DEBUG = "sun.security.krb5.debug";
    private static final Logger LOG = LoggerFactory.getLogger(MiniKdc.class);
    public static final String ORG_NAME = "org.name";
    public static final String ORG_DOMAIN = "org.domain";
    public static final String KDC_BIND_ADDRESS = "kdc.bind.address";
    public static final String KDC_PORT = "kdc.port";
    public static final String INSTANCE = "instance";
    public static final String MAX_TICKET_LIFETIME = "max.ticket.lifetime";
    public static final String MAX_RENEWABLE_LIFETIME = "max.renewable.lifetime";
    public static final String TRANSPORT = "transport";
    public static final String DEBUG = "debug";
    private static final Set<String> PROPERTIES = new HashSet();
    private static final Properties DEFAULT_CONFIG = new Properties();
    private Properties conf;
    private DirectoryService ds;
    private KdcServer kdc;
    private int port;
    private String realm;
    private File workDir;
    private File krb5conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File workDir;
        if (args.length < 4) {
            System.out.println("Arguments: <WORKDIR> <MINIKDCPROPERTIES> <KEYTABFILE> [<PRINCIPALS>]+");
            System.exit(1);
        }
        if (!(workDir = new File(args[0])).exists()) {
            throw new RuntimeException("Specified work directory does not exists: " + workDir.getAbsolutePath());
        }
        Properties conf = MiniKdc.createConf();
        File file = new File(args[1]);
        if (!file.exists()) {
            throw new RuntimeException("Specified configuration does not exists: " + file.getAbsolutePath());
        }
        Properties userConf = new Properties();
        try (InputStreamReader r = null;){
            r = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
            userConf.load(r);
        }
        for (Map.Entry<Object, Object> entry : userConf.entrySet()) {
            conf.put(entry.getKey(), entry.getValue());
        }
        MiniKdc miniKdc = new MiniKdc(conf, workDir);
        miniKdc.start();
        File krb5conf = new File(workDir, "krb5.conf");
        if (!miniKdc.getKrb5conf().renameTo(krb5conf)) {
            throw new RuntimeException("Cannot rename KDC's krb5conf to " + krb5conf.getAbsolutePath());
        }
        File keytabFile = new File(args[2]).getAbsoluteFile();
        String[] principals = new String[args.length - 3];
        System.arraycopy(args, 3, principals, 0, args.length - 3);
        miniKdc.createPrincipal(keytabFile, principals);
        System.out.println();
        System.out.println("Standalone MiniKdc Running");
        System.out.println("---------------------------------------------------");
        System.out.println("  Realm           : " + miniKdc.getRealm());
        System.out.println("  Running at      : " + miniKdc.getHost() + ":" + miniKdc.getHost());
        System.out.println("  krb5conf        : " + krb5conf);
        System.out.println();
        System.out.println("  created keytab  : " + keytabFile);
        System.out.println("  with principals : " + Arrays.asList(principals));
        System.out.println();
        System.out.println(" Do <CTRL-C> or kill <PID> to stop it");
        System.out.println("---------------------------------------------------");
        System.out.println();
        Runtime.getRuntime().addShutdownHook((Thread)new /* Unavailable Anonymous Inner Class!! */);
    }

    public static Properties createConf() {
        return (Properties)DEFAULT_CONFIG.clone();
    }

    public MiniKdc(Properties conf, File workDir) throws Exception {
        if (!conf.keySet().containsAll(PROPERTIES)) {
            HashSet missingProperties = new HashSet(PROPERTIES);
            missingProperties.removeAll(conf.keySet());
            throw new IllegalArgumentException("Missing configuration properties: " + missingProperties);
        }
        this.workDir = new File(workDir, Long.toString(System.currentTimeMillis()));
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new RuntimeException("Cannot create directory " + workDir);
        }
        LOG.info("Configuration:");
        LOG.info("---------------------------------------------------------------");
        for (Map.Entry<Object, Object> entry : conf.entrySet()) {
            LOG.info("  {}: {}", entry.getKey(), entry.getValue());
        }
        LOG.info("---------------------------------------------------------------");
        this.conf = conf;
        this.port = Integer.parseInt(conf.getProperty("kdc.port"));
        if (this.port == 0) {
            ServerSocket ss = new ServerSocket(0, 1, InetAddress.getByName(conf.getProperty("kdc.bind.address")));
            this.port = ss.getLocalPort();
            ss.close();
        }
        String orgName = conf.getProperty("org.name");
        String orgDomain = conf.getProperty("org.domain");
        this.realm = orgName.toUpperCase(Locale.ENGLISH) + "." + orgDomain.toUpperCase(Locale.ENGLISH);
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.conf.getProperty("kdc.bind.address");
    }

    public String getRealm() {
        return this.realm;
    }

    public File getKrb5conf() {
        return this.krb5conf;
    }

    public synchronized void start() throws Exception {
        if (this.kdc != null) {
            throw new RuntimeException("Already started");
        }
        this.initDirectoryService();
        this.initKDCServer();
    }

    private void initDirectoryService() throws Exception {
        this.ds = new DefaultDirectoryService();
        this.ds.setInstanceLayout(new InstanceLayout(this.workDir));
        CacheService cacheService = new CacheService();
        this.ds.setCacheService(cacheService);
        InstanceLayout instanceLayout = this.ds.getInstanceLayout();
        File schemaPartitionDirectory = new File(instanceLayout.getPartitionsDirectory(), "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(instanceLayout.getPartitionsDirectory());
        extractor.extractOrCopy();
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaPartitionDirectory);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager((SchemaLoader)loader);
        schemaManager.loadAllEnabled();
        this.ds.setSchemaManager((SchemaManager)schemaManager);
        LdifPartition schemaLdifPartition = new LdifPartition((SchemaManager)schemaManager);
        schemaLdifPartition.setPartitionPath(schemaPartitionDirectory.toURI());
        SchemaPartition schemaPartition = new SchemaPartition((SchemaManager)schemaManager);
        schemaPartition.setWrappedPartition((Partition)schemaLdifPartition);
        this.ds.setSchemaPartition(schemaPartition);
        JdbmPartition systemPartition = new JdbmPartition(this.ds.getSchemaManager());
        systemPartition.setId("system");
        systemPartition.setPartitionPath(new File(this.ds.getInstanceLayout().getPartitionsDirectory(), systemPartition.getId()).toURI());
        systemPartition.setSuffixDn(new Dn(new String[]{"ou=system"}));
        systemPartition.setSchemaManager(this.ds.getSchemaManager());
        this.ds.setSystemPartition((Partition)systemPartition);
        this.ds.getChangeLog().setEnabled(false);
        this.ds.setDenormalizeOpAttrsEnabled(true);
        this.ds.addLast((Interceptor)new KeyDerivationInterceptor());
        String orgName = this.conf.getProperty("org.name").toLowerCase(Locale.ENGLISH);
        String orgDomain = this.conf.getProperty("org.domain").toLowerCase(Locale.ENGLISH);
        JdbmPartition partition = new JdbmPartition(this.ds.getSchemaManager());
        partition.setId(orgName);
        partition.setPartitionPath(new File(this.ds.getInstanceLayout().getPartitionsDirectory(), orgName).toURI());
        partition.setSuffixDn(new Dn(new String[]{"dc=" + orgName + ",dc=" + orgDomain}));
        this.ds.addPartition((Partition)partition);
        HashSet<JdbmIndex> indexedAttributes = new HashSet<JdbmIndex>();
        indexedAttributes.add(new JdbmIndex("objectClass", false));
        indexedAttributes.add(new JdbmIndex("dc", false));
        indexedAttributes.add(new JdbmIndex("ou", false));
        partition.setIndexedAttributes(indexedAttributes);
        this.ds.setInstanceId(this.conf.getProperty("instance"));
        this.ds.startup();
        Dn dn = new Dn(new String[]{"dc=" + orgName + ",dc=" + orgDomain});
        Entry entry = this.ds.newEntry(dn);
        entry.add("objectClass", new String[]{"top", "domain"});
        entry.add("dc", new String[]{orgName});
        this.ds.getAdminSession().add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initKDCServer() throws Exception {
        String orgName = this.conf.getProperty("org.name");
        String orgDomain = this.conf.getProperty("org.domain");
        String bindAddress = this.conf.getProperty("kdc.bind.address");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", orgName.toLowerCase(Locale.ENGLISH));
        map.put("1", orgDomain.toLowerCase(Locale.ENGLISH));
        map.put("2", orgName.toUpperCase(Locale.ENGLISH));
        map.put("3", orgDomain.toUpperCase(Locale.ENGLISH));
        map.put("4", bindAddress);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is1 = cl.getResourceAsStream("minikdc.ldiff");
        SchemaManager schemaManager = this.ds.getSchemaManager();
        LdifReader reader = null;
        try {
            String content = StrSubstitutor.replace((Object)IOUtils.toString((InputStream)is1), map);
            reader = new LdifReader((Reader)new StringReader(content));
            for (LdifEntry ldifEntry : reader) {
                this.ds.getAdminSession().add((Entry)new DefaultEntry(schemaManager, ldifEntry.getEntry()));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)is1);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        IOUtils.closeQuietly((InputStream)is1);
        KerberosConfig kerberosConfig = new KerberosConfig();
        kerberosConfig.setMaximumRenewableLifetime(Long.parseLong(this.conf.getProperty("max.renewable.lifetime")));
        kerberosConfig.setMaximumTicketLifetime(Long.parseLong(this.conf.getProperty("max.ticket.lifetime")));
        kerberosConfig.setSearchBaseDn(String.format("dc=%s,dc=%s", orgName, orgDomain));
        kerberosConfig.setPaEncTimestampRequired(false);
        this.kdc = new KdcServer(kerberosConfig);
        this.kdc.setDirectoryService(this.ds);
        String transport = this.conf.getProperty("transport");
        if (transport.trim().equals("TCP")) {
            this.kdc.addTransports(new Transport[]{new TcpTransport(bindAddress, this.port, 3, 50)});
        } else if (transport.trim().equals("UDP")) {
            this.kdc.addTransports(new Transport[]{new UdpTransport(this.port)});
        } else {
            throw new IllegalArgumentException("Invalid transport: " + transport);
        }
        this.kdc.setServiceName(this.conf.getProperty("instance"));
        this.kdc.start();
        StringBuilder sb = new StringBuilder();
        InputStream is2 = cl.getResourceAsStream("minikdc-krb5.conf");
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(is2, Charsets.UTF_8));
            String line = r.readLine();
            while (line != null) {
                sb.append(line).append("{3}");
                line = r.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(r);
            IOUtils.closeQuietly((InputStream)is2);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)r);
        IOUtils.closeQuietly((InputStream)is2);
        this.krb5conf = new File(this.workDir, "krb5.conf").getAbsoluteFile();
        FileUtils.writeStringToFile((File)this.krb5conf, (String)MessageFormat.format(sb.toString(), this.getRealm(), this.getHost(), Integer.toString(this.getPort()), System.getProperty("line.separator")));
        System.setProperty("java.security.krb5.conf", this.krb5conf.getAbsolutePath());
        System.setProperty("sun.security.krb5.debug", this.conf.getProperty("debug", "false"));
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method refreshMethod = classRef.getMethod("refresh", new Class[0]);
        refreshMethod.invoke(classRef, new Object[0]);
        LOG.info("MiniKdc listening at port: {}", (Object)this.getPort());
        LOG.info("MiniKdc setting JVM krb5.conf to: {}", (Object)this.krb5conf.getAbsolutePath());
    }

    public synchronized void stop() {
        if (this.kdc != null) {
            System.getProperties().remove("java.security.krb5.conf");
            System.getProperties().remove("sun.security.krb5.debug");
            this.kdc.stop();
            try {
                this.ds.shutdown();
            }
            catch (Exception ex) {
                LOG.error("Could not shutdown ApacheDS properly: {}", (Object)ex.toString(), (Object)ex);
            }
        }
        this.delete(this.workDir);
    }

    private void delete(File f) {
        if (f.isFile()) {
            if (!f.delete()) {
                LOG.warn("WARNING: cannot delete file " + f.getAbsolutePath());
            }
        } else {
            for (File c : f.listFiles()) {
                this.delete(c);
            }
            if (!f.delete()) {
                LOG.warn("WARNING: cannot delete directory " + f.getAbsolutePath());
            }
        }
    }

    public synchronized void createPrincipal(String principal, String password) throws Exception {
        String orgName = this.conf.getProperty("org.name");
        String orgDomain = this.conf.getProperty("org.domain");
        String baseDn = "ou=users,dc=" + orgName.toLowerCase(Locale.ENGLISH) + ",dc=" + orgDomain.toLowerCase(Locale.ENGLISH);
        String content = "dn: uid=" + principal + "," + baseDn + "\n" + "objectClass: top\n" + "objectClass: person\n" + "objectClass: inetOrgPerson\n" + "objectClass: krb5principal\n" + "objectClass: krb5kdcentry\n" + "cn: " + principal + "\n" + "sn: " + principal + "\n" + "uid: " + principal + "\n" + "userPassword: " + password + "\n" + "krb5PrincipalName: " + principal + "@" + this.getRealm() + "\n" + "krb5KeyVersionNumber: 0";
        for (LdifEntry ldifEntry : new LdifReader((Reader)new StringReader(content))) {
            this.ds.getAdminSession().add((Entry)new DefaultEntry(this.ds.getSchemaManager(), ldifEntry.getEntry()));
        }
    }

    public void createPrincipal(File keytabFile, String ... principals) throws Exception {
        String generatedPassword = UUID.randomUUID().toString();
        Keytab keytab = new Keytab();
        ArrayList<KeytabEntry> entries = new ArrayList<KeytabEntry>();
        for (String principal : principals) {
            this.createPrincipal(principal, generatedPassword);
            principal = principal + "@" + this.getRealm();
            KerberosTime timestamp = new KerberosTime();
            for (Map.Entry entry : KerberosKeyFactory.getKerberosKeys((String)principal, (String)generatedPassword).entrySet()) {
                EncryptionKey ekey = (EncryptionKey)entry.getValue();
                byte keyVersion = (byte)ekey.getKeyVersion();
                entries.add(new KeytabEntry(principal, 1L, timestamp, keyVersion, ekey));
            }
        }
        keytab.setEntries(entries);
        keytab.write(keytabFile);
    }

    static {
        PROPERTIES.add("org.name");
        PROPERTIES.add("org.domain");
        PROPERTIES.add("kdc.bind.address");
        PROPERTIES.add("kdc.bind.address");
        PROPERTIES.add("kdc.port");
        PROPERTIES.add("instance");
        PROPERTIES.add("transport");
        PROPERTIES.add("max.ticket.lifetime");
        PROPERTIES.add("max.renewable.lifetime");
        DEFAULT_CONFIG.setProperty("kdc.bind.address", "localhost");
        DEFAULT_CONFIG.setProperty("kdc.port", "0");
        DEFAULT_CONFIG.setProperty("instance", "DefaultKrbServer");
        DEFAULT_CONFIG.setProperty("org.name", "EXAMPLE");
        DEFAULT_CONFIG.setProperty("org.domain", "COM");
        DEFAULT_CONFIG.setProperty("transport", "TCP");
        DEFAULT_CONFIG.setProperty("max.ticket.lifetime", "86400000");
        DEFAULT_CONFIG.setProperty("max.renewable.lifetime", "604800000");
        DEFAULT_CONFIG.setProperty("debug", "false");
    }
}

