/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.minikdc;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.directory.server.kerberos.shared.keytab.Keytab;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.hadoop.minikdc.KerberosSecurityTestcase;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.minikdc.TestMiniKdc;
import org.junit.Assert;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMiniKdc
extends KerberosSecurityTestcase {
    @Test
    public void testMiniKdcStart() {
        MiniKdc kdc = this.getKdc();
        Assert.assertNotSame((Object)0, (Object)kdc.getPort());
    }

    @Test
    public void testKeytabGen() throws Exception {
        MiniKdc kdc = this.getKdc();
        File workDir = this.getWorkDir();
        kdc.createPrincipal(new File(workDir, "keytab"), new String[]{"foo/bar", "bar/foo"});
        Keytab kt = Keytab.read((File)new File(workDir, "keytab"));
        HashSet<String> principals = new HashSet<String>();
        for (KeytabEntry entry : kt.getEntries()) {
            principals.add(entry.getPrincipalName());
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("foo\\bar@" + kdc.getRealm(), "bar\\foo@" + kdc.getRealm())), principals);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKerberosLogin() throws Exception {
        MiniKdc kdc = this.getKdc();
        File workDir = this.getWorkDir();
        LoginContext loginContext = null;
        try {
            String principal = "foo";
            File keytab = new File(workDir, "foo.keytab");
            kdc.createPrincipal(keytab, new String[]{principal});
            HashSet<KerberosPrincipal> principals = new HashSet<KerberosPrincipal>();
            principals.add(new KerberosPrincipal(principal));
            Subject subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosConfiguration.createClientConfig((String)principal, (File)keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assert.assertEquals((long)1L, (long)subject.getPrincipals().size());
            Assert.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assert.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
            subject = new Subject(false, principals, new HashSet(), new HashSet());
            loginContext = new LoginContext("", subject, null, KerberosConfiguration.createServerConfig((String)principal, (File)keytab));
            loginContext.login();
            subject = loginContext.getSubject();
            Assert.assertEquals((long)1L, (long)subject.getPrincipals().size());
            Assert.assertEquals(KerberosPrincipal.class, subject.getPrincipals().iterator().next().getClass());
            Assert.assertEquals((Object)(principal + "@" + kdc.getRealm()), (Object)subject.getPrincipals().iterator().next().getName());
            loginContext.logout();
        }
        finally {
            if (loginContext != null) {
                loginContext.logout();
            }
        }
    }
}

