/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import java.util.zip.CRC32;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TeraOutputFormatWithCRC
extends TextOutputFormat<Text, Text> {
    static final String FINAL_SYNC_ATTRIBUTE = "terasort.final.sync";

    public static void setFinalSync(JobContext conf, boolean newValue) {
        conf.getConfiguration().setBoolean(FINAL_SYNC_ATTRIBUTE, newValue);
    }

    public static boolean getFinalSync(JobContext conf) {
        return conf.getConfiguration().getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext job) throws IOException {
        Path file = this.getDefaultWorkFile(job, "");
        FileSystem fs = file.getFileSystem(job.getConfiguration());
        FSDataOutputStream fileOut = fs.create(file);
        return new TeraRecordWriter(fileOut, (JobContext)job);
    }

    static class TeraRecordWriter
    extends RecordWriter<Text, Text> {
        private static final byte[] newLine = "\r\n".getBytes();
        private boolean finalSync = false;
        private String space = "";
        private int CRC_LEN = 20;
        private FSDataOutputStream out;

        public TeraRecordWriter(FSDataOutputStream out, JobContext conf) {
            this.out = out;
            this.finalSync = TeraOutputFormatWithCRC.getFinalSync(conf);
        }

        public synchronized void write(Text key, Text value) throws IOException {
            this.out.write(key.getBytes(), 0, key.getLength());
            StringBuilder spaces = new StringBuilder(this.CRC_LEN);
            byte[] valueToCksum = value.copyBytes();
            CRC32 checksum = new CRC32();
            checksum.update(key.getBytes());
            System.out.println("key checksum: " + checksum.getValue());
            checksum.update(valueToCksum, 0, valueToCksum.length);
            System.out.println("total checksum: " + checksum.getValue());
            long cksum = checksum.getValue();
            byte[] cksum_bytes = Long.toString(cksum).getBytes();
            int padspaces = this.CRC_LEN - cksum_bytes.length;
            if (padspaces > 0) {
                for (int i = 0; i < padspaces; ++i) {
                    spaces.append(' ');
                }
                value.append(spaces.toString().getBytes(), 0, spaces.toString().getBytes().length);
            }
            value.append(cksum_bytes, 0, cksum_bytes.length);
            this.out.write(value.getBytes(), 0, value.getLength());
        }

        public void close(TaskAttemptContext context) throws IOException {
            if (this.finalSync) {
                this.out.sync();
            }
            this.out.close();
        }
    }
}

