/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.IOException;
import org.apache.hadoop.examples.terasort.TeraOutputFormatWithCRC;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TeraOutputFormatWithCRC
extends TextOutputFormat<Text, Text> {
    static final String FINAL_SYNC_ATTRIBUTE = "terasort.final.sync";

    public static void setFinalSync(JobContext conf, boolean newValue) {
        conf.getConfiguration().setBoolean(FINAL_SYNC_ATTRIBUTE, newValue);
    }

    public static boolean getFinalSync(JobContext conf) {
        return conf.getConfiguration().getBoolean(FINAL_SYNC_ATTRIBUTE, false);
    }

    public RecordWriter<Text, Text> getRecordWriter(TaskAttemptContext job) throws IOException {
        Path file = this.getDefaultWorkFile(job, "");
        FileSystem fs = file.getFileSystem(job.getConfiguration());
        FSDataOutputStream fileOut = fs.create(file);
        return new TeraRecordWriter(fileOut, (JobContext)job);
    }
}

