/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraValidateRecords;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraValidateRecords
extends Configured
implements Tool {
    static Log LOG = LogFactory.getLog(TeraValidateRecords.class);

    public int run(String[] args) throws Exception {
        Job job = Job.getInstance((Configuration)this.getConf());
        Configuration conf = job.getConfiguration();
        int num_records = 0;
        int num_reducers = 1;
        String inputPath = null;
        String outputPath = null;
        if (args.length >= 4) {
            num_records = Integer.parseInt(args[0]);
            num_reducers = Integer.parseInt(args[1]);
            inputPath = args[2];
            outputPath = args[3];
        } else {
            LOG.error((Object)"Usage: teravalidaterecords <number of records> <number of reducers><input> <output>");
            System.exit(1);
        }
        conf.setLong("map.num.records", (long)num_records);
        TeraInputFormatWithCRC.setInputPaths((Job)job, inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputPath));
        job.setJobName("TeraValidateRecords");
        job.setJarByClass(TeraValidateRecords.class);
        job.setMapperClass(TeraValidateMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setReducerClass(TeraValidateReducer.class);
        job.setNumReduceTasks(num_reducers);
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(TeraInputFormatWithCRC.class);
        job.setOutputFormatClass(TextOutputFormat.class);
        return job.waitForCompletion(true) ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraValidateRecords(), (String[])args);
        System.exit(res);
    }
}

