/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.examples.pi.Container;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Bellard;
import org.apache.hadoop.examples.pi.math.Modular;
import org.apache.hadoop.examples.pi.math.Summation;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Bellard {
    public static <T extends Container<Summation>> Map<Parameter, Sum> getSums(long b, int partsPerSum, Map<Parameter, List<T>> existing) {
        TreeMap<Parameter, Sum> sums = new TreeMap<Parameter, Sum>();
        for (Parameter p : Parameter.values()) {
            Sum s = new Sum(b, p, partsPerSum, existing.get(p), null);
            Util.out.println("put " + s);
            sums.put(p, s);
        }
        return sums;
    }

    public static <T extends Container<Summation>> double computePi(long b, Map<Parameter, T> results) {
        if (results.size() != Parameter.values().length) {
            throw new IllegalArgumentException("m.size() != Parameter.values().length, m.size()=" + results.size() + "\n  m=" + results);
        }
        double pi = 0.0;
        for (Parameter p : Parameter.values()) {
            Summation sigma = (Summation)((Container)results.get(p)).getElement();
            Sum s = new Sum(b, p, 1, null, null);
            s.setValue(sigma);
            pi = Modular.addMod((double)pi, (double)s.getValue());
        }
        return pi;
    }

    public static double computePi(long b) {
        double pi = 0.0;
        for (Parameter p : Parameter.values()) {
            pi = Modular.addMod((double)pi, (double)new Sum(b, p, 1, null, null).getValue());
        }
        return pi;
    }

    public static long bit2terms(long b) {
        return 7L * (b / 10L);
    }

    private static void computePi(Util.Timer t, long b) {
        t.tick(Util.pi2string((double)Bellard.computePi((long)b), (long)Bellard.bit2terms((long)b)));
    }

    public static void main(String[] args) throws IOException {
        Util.Timer t = new Util.Timer(false);
        Bellard.computePi((Util.Timer)t, (long)0L);
        Bellard.computePi((Util.Timer)t, (long)1L);
        Bellard.computePi((Util.Timer)t, (long)2L);
        Bellard.computePi((Util.Timer)t, (long)3L);
        Bellard.computePi((Util.Timer)t, (long)4L);
        Util.printBitSkipped((long)1008L);
        Bellard.computePi((Util.Timer)t, (long)1008L);
        Bellard.computePi((Util.Timer)t, (long)1012L);
        long b = 10L;
        for (int i = 0; i < 7; ++i) {
            Util.printBitSkipped((long)b);
            Bellard.computePi((Util.Timer)t, (long)(b - 4L));
            Bellard.computePi((Util.Timer)t, (long)b);
            Bellard.computePi((Util.Timer)t, (long)(b + 4L));
            b *= 10L;
        }
    }
}

