/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraOutputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraSortWithCRC;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraSortWithCRC
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(TeraSortWithCRC.class);

    public int run(String[] args) throws Exception {
        LOG.info((Object)"starting");
        Job job = Job.getInstance((Configuration)this.getConf());
        Path inputDir = new Path(args[0]);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem(job.getConfiguration()));
        Path partitionFile = new Path(inputDir, "_partition.lst");
        URI partitionUri = new URI(partitionFile.toString() + "#" + "_partition.lst");
        TeraInputFormatWithCRC.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        job.setJobName("TeraSortWithCRC");
        job.setJarByClass(TeraSortWithCRC.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(TeraInputFormatWithCRC.class);
        job.setOutputFormatClass(TeraOutputFormatWithCRC.class);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TeraInputFormatWithCRC.writePartitionFile((JobContext)job, (Path)partitionFile);
        job.addCacheFile(partitionUri);
        DistributedCache.createSymlink((Configuration)job.getConfiguration());
        job.getConfiguration().setInt("dfs.replication", 1);
        TeraOutputFormatWithCRC.setFinalSync((JobContext)job, (boolean)true);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        LOG.info((Object)"done");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraSortWithCRC(), (String[])args);
        System.exit(res);
    }
}

