/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MRJobConfig;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.StringUtils;

public class TeraInputFormatWithCRC
extends FileInputFormat<Text, Text> {
    static final String PARTITION_FILENAME = "_partition.lst";
    static final String SAMPLE_SIZE = "terasort.partitions.sample";
    private static MRJobConfig lastContext = null;
    private static List<InputSplit> lastResult = null;

    public static void writePartitionFile(JobContext job, Path partFile) throws IOException {
        TeraInputFormatWithCRC inFormat = new TeraInputFormatWithCRC();
        TextSampler sampler = new TextSampler();
        Configuration conf = job.getConfiguration();
        int partitions = job.getNumReduceTasks();
        long sampleSize = conf.getLong(SAMPLE_SIZE, 100000L);
        List splits = inFormat.getSplits(job);
        int samples = Math.min(10, splits.size());
        long recordsPerSample = sampleSize / (long)samples;
        int sampleStep = splits.size() / samples;
        long records = 0L;
        TaskAttemptContextImpl context = new TaskAttemptContextImpl(job.getConfiguration(), new TaskAttemptID());
        block3: for (int i = 0; i < samples; ++i) {
            try {
                RecordReader reader = inFormat.createRecordReader((InputSplit)splits.get(sampleStep * i), (TaskAttemptContext)context);
                reader.initialize((InputSplit)splits.get(sampleStep * i), (TaskAttemptContext)context);
                while (reader.nextKeyValue()) {
                    if (((Text)reader.getCurrentKey()).getLength() <= 0) continue;
                    sampler.addKey(new Text((Text)reader.getCurrentKey()));
                    if ((long)(i + 1) * recordsPerSample > ++records) continue;
                    continue block3;
                }
                continue;
            }
            catch (IOException ie) {
                System.err.println("Got an exception while reading splits " + StringUtils.stringifyException((Throwable)ie));
                throw new RuntimeException(ie);
            }
            catch (InterruptedException iex) {
                // empty catch block
            }
        }
        FileSystem outFs = partFile.getFileSystem(conf);
        if (outFs.exists(partFile)) {
            outFs.delete(partFile, false);
        }
        FSDataOutputStream writer = outFs.create(partFile, true, 65536, (short)10, outFs.getDefaultBlockSize(partFile));
        for (Text split : sampler.createPartitions(partitions)) {
            split.write((DataOutput)writer);
        }
        writer.close();
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        if (job == lastContext) {
            return lastResult;
        }
        lastContext = job;
        lastResult = super.getSplits(job);
        return lastResult;
    }

    public RecordReader<Text, Text> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new TeraRecordReader();
    }
}

