/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.terasort;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.terasort.TeraInputFormatWithCRC;
import org.apache.hadoop.examples.terasort.TeraValidateRecords;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TeraValidateRecords
extends Configured
implements Tool {
    static Log LOG = LogFactory.getLog(TeraValidateRecords.class);

    public int run(String[] args) throws Exception {
        JobConf conf = (JobConf)this.getConf();
        int num_records = 0;
        int num_reducers = 1;
        String inputPath = null;
        String outputPath = null;
        if (args.length >= 4) {
            num_records = Integer.parseInt(args[0]);
            num_reducers = Integer.parseInt(args[1]);
            inputPath = args[2];
            outputPath = args[3];
        } else {
            LOG.error((Object)"Usage: teravalidaterecords <number of records> <number of reducers><input> <output>");
            System.exit(1);
        }
        conf.setLong("map.num.records", (long)num_records);
        TeraInputFormatWithCRC.setInputPaths((JobConf)conf, inputPath);
        FileOutputFormat.setOutputPath((JobConf)conf, (Path)new Path(outputPath));
        conf.setJobName("TeraValidateRecords");
        conf.setJarByClass(TeraValidateRecords.class);
        conf.setMapperClass(TeraValidateMapper.class);
        conf.setMapOutputKeyClass(IntWritable.class);
        conf.setMapOutputValueClass(LongWritable.class);
        conf.setReducerClass(TeraValidateReducer.class);
        conf.setNumReduceTasks(num_reducers);
        conf.setOutputKeyClass(LongWritable.class);
        conf.setOutputValueClass(Text.class);
        conf.setInputFormat(TeraInputFormatWithCRC.class);
        conf.setOutputFormat(TextOutputFormat.class);
        JobClient.runJob((JobConf)conf);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new TeraValidateRecords(), (String[])args);
        System.exit(res);
    }
}

