/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.math.BigInteger;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.examples.pi.Util;
import org.apache.hadoop.examples.pi.math.Modular;
import org.apache.hadoop.examples.pi.math.TestModular;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestModular
extends TestCase {
    private static final Random RANDOM = new Random();
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    static final int DIV_VALID_BIT = 32;
    static final long DIV_LIMIT = 0x100000000L;

    static long div(long sum, long r, long n) {
        long q = 0L;
        int i = 31;
        r <<= 1;
        while (r < n) {
            --i;
            r <<= 1;
        }
        while (i >= 0) {
            q |= 1L << i;
            if ((r -= n) <= 0L) break;
            while (r < n) {
                --i;
                r <<= 1;
            }
        }
        return (sum += q) < 0x100000000L ? sum : sum - 0x100000000L;
    }

    public void testDiv() {
        for (long n = 2L; n < 100L; ++n) {
            for (long r = 1L; r < n; ++r) {
                long a = TestModular.div((long)0L, (long)r, (long)n);
                long b = (long)((double)r * 1.0 / (double)n * 4.294967296E9);
                String s = String.format("r=%d, n=%d, a=%X, b=%X", r, n, a, b);
                TestModular.assertEquals((String)s, (long)b, (long)a);
            }
        }
    }

    static long[][][] generateRN(int nsize, int rsize) {
        long[][][] rn = new long[nsize][][];
        for (int i = 0; i < rn.length; ++i) {
            rn[i] = new long[rsize + 1][];
            long n = RANDOM.nextLong() & 0xFFFFFFFFFFFFFFFL;
            if (n <= 1L) {
                n = 0xFFFFFFFFFFFFFFFL - n;
            }
            rn[i][0] = new long[]{n};
            BigInteger N = BigInteger.valueOf(n);
            for (int j = 1; j < rn[i].length; ++j) {
                long r = RANDOM.nextLong();
                if (r < 0L) {
                    r = -r;
                }
                if (r >= n) {
                    r %= n;
                }
                BigInteger R = BigInteger.valueOf(r);
                rn[i][j] = new long[]{r, R.multiply(R).mod(N).longValue()};
            }
        }
        return rn;
    }

    static long square_slow(long z, long n) {
        long r = 0L;
        long s = z;
        while (z > 0L) {
            if (((int)z & 1) == 1 && (r += s) >= n) {
                r -= n;
            }
            if ((s <<= 1) >= n) {
                s -= n;
            }
            z >>= 1;
        }
        return r;
    }

    static long square(long r, long n, long r2p64) {
        if (r <= Modular.MAX_SQRT_LONG) {
            if ((r *= r) >= n) {
                r %= n;
            }
        } else {
            int HALF = 63 - Long.numberOfLeadingZeros(n) >> 1;
            int FULL = HALF << 1;
            long ONES = (1 << HALF) - 1;
            long high = r >>> HALF;
            long low = r &= ONES;
            if ((r *= r) >= n) {
                r %= n;
            }
            if (high != 0L) {
                long s = high * high;
                if (s >= n) {
                    s %= n;
                }
                for (int i = 0; i < FULL; ++i) {
                    if ((s <<= 1) < n) continue;
                    s -= n;
                }
                if (low == 0L) {
                    r = s;
                } else {
                    long t = high * low;
                    if (t >= n) {
                        t %= n;
                    }
                    for (int i = -1; i < HALF; ++i) {
                        if ((t <<= 1) < n) continue;
                        t -= n;
                    }
                    if ((r += s) >= n) {
                        r -= n;
                    }
                    if ((r += t) >= n) {
                        r -= n;
                    }
                }
            }
        }
        return r;
    }

    static void squareBenchmarks() {
        BigInteger R;
        long answer;
        long s;
        long n;
        int i;
        Util.Timer t = new Util.Timer(false);
        t.tick("squareBenchmarks(), MAX_SQRT=" + Modular.MAX_SQRT_LONG);
        long[][][] rn = TestModular.generateRN((int)1000, (int)1000);
        t.tick("generateRN");
        for (i = 0; i < rn.length; ++i) {
            n = rn[i][0][0];
            for (int j = 1; j < rn[i].length; ++j) {
                long r = rn[i][j][0];
                long answer2 = rn[i][j][1];
                long s2 = TestModular.square_slow((long)r, (long)n);
                if (s2 == answer2) continue;
                TestModular.assertEquals((String)("r=" + r + ", n=" + n + ", answer=" + answer2 + " but s=" + s2), (long)answer2, (long)s2);
            }
        }
        t.tick("square_slow");
        for (i = 0; i < rn.length; ++i) {
            n = rn[i][0][0];
            long r2p64 = 0x4000000000000000L % n << 1;
            if (r2p64 >= n) {
                r2p64 -= n;
            }
            for (int j = 1; j < rn[i].length; ++j) {
                long r = rn[i][j][0];
                long answer3 = rn[i][j][1];
                s = TestModular.square((long)r, (long)n, (long)r2p64);
                if (s == answer3) continue;
                TestModular.assertEquals((String)("r=" + r + ", n=" + n + ", answer=" + answer3 + " but s=" + s), (long)answer3, (long)s);
            }
        }
        t.tick("square");
        for (i = 0; i < rn.length; ++i) {
            n = rn[i][0][0];
            BigInteger N = BigInteger.valueOf(n);
            for (int j = 1; j < rn[i].length; ++j) {
                long r = rn[i][j][0];
                answer = rn[i][j][1];
                R = BigInteger.valueOf(r);
                s = R.multiply(R).mod(N).longValue();
                if (s == answer) continue;
                TestModular.assertEquals((String)("r=" + r + ", n=" + n + ", answer=" + answer + " but s=" + s), (long)answer, (long)s);
            }
        }
        t.tick("R.multiply(R).mod(N)");
        for (i = 0; i < rn.length; ++i) {
            n = rn[i][0][0];
            BigInteger N = BigInteger.valueOf(n);
            for (int j = 1; j < rn[i].length; ++j) {
                long r = rn[i][j][0];
                answer = rn[i][j][1];
                R = BigInteger.valueOf(r);
                s = R.modPow(TWO, N).longValue();
                if (s == answer) continue;
                TestModular.assertEquals((String)("r=" + r + ", n=" + n + ", answer=" + answer + " but s=" + s), (long)answer, (long)s);
            }
        }
        t.tick("R.modPow(TWO, N)");
    }

    static long[][][] generateEN(int nsize, int esize) {
        long[][][] en = new long[nsize][][];
        for (int i = 0; i < en.length; ++i) {
            en[i] = new long[esize + 1][];
            long n = RANDOM.nextLong() & 0xFFFFFFFFFFFFFFFL | 1L;
            if (n == 1L) {
                n = 3L;
            }
            en[i][0] = new long[]{n};
            BigInteger N = BigInteger.valueOf(n);
            for (int j = 1; j < en[i].length; ++j) {
                long e = RANDOM.nextLong();
                if (e < 0L) {
                    e = -e;
                }
                BigInteger E = BigInteger.valueOf(e);
                en[i][j] = new long[]{e, TWO.modPow(E, N).longValue()};
            }
        }
        return en;
    }

    static long modBigInteger(long e, long n) {
        long mask = (e & 0xFFFFFFFF00000000L) == 0L ? 0xFFFFFFFFL : -4294967296L;
        mask &= (e & 0xAAAAAAAAAAAAAAAAL & (mask &= (e & 0xCCCCCCCCCCCCCCCCL & (mask &= (e & 0xF0F0F0F0F0F0F0F0L & (mask &= (e & 0xFF00FF00FF00FF00L & (mask &= (e & 0xFFFF0000FFFF0000L & mask) == 0L ? 0xFFFF0000FFFFL : -281470681808896L)) == 0L ? 0xFF00FF00FF00FFL : -71777214294589696L)) == 0L ? 0xF0F0F0F0F0F0F0FL : -1085102592571150096L)) == 0L ? 0x3333333333333333L : -3689348814741910324L)) == 0L ? 0x5555555555555555L : -6148914691236517206L;
        BigInteger N = BigInteger.valueOf(n);
        long r = 2L;
        mask >>= 1;
        while (mask > 0L) {
            if (r <= Modular.MAX_SQRT_LONG) {
                if ((r *= r) >= n) {
                    r %= n;
                }
            } else {
                BigInteger R = BigInteger.valueOf(r);
                r = R.multiply(R).mod(N).longValue();
            }
            if ((e & mask) != 0L && (r <<= 1) >= n) {
                r -= n;
            }
            mask >>= 1;
        }
        return r;
    }

    static void modBenchmarks() {
        long s;
        long answer;
        long e;
        long n;
        int i;
        Util.Timer t = new Util.Timer(false);
        t.tick("modBenchmarks()");
        long[][][] en = TestModular.generateEN((int)10000, (int)10);
        t.tick("generateEN");
        for (int i2 = 0; i2 < en.length; ++i2) {
            long n2 = en[i2][0][0];
            for (int j = 1; j < en[i2].length; ++j) {
                long e2 = en[i2][j][0];
                long answer2 = en[i2][j][1];
                long s2 = Modular.mod((long)e2, (long)n2);
                if (s2 == answer2) continue;
                TestModular.assertEquals((String)("e=" + e2 + ", n=" + n2 + ", answer=" + answer2 + " but s=" + s2), (long)answer2, (long)s2);
            }
        }
        t.tick("Modular.mod");
        Montgomery2 m2 = new Montgomery2();
        for (i = 0; i < en.length; ++i) {
            n = en[i][0][0];
            m2.set(n);
            for (int j = 1; j < en[i].length; ++j) {
                e = en[i][j][0];
                answer = en[i][j][1];
                s = m2.mod(e);
                if (s == answer) continue;
                TestModular.assertEquals((String)("e=" + e + ", n=" + n + ", answer=" + answer + " but s=" + s), (long)answer, (long)s);
            }
        }
        t.tick("montgomery.mod");
        for (i = 0; i < en.length; ++i) {
            n = en[i][0][0];
            m2.set(n);
            for (int j = 1; j < en[i].length; ++j) {
                e = en[i][j][0];
                answer = en[i][j][1];
                s = m2.mod2(e);
                if (s == answer) continue;
                TestModular.assertEquals((String)("e=" + e + ", n=" + n + ", answer=" + answer + " but s=" + s), (long)answer, (long)s);
            }
        }
        t.tick("montgomery.mod2");
        for (i = 0; i < en.length; ++i) {
            n = en[i][0][0];
            BigInteger N = BigInteger.valueOf(n);
            for (int j = 1; j < en[i].length; ++j) {
                long e3 = en[i][j][0];
                long answer3 = en[i][j][1];
                long s3 = TWO.modPow(BigInteger.valueOf(e3), N).longValue();
                if (s3 == answer3) continue;
                TestModular.assertEquals((String)("e=" + e3 + ", n=" + n + ", answer=" + answer3 + " but s=" + s3), (long)answer3, (long)s3);
            }
        }
        t.tick("BigInteger.modPow(e, n)");
    }

    public static void main(String[] args) {
        TestModular.squareBenchmarks();
        TestModular.modBenchmarks();
    }
}

