/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi.math;

import java.math.BigInteger;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.examples.pi.math.LongLong;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestLongLong
extends TestCase {
    static final Random RAN = new Random();
    static final long MASK = 0x3FFFFFFFFFFFFFFFL;

    static long nextPositiveLong() {
        return RAN.nextLong() & 0x3FFFFFFFFFFFFFFFL;
    }

    static void verifyMultiplication(long a, long b) {
        LongLong ll = LongLong.multiplication((LongLong)new LongLong(), (long)a, (long)b);
        BigInteger bi = BigInteger.valueOf(a).multiply(BigInteger.valueOf(b));
        String s = String.format("\na = %x\nb = %x\nll= " + ll + "\nbi= " + bi.toString(16) + "\n", a, b);
        TestLongLong.assertEquals((String)s, (Object)bi, (Object)ll.toBigInteger());
    }

    public void testMultiplication() {
        for (int i = 0; i < 100; ++i) {
            long a = TestLongLong.nextPositiveLong();
            long b = TestLongLong.nextPositiveLong();
            TestLongLong.verifyMultiplication((long)a, (long)b);
        }
        long max = 0x3FFFFFFFFFFFFFFFL;
        TestLongLong.verifyMultiplication((long)0x3FFFFFFFFFFFFFFFL, (long)0x3FFFFFFFFFFFFFFFL);
    }

    static void verifyRightShift(long a, long b) {
        LongLong ll = new LongLong().set(a, b);
        BigInteger bi = ll.toBigInteger();
        for (int i = 0; i < 62; ++i) {
            long result = ll.shiftRight(i) & 0x3FFFFFFFFFFFFFFFL;
            long expected = bi.shiftRight(i).longValue() & 0x3FFFFFFFFFFFFFFFL;
            String s = String.format("\na = %x\nb = %x\nll= " + ll + "\nbi= " + bi.toString(16) + "\n", a, b);
            TestLongLong.assertEquals((String)s, (long)expected, (long)result);
        }
        String s = String.format("\na = %x\nb = %x\nll= " + ll + "\nbi= " + bi.toString(16) + "\n", a, b);
        TestLongLong.assertEquals((String)s, (Object)bi, (Object)ll.toBigInteger());
    }

    public void testRightShift() {
        for (int i = 0; i < 1000; ++i) {
            long a = TestLongLong.nextPositiveLong();
            long b = TestLongLong.nextPositiveLong();
            TestLongLong.verifyMultiplication((long)a, (long)b);
        }
    }
}

