/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.blocklocality;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.blocklocality.BlockLocality;
import org.apache.hadoop.examples.blocklocality.LocalityInputFormat;
import org.apache.hadoop.examples.blocklocality.LocalityOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class BlockLocality
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(BlockLocality.class);

    public int run(String[] args) throws Exception {
        LOG.info((Object)"starting");
        JobConf job = (JobConf)this.getConf();
        Path inputDir = new Path(args[0]);
        inputDir = inputDir.makeQualified(inputDir.getFileSystem((Configuration)job));
        LocalityInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{new Path(args[0])});
        LocalityOutputFormat.setOutputPath((JobConf)job, (Path)new Path(args[1]));
        LocalityOutputFormat.setFinalSync((JobConf)job, (boolean)true);
        job.setJobName("BlockLocality");
        job.setJarByClass(BlockLocality.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(IntWritable.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormat(LocalityInputFormat.class);
        job.setOutputFormat(LocalityOutputFormat.class);
        job.setMapperClass(BlockLocalityMapper.class);
        job.setReducerClass(BlockLocalityReducer.class);
        job.set("mapred.reduce.tasks", "1");
        JobClient.runJob((JobConf)job);
        LOG.info((Object)"done");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new JobConf(), (Tool)new BlockLocality(), (String[])args);
        System.exit(res);
    }
}

