/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.SleepJob;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Partitioner;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SleepJob
extends Configured
implements Tool,
Mapper<IntWritable, IntWritable, IntWritable, NullWritable>,
Reducer<IntWritable, NullWritable, NullWritable, NullWritable>,
Partitioner<IntWritable, NullWritable> {
    private long mapSleepDuration = 100L;
    private long reduceSleepDuration = 100L;
    private int mapSleepCount = 1;
    private int reduceSleepCount = 1;
    private int count = 0;

    public int getPartition(IntWritable k, NullWritable v, int numPartitions) {
        return k.get() % numPartitions;
    }

    public void map(IntWritable key, IntWritable value, OutputCollector<IntWritable, NullWritable> output, Reporter reporter) throws IOException {
        try {
            reporter.setStatus("Sleeping... (" + this.mapSleepDuration * (long)(this.mapSleepCount - this.count) + ") ms left");
            Thread.sleep(this.mapSleepDuration);
        }
        catch (InterruptedException ex) {
            throw (IOException)new IOException("Interrupted while sleeping").initCause(ex);
        }
        ++this.count;
        int k = key.get();
        for (int i = 0; i < value.get(); ++i) {
            output.collect((Object)new IntWritable(k + i), (Object)NullWritable.get());
        }
    }

    public void reduce(IntWritable key, Iterator<NullWritable> values, OutputCollector<NullWritable, NullWritable> output, Reporter reporter) throws IOException {
        try {
            reporter.setStatus("Sleeping... (" + this.reduceSleepDuration * (long)(this.reduceSleepCount - this.count) + ") ms left");
            Thread.sleep(this.reduceSleepDuration);
        }
        catch (InterruptedException ex) {
            throw (IOException)new IOException("Interrupted while sleeping").initCause(ex);
        }
        ++this.count;
    }

    public void configure(JobConf job) {
        this.mapSleepCount = job.getInt("sleep.job.map.sleep.count", this.mapSleepCount);
        this.reduceSleepCount = job.getInt("sleep.job.reduce.sleep.count", this.reduceSleepCount);
        this.mapSleepDuration = job.getLong("sleep.job.map.sleep.time", 100L) / (long)this.mapSleepCount;
        this.reduceSleepDuration = job.getLong("sleep.job.reduce.sleep.time", 100L) / (long)this.reduceSleepCount;
    }

    public void close() throws IOException {
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SleepJob(), (String[])args);
        System.exit(res);
    }

    public int run(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) throws IOException {
        JobConf job = this.setupJobConf(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
        JobClient.runJob((JobConf)job);
        return 0;
    }

    public JobConf setupJobConf(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) {
        JobConf job = new JobConf(this.getConf(), SleepJob.class);
        job.setNumMapTasks(numMapper);
        job.setNumReduceTasks(numReducer);
        job.setMapperClass(SleepJob.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(SleepJob.class);
        job.setOutputFormat(NullOutputFormat.class);
        job.setInputFormat(SleepInputFormat.class);
        job.setPartitionerClass(SleepJob.class);
        job.setSpeculativeExecution(false);
        job.setJobName("Sleep job");
        FileInputFormat.addInputPath((JobConf)job, (Path)new Path("ignored"));
        job.setLong("sleep.job.map.sleep.time", mapSleepTime);
        job.setLong("sleep.job.reduce.sleep.time", reduceSleepTime);
        job.setInt("sleep.job.map.sleep.count", mapSleepCount);
        job.setInt("sleep.job.reduce.sleep.count", reduceSleepCount);
        return job;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("SleepJob [-m numMapper] [-r numReducer] [-mt mapSleepTime (msec)] [-rt reduceSleepTime (msec)] [-recordt recordSleepTime (msec)]");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return -1;
        }
        int numMapper = 1;
        int numReducer = 1;
        long mapSleepTime = 100L;
        long reduceSleepTime = 100L;
        long recSleepTime = 100L;
        int mapSleepCount = 1;
        int reduceSleepCount = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-m")) {
                numMapper = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-r")) {
                numReducer = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-mt")) {
                mapSleepTime = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-rt")) {
                reduceSleepTime = Long.parseLong(args[++i]);
                continue;
            }
            if (!args[i].equals("-recordt")) continue;
            recSleepTime = Long.parseLong(args[++i]);
        }
        mapSleepCount = (int)Math.ceil((double)mapSleepTime / (double)recSleepTime);
        reduceSleepCount = (int)Math.ceil((double)reduceSleepTime / (double)recSleepTime);
        return this.run(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount);
    }
}

