/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.PrintStream;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.RandomWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class RandomWriter
extends Configured
implements Tool {
    public static final String TOTAL_BYTES = "mapreduce.randomwriter.totalbytes";
    public static final String BYTES_PER_MAP = "mapreduce.randomwriter.bytespermap";
    public static final String MAPS_PER_HOST = "mapreduce.randomwriter.mapsperhost";
    public static final String MAX_VALUE = "mapreduce.randomwriter.maxvalue";
    public static final String MIN_VALUE = "mapreduce.randomwriter.minvalue";
    public static final String MIN_KEY = "mapreduce.randomwriter.minkey";
    public static final String MAX_KEY = "mapreduce.randomwriter.maxkey";

    public int run(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: writer <out-dir>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.out);
            return 2;
        }
        Path outDir = new Path(args[0]);
        Configuration conf = this.getConf();
        JobClient client = new JobClient(conf);
        ClusterStatus cluster = client.getClusterStatus();
        int numMapsPerHost = conf.getInt(MAPS_PER_HOST, 10);
        long numBytesToWritePerMap = conf.getLong(BYTES_PER_MAP, 0x40000000L);
        if (numBytesToWritePerMap == 0L) {
            System.err.println("Cannot havemapreduce.randomwriter.bytespermap set to 0");
            return -2;
        }
        long totalBytesToWrite = conf.getLong(TOTAL_BYTES, (long)numMapsPerHost * numBytesToWritePerMap * (long)cluster.getTaskTrackers());
        int numMaps = (int)(totalBytesToWrite / numBytesToWritePerMap);
        if (numMaps == 0 && totalBytesToWrite > 0L) {
            numMaps = 1;
            conf.setLong(BYTES_PER_MAP, totalBytesToWrite);
        }
        conf.setInt("mapreduce.job.maps", numMaps);
        Job job = new Job(conf);
        job.setJarByClass(RandomWriter.class);
        job.setJobName("random-writer");
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        job.setOutputKeyClass(BytesWritable.class);
        job.setOutputValueClass(BytesWritable.class);
        job.setInputFormatClass(RandomInputFormat.class);
        job.setMapperClass(RandomMapper.class);
        job.setReducerClass(Reducer.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        System.out.println("Running " + numMaps + " maps.");
        job.setNumReduceTasks(0);
        Date startTime = new Date();
        System.out.println("Job started: " + startTime);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        Date endTime = new Date();
        System.out.println("Job ended: " + endTime);
        System.out.println("The job took " + (endTime.getTime() - startTime.getTime()) / 1000L + " seconds.");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new RandomWriter(), (String[])args);
        System.exit(res);
    }
}

