/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples;

import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.examples.QuasiMonteCarlo;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuasiMonteCarlo
extends Configured
implements Tool {
    static final String DESCRIPTION = "A map/reduce program that estimates Pi using a quasi-Monte Carlo method.";
    private static final String TMP_DIR_PREFIX = QuasiMonteCarlo.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BigDecimal estimatePi(int numMaps, long numPoints, Path tmpDir, Configuration conf) throws IOException, ClassNotFoundException, InterruptedException {
        Job job = new Job(conf);
        job.setJobName(QuasiMonteCarlo.class.getSimpleName());
        job.setJarByClass(QuasiMonteCarlo.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputKeyClass(BooleanWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setMapperClass(QmcMapper.class);
        job.setReducerClass(QmcReducer.class);
        job.setNumReduceTasks(1);
        job.setSpeculativeExecution(false);
        Path inDir = new Path(tmpDir, "in");
        Path outDir = new Path(tmpDir, "out");
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(tmpDir)) {
            throw new IOException("Tmp directory " + fs.makeQualified(tmpDir) + " already exists.  Please remove it first.");
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Cannot create input directory " + inDir);
        }
        try {
            for (int i = 0; i < numMaps; ++i) {
                Path file = new Path(inDir, "part" + i);
                LongWritable offset = new LongWritable((long)i * numPoints);
                LongWritable size = new LongWritable(numPoints);
                SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)file, LongWritable.class, LongWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.NONE);
                try {
                    writer.append((Writable)offset, (Writable)size);
                }
                finally {
                    writer.close();
                }
                System.out.println("Wrote input for Map #" + i);
            }
            System.out.println("Starting Job");
            long startTime = System.currentTimeMillis();
            job.waitForCompletion(true);
            double duration = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            System.out.println("Job Finished in " + duration + " seconds");
            Path inFile = new Path(outDir, "reduce-out");
            LongWritable numInside = new LongWritable();
            LongWritable numOutside = new LongWritable();
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, inFile, conf);
            try {
                reader.next((Writable)numInside, (Writable)numOutside);
            }
            finally {
                reader.close();
            }
            BigDecimal numTotal = BigDecimal.valueOf(numMaps).multiply(BigDecimal.valueOf(numPoints));
            BigDecimal bigDecimal = BigDecimal.valueOf(4L).setScale(20).multiply(BigDecimal.valueOf(numInside.get())).divide(numTotal, RoundingMode.HALF_UP);
            return bigDecimal;
        }
        finally {
            fs.delete(tmpDir, true);
        }
    }

    public int run(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + this.getClass().getName() + " <nMaps> <nSamples>");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 2;
        }
        int nMaps = Integer.parseInt(args[0]);
        long nSamples = Long.parseLong(args[1]);
        long now = System.currentTimeMillis();
        int rand = new Random().nextInt(Integer.MAX_VALUE);
        Path tmpDir = new Path(TMP_DIR_PREFIX + "_" + now + "_" + rand);
        System.out.println("Number of Maps  = " + nMaps);
        System.out.println("Samples per Map = " + nSamples);
        System.out.println("Estimated value of Pi is " + QuasiMonteCarlo.estimatePi((int)nMaps, (long)nSamples, (Path)tmpDir, (Configuration)this.getConf()));
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        System.exit(ToolRunner.run(null, (Tool)new QuasiMonteCarlo(), (String[])argv));
    }
}

