/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.FixedLengthInputFormat;
import org.apache.hadoop.mapred.FixedLengthRecordReader;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestFixedLengthInputFormat {
    private static Log LOG;
    private static Configuration defaultConf;
    private static FileSystem localFs;
    private static Path workDir;
    private static Reporter voidReporter;
    private static char[] chars;
    private static Random charRand;

    @BeforeClass
    public static void onlyOnce() {
        try {
            LOG = LogFactory.getLog((String)TestFixedLengthInputFormat.class.getName());
            defaultConf = new Configuration();
            defaultConf.set("fs.defaultFS", "file:///");
            localFs = FileSystem.getLocal((Configuration)defaultConf);
            voidReporter = Reporter.NULL;
            chars = "abcdefghijklmnopqrstuvABCDEFGHIJKLMN OPQRSTUVWXYZ1234567890)(*&^%$#@!-=><?:\"{}][';/.,']".toCharArray();
            workDir = new Path(new Path(System.getProperty("test.build.data", "."), "data"), "TestKeyValueFixedLengthInputFormat");
            charRand = new Random();
        }
        catch (IOException e) {
            throw new RuntimeException("init failure", e);
        }
    }

    @Test(timeout=500000L)
    public void testFormat() throws IOException {
        this.runRandomTests(null);
    }

    @Test(timeout=500000L)
    public void testFormatCompressedIn() throws IOException {
        this.runRandomTests((CompressionCodec)new GzipCodec());
    }

    @Test(timeout=5000L)
    public void testNoRecordLength() throws IOException {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        JobConf job = new JobConf(defaultConf);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 1);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                RecordReader reader = format.getRecordReader(split, job, voidReporter);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for not setting record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testZeroRecordLength() throws IOException {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        JobConf job = new JobConf(defaultConf);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job, (int)0);
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 1);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                RecordReader reader = format.getRecordReader(split, job, voidReporter);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for zero record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testNegativeRecordLength() throws IOException {
        localFs.delete(workDir, true);
        Path file = new Path(workDir, new String("testFormat.txt"));
        this.createFile(file, null, 10, 10);
        JobConf job = new JobConf(defaultConf);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        FixedLengthInputFormat.setRecordLength((Configuration)job, (int)-10);
        format.configure(job);
        InputSplit[] splits = format.getSplits(job, 1);
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                RecordReader reader = format.getRecordReader(split, job, voidReporter);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for negative record length:", (boolean)exceptionThrown);
    }

    @Test(timeout=5000L)
    public void testPartialRecordCompressedIn() throws IOException {
        GzipCodec gzip = new GzipCodec();
        this.runPartialRecordTest((CompressionCodec)gzip);
    }

    @Test(timeout=5000L)
    public void testPartialRecordUncompressedIn() throws IOException {
        this.runPartialRecordTest(null);
    }

    @Test(timeout=5000L)
    public void testGzipWithTwoInputs() throws IOException {
        GzipCodec gzip = new GzipCodec();
        localFs.delete(workDir, true);
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        JobConf job = new JobConf(defaultConf);
        FixedLengthInputFormat.setRecordLength((Configuration)job, (int)5);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        ReflectionUtils.setConf((Object)gzip, (Configuration)job);
        format.configure(job);
        TestFixedLengthInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part1.txt.gz"), (CompressionCodec)gzip, (String)"one  two  threefour five six  seveneightnine ten  ");
        TestFixedLengthInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, "part2.txt.gz"), (CompressionCodec)gzip, (String)"ten  nine eightsevensix  five four threetwo  one  ");
        InputSplit[] splits = format.getSplits(job, 100);
        Assert.assertEquals((String)"compressed splits == 2", (long)2L, (long)splits.length);
        FileSplit tmp = (FileSplit)splits[0];
        if (tmp.getPath().getName().equals("part2.txt.gz")) {
            splits[0] = splits[1];
            splits[1] = tmp;
        }
        List results = TestFixedLengthInputFormat.readSplit((FixedLengthInputFormat)format, (InputSplit)splits[0], (JobConf)job);
        Assert.assertEquals((String)"splits[0] length", (long)10L, (long)results.size());
        Assert.assertEquals((String)"splits[0][5]", (Object)"six  ", results.get(5));
        results = TestFixedLengthInputFormat.readSplit((FixedLengthInputFormat)format, (InputSplit)splits[1], (JobConf)job);
        Assert.assertEquals((String)"splits[1] length", (long)10L, (long)results.size());
        Assert.assertEquals((String)"splits[1][0]", (Object)"ten  ", results.get(0));
        Assert.assertEquals((String)"splits[1][1]", (Object)"nine ", results.get(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> createFile(Path targetFile, CompressionCodec codec, int recordLen, int numRecords) throws IOException {
        ArrayList<String> recordList = new ArrayList<String>(numRecords);
        FSDataOutputStream ostream = localFs.create(targetFile);
        if (codec != null) {
            ostream = codec.createOutputStream((OutputStream)ostream);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ostream);){
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < numRecords; ++i) {
                for (int j = 0; j < recordLen; ++j) {
                    sb.append(chars[charRand.nextInt(chars.length)]);
                }
                String recordData = sb.toString();
                recordList.add(recordData);
                writer.write(recordData);
                sb.setLength(0);
            }
        }
        return recordList;
    }

    private void runRandomTests(CompressionCodec codec) throws IOException {
        StringBuilder fileName = new StringBuilder("testFormat.txt");
        if (codec != null) {
            fileName.append(".gz");
        }
        localFs.delete(workDir, true);
        Path file = new Path(workDir, fileName.toString());
        int seed = new Random().nextInt();
        LOG.info((Object)("Seed = " + seed));
        Random random = new Random(seed);
        int MAX_TESTS = 20;
        LongWritable key = new LongWritable();
        BytesWritable value = new BytesWritable();
        for (int i = 0; i < MAX_TESTS; ++i) {
            LOG.info((Object)"----------------------------------------------------------");
            int totalRecords = random.nextInt(999) + 1;
            if (i == 8) {
                totalRecords = 0;
            }
            int recordLength = random.nextInt(102400) + 1;
            if (i == 10) {
                recordLength = 1;
            }
            int fileSize = totalRecords * recordLength;
            LOG.info((Object)("totalRecords=" + totalRecords + " recordLength=" + recordLength));
            JobConf job = new JobConf(defaultConf);
            if (codec != null) {
                ReflectionUtils.setConf((Object)codec, (Configuration)job);
            }
            ArrayList recordList = this.createFile(file, codec, recordLength, totalRecords);
            Assert.assertTrue((boolean)localFs.exists(file));
            FixedLengthInputFormat.setRecordLength((Configuration)job, (int)recordLength);
            int numSplits = 1;
            if (i > 0) {
                numSplits = i == MAX_TESTS - 1 ? (int)((double)fileSize / Math.floor(recordLength / 2)) : (MAX_TESTS % i == 0 ? fileSize / (fileSize - random.nextInt(fileSize)) : Math.max(1, fileSize / random.nextInt(Integer.MAX_VALUE)));
                LOG.info((Object)("Number of splits set to: " + numSplits));
            }
            FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
            FixedLengthInputFormat format = new FixedLengthInputFormat();
            format.configure(job);
            InputSplit[] splits = format.getSplits(job, numSplits);
            LOG.info((Object)("Actual number of splits = " + splits.length));
            long recordOffset = 0L;
            int recordNumber = 0;
            for (InputSplit split : splits) {
                RecordReader reader = format.getRecordReader(split, job, voidReporter);
                Class<?> clazz = reader.getClass();
                Assert.assertEquals((String)"RecordReader class should be FixedLengthRecordReader:", FixedLengthRecordReader.class, clazz);
                while (reader.next((Object)key, (Object)value)) {
                    Assert.assertEquals((String)"Checking key", (long)(recordNumber * recordLength), (long)key.get());
                    String valueString = new String(value.getBytes(), 0, value.getLength());
                    Assert.assertEquals((String)"Checking record length:", (long)recordLength, (long)value.getLength());
                    Assert.assertTrue((String)"Checking for more records than expected:", (recordNumber < totalRecords ? 1 : 0) != 0);
                    String origRecord = (String)recordList.get(recordNumber);
                    Assert.assertEquals((String)"Checking record content:", (Object)origRecord, (Object)valueString);
                    ++recordNumber;
                }
                reader.close();
            }
            Assert.assertEquals((String)"Total original records should be total read records:", (long)recordList.size(), (long)recordNumber);
        }
    }

    private static void writeFile(FileSystem fs, Path name, CompressionCodec codec, String contents) throws IOException {
        Object stm = codec == null ? fs.create(name) : codec.createOutputStream((OutputStream)fs.create(name));
        stm.write(contents.getBytes());
        stm.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readSplit(FixedLengthInputFormat format, InputSplit split, JobConf job) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        RecordReader reader = format.getRecordReader(split, job, voidReporter);
        LongWritable key = (LongWritable)reader.createKey();
        BytesWritable value = (BytesWritable)reader.createValue();
        try {
            while (reader.next((Object)key, (Object)value)) {
                result.add(new String(value.getBytes(), 0, value.getLength()));
            }
        }
        finally {
            reader.close();
        }
        return result;
    }

    private void runPartialRecordTest(CompressionCodec codec) throws IOException {
        localFs.delete(workDir, true);
        StringBuilder fileName = new StringBuilder("testFormat.txt");
        if (codec != null) {
            fileName.append(".gz");
        }
        FixedLengthInputFormat format = new FixedLengthInputFormat();
        JobConf job = new JobConf(defaultConf);
        FixedLengthInputFormat.setRecordLength((Configuration)job, (int)5);
        FileInputFormat.setInputPaths((JobConf)job, (Path[])new Path[]{workDir});
        if (codec != null) {
            ReflectionUtils.setConf((Object)codec, (Configuration)job);
        }
        format.configure(job);
        TestFixedLengthInputFormat.writeFile((FileSystem)localFs, (Path)new Path(workDir, fileName.toString()), (CompressionCodec)codec, (String)"one  two  threefour five six  seveneightnine ten");
        InputSplit[] splits = format.getSplits(job, 100);
        if (codec != null) {
            Assert.assertEquals((String)"compressed splits == 1", (long)1L, (long)splits.length);
        }
        boolean exceptionThrown = false;
        for (InputSplit split : splits) {
            try {
                List results = TestFixedLengthInputFormat.readSplit((FixedLengthInputFormat)format, (InputSplit)split, (JobConf)job);
            }
            catch (IOException ioe) {
                exceptionThrown = true;
                LOG.info((Object)("Exception message:" + ioe.getMessage()));
            }
        }
        Assert.assertTrue((String)"Exception for partial record:", (boolean)exceptionThrown);
    }
}

