/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.map;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.map.MultithreadedMapper;
import org.apache.hadoop.mapreduce.lib.map.TestMultithreadedMapper;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestMultithreadedMapper
extends HadoopTestCase {
    public TestMultithreadedMapper() throws IOException {
        super(1, 4, 1, 1);
    }

    public void testOKRun() throws Exception {
        this.run(false, false);
    }

    public void testIOExRun() throws Exception {
        this.run(true, false);
    }

    public void testRuntimeExRun() throws Exception {
        this.run(false, true);
    }

    private void run(boolean ioEx, boolean rtEx) throws Exception {
        String localPathRoot = System.getProperty("test.build.data", "/tmp");
        Path inDir = new Path(localPathRoot, "testing/mt/input");
        Path outDir = new Path(localPathRoot, "testing/mt/output");
        JobConf conf = this.createJobConf();
        if (ioEx) {
            conf.setBoolean("multithreaded.ioException", true);
        }
        if (rtEx) {
            conf.setBoolean("multithreaded.runtimeException", true);
        }
        Job job = MapReduceTestUtil.createJob((Configuration)conf, (Path)inDir, (Path)outDir, (int)1, (int)1);
        job.setJobName("mt");
        job.setMapperClass(MultithreadedMapper.class);
        MultithreadedMapper.setMapperClass((Job)job, IDMap.class);
        MultithreadedMapper.setNumberOfThreads((Job)job, (int)2);
        job.setReducerClass(Reducer.class);
        job.waitForCompletion(true);
        if (job.isSuccessful()) {
            TestMultithreadedMapper.assertFalse((ioEx || rtEx ? 1 : 0) != 0);
        } else {
            TestMultithreadedMapper.assertTrue((ioEx || rtEx ? 1 : 0) != 0);
        }
    }
}

