/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.slive.ConfigExtractor;
import org.apache.hadoop.fs.slive.Helper;
import org.apache.hadoop.fs.slive.Operation;
import org.apache.hadoop.fs.slive.OperationOutput;
import org.apache.hadoop.fs.slive.Range;
import org.apache.hadoop.fs.slive.Timer;

class TruncateOp
extends Operation {
    private static final Log LOG = LogFactory.getLog(TruncateOp.class);

    TruncateOp(ConfigExtractor cfg, Random rnd) {
        super(TruncateOp.class.getSimpleName(), cfg, rnd);
    }

    protected Path getTruncateFile() {
        Path fn = this.getFinder().getFile();
        return fn;
    }

    List<OperationOutput> run(FileSystem fs) {
        List out = super.run(fs);
        try {
            Path fn = this.getTruncateFile();
            boolean waitOnTruncate = this.getConfig().shouldWaitOnTruncate();
            long currentSize = fs.getFileStatus(fn).getLen();
            Range truncateSizeRange = this.getConfig().getTruncateSize();
            if (this.getConfig().shouldTruncateUseBlockSize()) {
                truncateSizeRange = this.getConfig().getBlockSize();
            }
            long truncateSize = Math.max(0L, currentSize - Range.betweenPositive((Random)this.getRandom(), (Range)truncateSizeRange));
            long timeTaken = 0L;
            LOG.info((Object)("Attempting to truncate file at " + fn + " to size " + Helper.toByteInfo((long)truncateSize)));
            long startTime = Timer.now();
            boolean completed = fs.truncate(fn, truncateSize);
            if (!completed && waitOnTruncate) {
                this.waitForRecovery(fs, fn, truncateSize);
            }
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "bytes_written", (Object)0));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "milliseconds_taken", (Object)(timeTaken += Timer.elapsed((long)startTime))));
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "successes", (Object)1L));
            LOG.info((Object)("Truncate file " + fn + " to " + Helper.toByteInfo((long)truncateSize) + " in " + timeTaken + " milliseconds"));
        }
        catch (FileNotFoundException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "files_not_found", (Object)1L));
            LOG.warn((Object)"Error with truncating", (Throwable)e);
        }
        catch (IOException e) {
            out.add(new OperationOutput(OperationOutput.OutputType.LONG, this.getType(), "failures", (Object)1L));
            LOG.warn((Object)"Error with truncating", (Throwable)e);
        }
        return out;
    }

    private void waitForRecovery(FileSystem fs, Path fn, long newLength) throws IOException {
        FileStatus stat;
        LOG.info((Object)("Waiting on truncate file recovery for " + fn));
        while ((stat = fs.getFileStatus(fn)).getLen() != newLength) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignored) {}
        }
    }
}

