/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.LocalJobRunner;
import org.apache.hadoop.mapreduce.Cluster;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestClientProtocolProviderImpls
extends TestCase {
    @Test
    public void testClusterWithLocalClientProvider() throws Exception {
        Configuration conf = new Configuration();
        try {
            conf.set("mapreduce.framework.name", "incorrect");
            new Cluster(conf);
            TestClientProtocolProviderImpls.fail((String)"Cluster should not be initialized with incorrect framework name");
        }
        catch (IOException e) {
            // empty catch block
        }
        conf.set("mapreduce.framework.name", "local");
        Cluster cluster = new Cluster(conf);
        TestClientProtocolProviderImpls.assertTrue((boolean)(cluster.getClient() instanceof LocalJobRunner));
        cluster.close();
    }

    @Test
    public void testClusterWithJTClientProvider() throws Exception {
        Configuration conf = new Configuration();
        try {
            conf.set("mapreduce.framework.name", "incorrect");
            new Cluster(conf);
            TestClientProtocolProviderImpls.fail((String)"Cluster should not be initialized with incorrect framework name");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            conf.set("mapreduce.framework.name", "classic");
            conf.set("mapreduce.jobtracker.address", "local");
            new Cluster(conf);
            TestClientProtocolProviderImpls.fail((String)"Cluster with classic Framework name shouldnot use local JT address");
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            conf = new Configuration();
            conf.set("mapreduce.framework.name", "classic");
            conf.set("mapreduce.jobtracker.address", "127.0.0.1:0");
            Cluster cluster = new Cluster(conf);
            cluster.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testClusterException() {
        boolean errorThrown;
        block3: {
            Configuration conf = new Configuration();
            conf.set("mapreduce.framework.name", "classic");
            conf.set("mapreduce.jobtracker.address", "local");
            errorThrown = false;
            try {
                Cluster cluster = new Cluster(conf);
                cluster.close();
                TestClientProtocolProviderImpls.fail((String)"Not expected - cluster init should have failed");
            }
            catch (IOException e) {
                errorThrown = true;
                if ($assertionsDisabled || e.getMessage().contains("Cannot initialize Cluster. Please check")) break block3;
                throw new AssertionError();
            }
        }
        assert (errorThrown);
    }
}

