/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.MapTaskStatus;
import org.apache.hadoop.mapred.ReduceTaskStatus;
import org.apache.hadoop.mapred.TaskStatus;
import org.apache.hadoop.mapred.TestTaskStatus;
import org.junit.Assert;
import org.junit.Test;

public class TestTaskStatus {
    private static final Log LOG = LogFactory.getLog(TestTaskStatus.class);

    @Test
    public void testMapTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(true);
    }

    @Test
    public void testReduceTaskStatusStartAndFinishTimes() {
        this.checkTaskStatues(false);
    }

    private void checkTaskStatues(boolean isMap) {
        Object status = null;
        status = isMap ? new MapTaskStatus() : new ReduceTaskStatus();
        long currentTime = System.currentTimeMillis();
        status.setFinishTime(currentTime);
        Assert.assertEquals((String)"Finish time of the task status set without start time", (long)0L, (long)status.getFinishTime());
        status.setStartTime(currentTime);
        Assert.assertEquals((String)"Start time of the task status not set correctly.", (long)currentTime, (long)status.getStartTime());
        long wrongTime = -1L;
        status.setStartTime(wrongTime);
        Assert.assertEquals((String)"Start time of the task status is set to wrong negative value", (long)currentTime, (long)status.getStartTime());
        status.setFinishTime(wrongTime);
        Assert.assertEquals((String)"Finish time of task status is set to wrong negative value", (long)0L, (long)status.getFinishTime());
        status.setFinishTime(currentTime);
        Assert.assertEquals((String)"Finish time of the task status not set correctly.", (long)currentTime, (long)status.getFinishTime());
        TaskStatus ts = (TaskStatus)status.clone();
        ts.setDiagnosticInfo(null);
        ts.setDiagnosticInfo("");
        ts.setStateString(null);
        ts.setStateString("");
        ((TaskStatus)status.clone()).statusUpdate(ts);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, null, null);
        ((TaskStatus)status.clone()).statusUpdate(0.0f, "", null);
        ((TaskStatus)status.clone()).statusUpdate(null, 0.0f, "", null, 1L);
    }

    @Test
    public void testTaskDiagnosticsAndStateString() {
        String test = "hi";
        int maxSize = 16;
        1 status = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((String)"Small diagnostic info test failed", (Object)status.getDiagnosticInfo(), (Object)test);
        Assert.assertEquals((String)"Small state string test failed", (Object)status.getStateString(), (Object)test);
        String newDInfo = test.concat(test);
        status.setDiagnosticInfo(test);
        status.setStateString(newDInfo);
        Assert.assertEquals((String)"Small diagnostic info append failed", (Object)newDInfo, (Object)status.getDiagnosticInfo());
        Assert.assertEquals((String)"Small state-string append failed", (Object)newDInfo, (Object)status.getStateString());
        TaskStatus newStatus = (TaskStatus)status.clone();
        String newSInfo = "hi1";
        newStatus.setStateString(newSInfo);
        status.statusUpdate(newStatus);
        newDInfo = newDInfo.concat(newStatus.getDiagnosticInfo());
        Assert.assertEquals((String)"Status-update on diagnostic-info failed", (Object)newDInfo, (Object)status.getDiagnosticInfo());
        Assert.assertEquals((String)"Status-update on state-string failed", (Object)newSInfo, (Object)status.getStateString());
        newSInfo = "hi2";
        status.statusUpdate(0.0f, newSInfo, null);
        Assert.assertEquals((String)"Status-update on state-string failed", (Object)newSInfo, (Object)status.getStateString());
        newSInfo = "hi3";
        status.statusUpdate(null, 0.0f, newSInfo, null, 0L);
        Assert.assertEquals((String)"Status-update on state-string failed", (Object)newSInfo, (Object)status.getStateString());
        String large = "hihihihihihihihihihi";
        status.setDiagnosticInfo(large);
        status.setStateString(large);
        Assert.assertEquals((String)"Large diagnostic info append test failed", (long)16L, (long)status.getDiagnosticInfo().length());
        Assert.assertEquals((String)"Large state-string append test failed", (long)16L, (long)status.getStateString().length());
        newStatus.setDiagnosticInfo(large + "0");
        newStatus.setStateString(large + "1");
        status.statusUpdate(newStatus);
        Assert.assertEquals((String)"Status-update on diagnostic info failed", (long)16L, (long)status.getDiagnosticInfo().length());
        Assert.assertEquals((String)"Status-update on state-string failed", (long)16L, (long)status.getStateString().length());
        status.statusUpdate(0.0f, large + "2", null);
        Assert.assertEquals((String)"Status-update on state-string failed", (long)16L, (long)status.getStateString().length());
        status.statusUpdate(null, 0.0f, large + "3", null, 0L);
        Assert.assertEquals((String)"Status-update on state-string failed", (long)16L, (long)status.getStateString().length());
        status = new /* Unavailable Anonymous Inner Class!! */;
        Assert.assertEquals((String)"Large diagnostic info test failed", (long)16L, (long)status.getDiagnosticInfo().length());
        Assert.assertEquals((String)"Large state-string test failed", (long)16L, (long)status.getStateString().length());
    }
}

