/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TestComparators;
import org.apache.hadoop.mapred.TestMapOutputType;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestComparators
extends TestCase {
    JobConf conf = new JobConf(TestMapOutputType.class);
    JobClient jc;
    static Random rng = new Random();

    public void configure() throws Exception {
        Path testdir = new Path("build/test/test.mapred.spill");
        Path inDir = new Path(testdir, "in");
        Path outDir = new Path(testdir, "out");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        fs.delete(testdir, true);
        this.conf.setInputFormat(SequenceFileInputFormat.class);
        FileInputFormat.setInputPaths((JobConf)this.conf, (Path[])new Path[]{inDir});
        FileOutputFormat.setOutputPath((JobConf)this.conf, (Path)outDir);
        this.conf.setOutputKeyClass(IntWritable.class);
        this.conf.setOutputValueClass(Text.class);
        this.conf.setMapOutputValueClass(IntWritable.class);
        this.conf.setNumMapTasks(2);
        this.conf.set("mapreduce.framework.name", "local");
        this.conf.setOutputFormat(SequenceFileOutputFormat.class);
        if (!fs.mkdirs(testdir)) {
            throw new IOException("Mkdirs failed to create " + testdir.toString());
        }
        if (!fs.mkdirs(inDir)) {
            throw new IOException("Mkdirs failed to create " + inDir.toString());
        }
        Path inFile = new Path(inDir, "part0");
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)inFile, IntWritable.class, IntWritable.class);
        writer.append((Writable)new IntWritable(11), (Writable)new IntWritable(999));
        writer.append((Writable)new IntWritable(23), (Writable)new IntWritable(456));
        writer.append((Writable)new IntWritable(10), (Writable)new IntWritable(780));
        writer.close();
        inFile = new Path(inDir, "part1");
        writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)inFile, IntWritable.class, IntWritable.class);
        writer.append((Writable)new IntWritable(45), (Writable)new IntWritable(100));
        writer.append((Writable)new IntWritable(18), (Writable)new IntWritable(200));
        writer.append((Writable)new IntWritable(27), (Writable)new IntWritable(300));
        writer.close();
        this.jc = new JobClient(this.conf);
    }

    public void testDefaultMRComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(IdentityMapper.class);
        this.conf.setReducerClass(AscendingKeysReducer.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testUserMRComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(IdentityMapper.class);
        this.conf.setReducerClass(DescendingKeysReducer.class);
        this.conf.setOutputKeyComparatorClass(DecreasingIntComparator.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testUserValueGroupingComparator() throws Exception {
        this.configure();
        this.conf.setMapperClass(RandomGenMapper.class);
        this.conf.setReducerClass(AscendingGroupReducer.class);
        this.conf.setOutputValueGroupingComparator(CompositeIntGroupFn.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testAllUserComparators() throws Exception {
        this.configure();
        this.conf.setMapperClass(RandomGenMapper.class);
        this.conf.setOutputKeyComparatorClass(DecreasingIntComparator.class);
        this.conf.setReducerClass(DescendingGroupReducer.class);
        this.conf.setOutputValueGroupingComparator(CompositeIntReverseGroupFn.class);
        RunningJob r_job = this.jc.submitJob(this.conf);
        while (!r_job.isComplete()) {
            Thread.sleep(1000L);
        }
        if (!r_job.isSuccessful()) {
            TestComparators.fail((String)"Oops! The job broke due to an unexpected error");
        }
    }

    public void testBakedUserComparator() throws Exception {
        MyWritable a = new MyWritable(8, 8);
        MyWritable b = new MyWritable(7, 9);
        TestComparators.assertTrue((a.compareTo(b) > 0 ? 1 : 0) != 0);
        TestComparators.assertTrue((WritableComparator.get(MyWritable.class).compare((WritableComparable)a, (WritableComparable)b) < 0 ? 1 : 0) != 0);
    }
}

