/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobCounter;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestUberAM
extends TestMRJobs {
    private static final Log LOG = LogFactory.getLog(TestUberAM.class);
    private int numSleepReducers;

    @BeforeClass
    public static void setup() throws IOException {
        TestMRJobs.setup();
        if (mrCluster != null) {
            mrCluster.getConfig().setBoolean("mapreduce.job.ubertask.enable", true);
            mrCluster.getConfig().setInt("mapreduce.job.ubertask.maxreduces", 3);
        }
    }

    @Test
    public void testSleepJob() throws IOException, InterruptedException, ClassNotFoundException {
        this.numSleepReducers = 1;
        if (mrCluster != null) {
            mrCluster.getConfig().setInt("TestMRJobs.testSleepJob.reduces", this.numSleepReducers);
        }
        super.testSleepJob();
    }

    @Test
    public void testSleepJobWithMultipleReducers() throws IOException, InterruptedException, ClassNotFoundException {
        this.numSleepReducers = 3;
        if (mrCluster != null) {
            mrCluster.getConfig().setInt("TestMRJobs.testSleepJob.reduces", this.numSleepReducers);
        }
        super.testSleepJob();
    }

    protected void verifySleepJobCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)this.numSleepReducers, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_REDUCES).getValue());
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)this.numSleepReducers, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBREDUCES).getValue());
        Assert.assertEquals((long)(3 + this.numSleepReducers), (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
    }

    @Test
    public void testRandomWriter() throws IOException, InterruptedException, ClassNotFoundException {
        super.testRandomWriter();
    }

    protected void verifyRandomWriterCounters(Job job) throws InterruptedException, IOException {
        super.verifyRandomWriterCounters(job);
        Counters counters = job.getCounters();
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)3L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
    }

    @Test
    public void testFailingMapper() throws IOException, InterruptedException, ClassNotFoundException {
        LOG.info((Object)"\n\n\nStarting uberized testFailingMapper().");
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        Job job = this.runFailingMapperJob();
        TaskID taskID = new TaskID(job.getJobID(), TaskType.MAP, 0);
        TaskAttemptID aId = new TaskAttemptID(taskID, 0);
        System.out.println("Diagnostics for " + aId + " :");
        for (String diag : job.getTaskDiagnostics(aId)) {
            System.out.println(diag);
        }
        boolean secondTaskAttemptExists = true;
        try {
            aId = new TaskAttemptID(taskID, 1);
            System.out.println("Diagnostics for " + aId + " :");
            for (String diag : job.getTaskDiagnostics(aId)) {
                System.out.println(diag);
            }
        }
        catch (Exception e) {
            secondTaskAttemptExists = false;
        }
        Assert.assertEquals((Object)false, (Object)secondTaskAttemptExists);
        TaskCompletionEvent[] events = job.getTaskCompletionEvents(0, 2);
        Assert.assertEquals((long)1L, (long)events.length);
        TaskCompletionEvent.Status status = events[0].getStatus();
        Assert.assertTrue((status == TaskCompletionEvent.Status.FAILED || status == TaskCompletionEvent.Status.TIPFAILED ? 1 : 0) != 0);
        Assert.assertEquals((Object)JobStatus.State.FAILED, (Object)job.getJobState());
    }

    protected void verifyFailingMapperCounters(Job job) throws InterruptedException, IOException {
        Counters counters = job.getCounters();
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.OTHER_LOCAL_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_MAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_FAILED_MAPS).getValue());
        Assert.assertTrue((counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS) != null && counters.findCounter((Enum)JobCounter.SLOTS_MILLIS_MAPS).getValue() != 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.TOTAL_LAUNCHED_UBERTASKS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_UBER_SUBMAPS).getValue());
        Assert.assertEquals((long)2L, (long)counters.findCounter((Enum)JobCounter.NUM_FAILED_UBERTASKS).getValue());
    }

    public void testSleepJobWithSecurityOn() throws IOException, InterruptedException, ClassNotFoundException {
        super.testSleepJobWithSecurityOn();
    }

    @Test
    public void testDistributedCache() throws Exception {
    }
}

