/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.HadoopTestCase;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.MapReduceTestUtil;
import org.apache.hadoop.mapreduce.TaskReport;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TestTaskContext;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

/*
 * Exception performing whole class analysis ignored.
 */
@Ignore
public class TestTaskContext
extends HadoopTestCase {
    private static final Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
    private static final Path testRootTempDir = new Path(rootTempDir, "TestTaskContext");
    private static FileSystem fs = null;
    static String myStatus = "my status";
    private static final String INPUT = "Hi\nHi\nHi\nHi\n";
    private static final int INPUT_LINES = "Hi\nHi\nHi\nHi\n".split("\n").length;

    @BeforeClass
    public static void setup() throws Exception {
        fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.delete(testRootTempDir, true);
        fs.mkdirs(testRootTempDir);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        fs.delete(testRootTempDir, true);
    }

    public TestTaskContext() throws IOException {
        super(2, 4, 1, 1);
    }

    @Test
    @Ignore
    public void testContextStatus() throws IOException, InterruptedException, ClassNotFoundException {
        Path test = new Path(testRootTempDir, "testContextStatus");
        int numMaps = 1;
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)numMaps, (int)0);
        job.setMapperClass(MyMapper.class);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
        TaskReport[] reports = job.getTaskReports(TaskType.MAP);
        TestTaskContext.assertEquals((int)numMaps, (int)reports.length);
        TestTaskContext.assertEquals((String)myStatus, (String)reports[0].getState());
        int numReduces = 1;
        job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)numMaps, (int)numReduces);
        job.setMapperClass(MapReduceTestUtil.DataCopyMapper.class);
        job.setReducerClass(MapReduceTestUtil.DataCopyReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(0);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    public void testMapContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numMaps = 1;
        Path test = new Path(testRootTempDir, "testMapContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)numMaps, (int)0, (String)"Hi\nHi\nHi\nHi\n");
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    @Test
    public void testReduceContextProgress() throws IOException, InterruptedException, ClassNotFoundException {
        int numTasks = 1;
        Path test = new Path(testRootTempDir, "testReduceContextProgress");
        Job job = MapReduceTestUtil.createJob((Configuration)this.createJobConf(), (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)numTasks, (int)numTasks, (String)"Hi\nHi\nHi\nHi\n");
        job.setMapperClass(ProgressCheckerMapper.class);
        job.setReducerClass(ProgressCheckerReducer.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMaxMapAttempts(1);
        job.setMaxReduceAttempts(1);
        job.waitForCompletion(true);
        TestTaskContext.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    static /* synthetic */ int access$000() {
        return INPUT_LINES;
    }
}

