/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.SleepJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskLog;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.TestMRJobs;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestMRJobsWithProfiler {
    private static final Log LOG = LogFactory.getLog(TestMRJobsWithProfiler.class);
    private static final EnumSet<RMAppState> TERMINAL_RM_APP_STATES = EnumSet.of(RMAppState.FINISHED, RMAppState.FAILED, RMAppState.KILLED);
    private static MiniMRYarnCluster mrCluster;
    private static final Configuration CONF;
    private static final FileSystem localFs;
    private static final Path TEST_ROOT_DIR;
    private static final Path APP_JAR;

    @Before
    public void setup() throws InterruptedException, IOException {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster == null) {
            mrCluster = new MiniMRYarnCluster(this.getClass().getName());
            mrCluster.init(CONF);
            mrCluster.start();
        }
        localFs.copyFromLocalFile(new Path(MiniMRYarnCluster.APPJAR), APP_JAR);
        localFs.setPermission(APP_JAR, new FsPermission("700"));
    }

    @After
    public void tearDown() {
        if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
            LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
            return;
        }
        if (mrCluster != null) {
            mrCluster.stop();
        }
    }

    @Test(timeout=120000L)
    public void testProfiler() throws IOException, InterruptedException, ClassNotFoundException {
        ApplicationId appID;
        block10: {
            if (!new File(MiniMRYarnCluster.APPJAR).exists()) {
                LOG.info((Object)("MRAppJar " + MiniMRYarnCluster.APPJAR + " not found. Not running test."));
                return;
            }
            SleepJob sleepJob = new SleepJob();
            JobConf sleepConf = new JobConf(mrCluster.getConfig());
            sleepConf.setProfileEnabled(true);
            sleepConf.setProfileTaskRange(true, "1");
            sleepConf.setProfileTaskRange(false, "1");
            sleepConf.set("mapreduce.task.profile.map.params", "-agentlib:hprof=cpu=times,heap=sites,force=n,thread=y,verbose=n,file=%s");
            sleepConf.set("mapreduce.task.profile.reduce.params", "-Xprof");
            sleepJob.setConf((Configuration)sleepConf);
            Job job = sleepJob.createJob(2, 2, 500L, 1, 500L, 1);
            job.setJarByClass(SleepJob.class);
            job.addFileToClassPath(APP_JAR);
            job.waitForCompletion(true);
            JobId jobId = TypeConverter.toYarn((JobID)job.getJobID());
            appID = jobId.getAppId();
            int pollElapsed = 0;
            do {
                Thread.sleep(1000L);
                pollElapsed += 1000;
                if (TERMINAL_RM_APP_STATES.contains(((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState())) break block10;
            } while (pollElapsed < 60000);
            LOG.warn((Object)"application did not reach terminal state within 60 seconds");
        }
        Assert.assertEquals((Object)RMAppState.FINISHED, (Object)((RMApp)mrCluster.getResourceManager().getRMContext().getRMApps().get(appID)).getState());
        Configuration nmConf = mrCluster.getNodeManager(0).getConfig();
        String appIdStr = appID.toString();
        String appIdSuffix = appIdStr.substring("application_".length(), appIdStr.length());
        String containerGlob = "container_" + appIdSuffix + "_*_*";
        HashMap<TaskAttemptID, Path> taLogDirs = new HashMap<TaskAttemptID, Path>();
        Pattern taskPattern = Pattern.compile(".*Task:(attempt_" + appIdSuffix + "_[rm]_" + "[0-9]+_[0-9]+).*");
        for (String logDir : nmConf.getTrimmedStrings("yarn.nodemanager.log-dirs")) {
            for (FileStatus fileStatus : localFs.globStatus(new Path(logDir + "/" + appIdStr + "/" + containerGlob + "/" + TaskLog.LogName.SYSLOG))) {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)localFs.open(fileStatus.getPath())));
                while ((line = br.readLine()) != null) {
                    Matcher m = taskPattern.matcher(line);
                    if (!m.matches()) continue;
                    taLogDirs.put(TaskAttemptID.forName((String)m.group(1)), fileStatus.getPath().getParent());
                    break;
                }
                br.close();
            }
        }
        Assert.assertEquals((int)4, (int)taLogDirs.size());
        for (Map.Entry dirEntry : taLogDirs.entrySet()) {
            BufferedReader br;
            TaskAttemptID tid = (TaskAttemptID)dirEntry.getKey();
            Path profilePath = new Path((Path)dirEntry.getValue(), TaskLog.LogName.PROFILE.toString());
            Path stdoutPath = new Path((Path)dirEntry.getValue(), TaskLog.LogName.STDOUT.toString());
            if (tid.getTaskType() == TaskType.MAP) {
                if (tid.getTaskID().getId() == 1) {
                    br = new BufferedReader(new InputStreamReader((InputStream)localFs.open(profilePath)));
                    String line = br.readLine();
                    Assert.assertTrue((String)"No hprof content found!", (line != null && line.startsWith("JAVA PROFILE") ? 1 : 0) != 0);
                    br.close();
                    Assert.assertEquals((long)0L, (long)localFs.getFileStatus(stdoutPath).getLen());
                    continue;
                }
                Assert.assertFalse((String)"hprof file should not exist", (boolean)localFs.exists(profilePath));
                continue;
            }
            Assert.assertFalse((String)"hprof file should not exist", (boolean)localFs.exists(profilePath));
            if (tid.getTaskID().getId() == 1) {
                String line;
                br = new BufferedReader(new InputStreamReader((InputStream)localFs.open(stdoutPath)));
                boolean flatProfFound = false;
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("Flat profile")) continue;
                    flatProfFound = true;
                    break;
                }
                br.close();
                Assert.assertTrue((String)"Xprof flat profile not found!", (boolean)flatProfFound);
                continue;
            }
            Assert.assertEquals((long)0L, (long)localFs.getFileStatus(stdoutPath).getLen());
        }
    }

    static {
        CONF = new Configuration();
        try {
            localFs = FileSystem.getLocal((Configuration)CONF);
        }
        catch (IOException io) {
            throw new RuntimeException("problem getting local fs", io);
        }
        TEST_ROOT_DIR = new Path("target", TestMRJobs.class.getName() + "-tmpDir").makeQualified(localFs.getUri(), localFs.getWorkingDirectory());
        APP_JAR = new Path(TEST_ROOT_DIR, "MRAppJar.jar");
    }
}

