/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.SleepJob;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class SleepJob
extends Configured
implements Tool {
    public static String MAP_SLEEP_COUNT = "mapreduce.sleepjob.map.sleep.count";
    public static String REDUCE_SLEEP_COUNT = "mapreduce.sleepjob.reduce.sleep.count";
    public static String MAP_SLEEP_TIME = "mapreduce.sleepjob.map.sleep.time";
    public static String REDUCE_SLEEP_TIME = "mapreduce.sleepjob.reduce.sleep.time";

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new SleepJob(), (String[])args);
        System.exit(res);
    }

    public Job createJob(int numMapper, int numReducer, long mapSleepTime, int mapSleepCount, long reduceSleepTime, int reduceSleepCount) throws IOException {
        Configuration conf = this.getConf();
        conf.setLong(MAP_SLEEP_TIME, mapSleepTime);
        conf.setLong(REDUCE_SLEEP_TIME, reduceSleepTime);
        conf.setInt(MAP_SLEEP_COUNT, mapSleepCount);
        conf.setInt(REDUCE_SLEEP_COUNT, reduceSleepCount);
        conf.setInt("mapreduce.job.maps", numMapper);
        Job job = Job.getInstance((Configuration)conf, (String)"sleep");
        job.setNumReduceTasks(numReducer);
        job.setJarByClass(SleepJob.class);
        job.setNumReduceTasks(numReducer);
        job.setMapperClass(SleepMapper.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(NullWritable.class);
        job.setReducerClass(SleepReducer.class);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setInputFormatClass(SleepInputFormat.class);
        job.setPartitionerClass(SleepJobPartitioner.class);
        job.setSpeculativeExecution(false);
        job.setJobName("Sleep job");
        FileInputFormat.addInputPath((Job)job, (Path)new Path("ignored"));
        return job;
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("SleepJob [-m numMapper] [-r numReducer] [-mt mapSleepTime (msec)] [-rt reduceSleepTime (msec)] [-recordt recordSleepTime (msec)]");
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 2;
        }
        int numMapper = 1;
        int numReducer = 1;
        long mapSleepTime = 100L;
        long reduceSleepTime = 100L;
        long recSleepTime = 100L;
        int mapSleepCount = 1;
        int reduceSleepCount = 1;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-m")) {
                numMapper = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-r")) {
                numReducer = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-mt")) {
                mapSleepTime = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-rt")) {
                reduceSleepTime = Long.parseLong(args[++i]);
                continue;
            }
            if (!args[i].equals("-recordt")) continue;
            recSleepTime = Long.parseLong(args[++i]);
        }
        mapSleepCount = (int)Math.ceil((double)mapSleepTime / (double)recSleepTime);
        Job job = this.createJob(numMapper, numReducer, mapSleepTime, mapSleepCount, reduceSleepTime, reduceSleepCount = (int)Math.ceil((double)reduceSleepTime / (double)recSleepTime));
        return job.waitForCompletion(true) ? 0 : 1;
    }
}

