/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.join.TestTupleWritable;
import org.apache.hadoop.mapred.join.TupleWritable;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestTupleWritable
extends TestCase {
    private TupleWritable makeTuple(Writable[] writs) {
        int i;
        Writable[] sub1 = new Writable[]{writs[1], writs[2]};
        Writable[] sub3 = new Writable[]{writs[4], writs[5]};
        Writable[] sub2 = new Writable[]{writs[3], new TupleWritable(sub3), writs[6]};
        Writable[] vals = new Writable[]{writs[0], new TupleWritable(sub1), new TupleWritable(sub2), writs[7], writs[8], writs[9]};
        TupleWritable ret = new TupleWritable(vals);
        for (i = 0; i < 6; ++i) {
            ret.setWritten(i);
        }
        ((TupleWritable)sub2[1]).setWritten(0);
        ((TupleWritable)sub2[1]).setWritten(1);
        ((TupleWritable)vals[1]).setWritten(0);
        ((TupleWritable)vals[1]).setWritten(1);
        for (i = 0; i < 3; ++i) {
            ((TupleWritable)vals[2]).setWritten(i);
        }
        return ret;
    }

    private Writable[] makeRandomWritables() {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        return writs;
    }

    private Writable[] makeRandomWritables(int numWrits) {
        Writable[] writs = this.makeRandomWritables();
        Writable[] manyWrits = new Writable[numWrits];
        for (int i = 0; i < manyWrits.length; ++i) {
            manyWrits[i] = writs[i % writs.length];
        }
        return manyWrits;
    }

    private int verifIter(Writable[] writs, TupleWritable t, int i) {
        for (Writable w : t) {
            if (w instanceof TupleWritable) {
                i = this.verifIter(writs, (TupleWritable)w, i);
                continue;
            }
            TestTupleWritable.assertTrue((String)"Bad value", (boolean)w.equals(writs[i++]));
        }
        return i;
    }

    public void testIterable() throws Exception {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TupleWritable t = new TupleWritable(writs);
        for (int i = 0; i < 6; ++i) {
            t.setWritten(i);
        }
        this.verifIter(writs, t, 0);
    }

    public void testNestedIterable() throws Exception {
        TupleWritable sTuple;
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TestTupleWritable.assertTrue((String)"Bad count", (writs.length == this.verifIter(writs, sTuple = this.makeTuple(writs), 0) ? 1 : 0) != 0);
    }

    public void testWritable() throws Exception {
        Random r = new Random();
        Writable[] writs = new Writable[]{new BooleanWritable(r.nextBoolean()), new FloatWritable(r.nextFloat()), new FloatWritable(r.nextFloat()), new IntWritable(r.nextInt()), new LongWritable(r.nextLong()), new BytesWritable("dingo".getBytes()), new LongWritable(r.nextLong()), new IntWritable(r.nextInt()), new BytesWritable("yak".getBytes()), new IntWritable(r.nextInt())};
        TupleWritable sTuple = this.makeTuple(writs);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Failed to write/read tuple", (boolean)sTuple.equals((Object)dTuple));
    }

    public void testWideWritable() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(131);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 3 != 0) continue;
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Failed to write/read tuple", (boolean)sTuple.equals((Object)dTuple));
        TestTupleWritable.assertEquals((String)"All tuple data has not been read from the stream", (int)-1, (int)in.read());
    }

    public void testWideWritable2() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(71);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Failed to write/read tuple", (boolean)sTuple.equals((Object)dTuple));
        TestTupleWritable.assertEquals((String)"All tuple data has not been read from the stream", (int)-1, (int)in.read());
    }

    public void testSparseWideWritable() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(131);
        TupleWritable sTuple = new TupleWritable(manyWrits);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 65 != 0) continue;
            sTuple.setWritten(i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        sTuple.write((DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Failed to write/read tuple", (boolean)sTuple.equals((Object)dTuple));
        TestTupleWritable.assertEquals((String)"All tuple data has not been read from the stream", (int)-1, (int)in.read());
    }

    public void testWideTuple() throws Exception {
        Text emptyText = new Text("Should be empty");
        Object[] values = new Writable[64];
        Arrays.fill(values, emptyText);
        values[42] = new Text("Number 42");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(42);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 42) {
                TestTupleWritable.assertTrue((boolean)has);
                continue;
            }
            TestTupleWritable.assertFalse((String)("Tuple position is incorrectly labelled as set: " + pos), (boolean)has);
        }
    }

    public void testWideTuple2() throws Exception {
        Text emptyText = new Text("Should be empty");
        Object[] values = new Writable[64];
        Arrays.fill(values, emptyText);
        values[9] = new Text("Number 9");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(9);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 9) {
                TestTupleWritable.assertTrue((boolean)has);
                continue;
            }
            TestTupleWritable.assertFalse((String)("Tuple position is incorrectly labelled as set: " + pos), (boolean)has);
        }
    }

    public void testWideTupleBoundary() throws Exception {
        Text emptyText = new Text("Should not be set written");
        Object[] values = new Writable[65];
        Arrays.fill(values, emptyText);
        values[64] = new Text("Should be the only value set written");
        TupleWritable tuple = new TupleWritable((Writable[])values);
        tuple.setWritten(64);
        for (int pos = 0; pos < tuple.size(); ++pos) {
            boolean has = tuple.has(pos);
            if (pos == 64) {
                TestTupleWritable.assertTrue((boolean)has);
                continue;
            }
            TestTupleWritable.assertFalse((String)("Tuple position is incorrectly labelled as set: " + pos), (boolean)has);
        }
    }

    public void testPreVersion21Compatibility() throws Exception {
        Writable[] manyWrits = this.makeRandomWritables(64);
        PreVersion21TupleWritable oldTuple = new PreVersion21TupleWritable(manyWrits, null);
        for (int i = 0; i < manyWrits.length; ++i) {
            if (i % 3 != 0) continue;
            PreVersion21TupleWritable.access$100((PreVersion21TupleWritable)oldTuple, (int)i);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PreVersion21TupleWritable.access$200((PreVersion21TupleWritable)oldTuple, (DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Tuple writable is unable to read pre-0.21 versions of TupleWritable", (boolean)oldTuple.isCompatible(dTuple));
        TestTupleWritable.assertEquals((String)"All tuple data has not been read from the stream", (int)-1, (int)in.read());
    }

    public void testPreVersion21CompatibilityEmptyTuple() throws Exception {
        Writable[] manyWrits = new Writable[]{};
        PreVersion21TupleWritable oldTuple = new PreVersion21TupleWritable(manyWrits, null);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PreVersion21TupleWritable.access$200((PreVersion21TupleWritable)oldTuple, (DataOutput)new DataOutputStream(out));
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        TupleWritable dTuple = new TupleWritable();
        dTuple.readFields((DataInput)new DataInputStream(in));
        TestTupleWritable.assertTrue((String)"Tuple writable is unable to read pre-0.21 versions of TupleWritable", (boolean)oldTuple.isCompatible(dTuple));
        TestTupleWritable.assertEquals((String)"All tuple data has not been read from the stream", (int)-1, (int)in.read());
    }
}

