/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TestReporter;
import org.apache.hadoop.mapred.UtilsForTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestReporter {
    private static final Path rootTempDir = new Path(System.getProperty("test.build.data", "/tmp"));
    private static final Path testRootTempDir = new Path(rootTempDir, "TestReporter");
    private static FileSystem fs = null;
    private static final String INPUT = "Hi\nHi\nHi\nHi\n";
    private static final int INPUT_LINES = "Hi\nHi\nHi\nHi\n".split("\n").length;

    @BeforeClass
    public static void setup() throws Exception {
        fs = FileSystem.getLocal((Configuration)new Configuration());
        fs.delete(testRootTempDir, true);
        fs.mkdirs(testRootTempDir);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        fs.delete(testRootTempDir, true);
    }

    @Test
    public void testReporterProgressForMapOnlyJob() throws IOException {
        Path test = new Path(testRootTempDir, "testReporterProgressForMapOnlyJob");
        JobConf conf = new JobConf();
        conf.setMapperClass(ProgressTesterMapper.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMaxMapAttempts(1);
        conf.setMaxReduceAttempts(0);
        RunningJob job = UtilsForTests.runJob((JobConf)conf, (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)1, (int)0, (String)INPUT);
        job.waitForCompletion();
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    @Test
    public void testReporterProgressForMRJob() throws IOException {
        Path test = new Path(testRootTempDir, "testReporterProgressForMRJob");
        JobConf conf = new JobConf();
        conf.setMapperClass(ProgressTesterMapper.class);
        conf.setReducerClass(ProgressTestingReducer.class);
        conf.setMapOutputKeyClass(Text.class);
        conf.setMaxMapAttempts(1);
        conf.setMaxReduceAttempts(1);
        RunningJob job = UtilsForTests.runJob((JobConf)conf, (Path)new Path(test, "in"), (Path)new Path(test, "out"), (int)1, (int)1, (String)INPUT);
        job.waitForCompletion();
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    @Test
    public void testStatusLimit() throws IOException, InterruptedException, ClassNotFoundException {
        Path test = new Path(testRootTempDir, "testStatusLimit");
        Configuration conf = new Configuration();
        Path inDir = new Path(test, "in");
        Path outDir = new Path(test, "out");
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(inDir)) {
            fs.delete(inDir, true);
        }
        fs.mkdirs(inDir);
        FSDataOutputStream file = fs.create(new Path(inDir, "part-0"));
        file.writeBytes("testStatusLimit");
        file.close();
        if (fs.exists(outDir)) {
            fs.delete(outDir, true);
        }
        Job job = Job.getInstance((Configuration)conf, (String)"testStatusLimit");
        job.setMapperClass(StatusLimitMapper.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)inDir);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        job.waitForCompletion(true);
        Assert.assertTrue((String)"Job failed", (boolean)job.isSuccessful());
    }

    static /* synthetic */ int access$000() {
        return INPUT_LINES;
    }
}

