/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapred.MiniMRClientCluster;
import org.apache.hadoop.mapred.MiniMRYarnClusterAdapter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnClusterCustomization;
import org.apache.hadoop.util.JarFinder;

public class MiniMRClientClusterFactory {
    public static MiniMRClientCluster create(Class<?> caller, int noOfNMs, Configuration conf) throws IOException {
        return MiniMRClientClusterFactory.create(caller, caller.getSimpleName(), noOfNMs, conf);
    }

    public static MiniMRClientCluster create(Class<?> caller, String identifier, int noOfNMs, Configuration conf) throws IOException {
        String customizationClassName;
        if (conf == null) {
            conf = new Configuration();
        }
        if ((customizationClassName = System.getProperty("mr.customization")) != null && !customizationClassName.isEmpty()) {
            try {
                MiniMRClientClusterFactory.class.getClassLoader().loadClass(customizationClassName).asSubclass(MiniMRYarnClusterCustomization.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).overrideConfigFromFile(conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path testRootDir = new Path("target", identifier + "-tmpDir").makeQualified(fs);
        Path appJar = new Path(testRootDir, "MRAppJar.jar");
        Path appMasterJar = new Path(MiniMRYarnCluster.APPJAR);
        Job job = Job.getInstance((Configuration)conf);
        job.addFileToClassPath(appJar);
        Path callerJar = new Path(JarFinder.getJar(caller));
        Path remoteCallerJar = new Path(testRootDir, callerJar.getName());
        job.addFileToClassPath(remoteCallerJar);
        MiniMRYarnCluster miniMRYarnCluster = new MiniMRYarnCluster(identifier, noOfNMs);
        job.getConfiguration().set("minimrclientcluster.caller.name", identifier);
        job.getConfiguration().setInt("minimrclientcluster.nodemanagers.number", noOfNMs);
        miniMRYarnCluster.init(job.getConfiguration());
        miniMRYarnCluster.start();
        fs.copyFromLocalFile(appMasterJar, appJar);
        fs.setPermission(appJar, new FsPermission("744"));
        fs.copyFromLocalFile(callerJar, remoteCallerJar);
        fs.setPermission(remoteCallerJar, new FsPermission("744"));
        return new MiniMRYarnClusterAdapter(miniMRYarnCluster);
    }
}

