/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniMapRFSCluster;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnCluster;
import org.apache.hadoop.mapreduce.v2.MiniMRYarnClusterCustomization;

public class MapRYarnClusterCustomization
implements MiniMRYarnClusterCustomization {
    private static final Log LOG = LogFactory.getLog(MiniMRYarnCluster.class);
    private static final String MR_CONFIG_OVERRIDE_FILE = "mr_config.properties";
    private MiniMapRFSCluster dfsCluster;

    @Override
    public void overrideConfigFromFile(Configuration conf) {
        MiniDFSCluster runningInstance = MiniDFSCluster.getRunningInstance();
        if (runningInstance != null && !(runningInstance instanceof MiniMapRFSCluster)) {
            LOG.info((Object)("Skipping MapR config oerride as different cluster type is running: " + runningInstance.getClass().getName()));
            return;
        }
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream(MR_CONFIG_OVERRIDE_FILE));
            LOG.info((Object)"Overriding conf with MapR settings");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                conf.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open MapR settings file: mr_config.properties");
        }
    }

    @Override
    public void setupServices(Configuration conf, int numOfNMs) {
        LOG.info((Object)"Starting MapR services");
        MiniDFSCluster runningInstance = MiniDFSCluster.getRunningInstance();
        if (runningInstance != null) {
            if (runningInstance instanceof MiniMapRFSCluster) {
                LOG.info((Object)"MiniMapRFSCluster already running. Will reuse that.");
            } else {
                LOG.info((Object)("Skipping MapRFS cluster creation as different cluster type is running: " + runningInstance.getClass().getName()));
            }
        } else {
            try {
                this.dfsCluster = (MiniMapRFSCluster)new MiniDFSCluster.Builder(conf).numDataNodes(numOfNMs).build(MiniMapRFSCluster.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void teardownServices() {
        LOG.info((Object)"Shutting down MapR services");
        if (this.dfsCluster != null) {
            this.dfsCluster.shutdown();
        }
    }
}

