/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.util.List;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class VerifyJobsUtils {
    public static void verifyHsJobPartial(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)12L, (long)info.length());
        VerifyJobsUtils.verifyHsJobGeneric((Job)job, (String)info.getString("id"), (String)info.getString("user"), (String)info.getString("name"), (String)info.getString("state"), (String)info.getString("queue"), (long)info.getLong("startTime"), (long)info.getLong("finishTime"), (int)info.getInt("mapsTotal"), (int)info.getInt("mapsCompleted"), (int)info.getInt("reducesTotal"), (int)info.getInt("reducesCompleted"));
    }

    public static void verifyHsJob(JSONObject info, Job job) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)25L, (long)info.length());
        VerifyJobsUtils.verifyHsJobGeneric((Job)job, (String)info.getString("id"), (String)info.getString("user"), (String)info.getString("name"), (String)info.getString("state"), (String)info.getString("queue"), (long)info.getLong("startTime"), (long)info.getLong("finishTime"), (int)info.getInt("mapsTotal"), (int)info.getInt("mapsCompleted"), (int)info.getInt("reducesTotal"), (int)info.getInt("reducesCompleted"));
        String diagnostics = "";
        if (info.has("diagnostics")) {
            diagnostics = info.getString("diagnostics");
        }
        VerifyJobsUtils.verifyHsJobGenericSecure((Job)job, (Boolean)info.getBoolean("uberized"), (String)diagnostics, (long)info.getLong("avgMapTime"), (long)info.getLong("avgReduceTime"), (long)info.getLong("avgShuffleTime"), (long)info.getLong("avgMergeTime"), (int)info.getInt("failedReduceAttempts"), (int)info.getInt("killedReduceAttempts"), (int)info.getInt("successfulReduceAttempts"), (int)info.getInt("failedMapAttempts"), (int)info.getInt("killedMapAttempts"), (int)info.getInt("successfulMapAttempts"));
    }

    public static void verifyHsJobGeneric(Job job, String id, String user, String name, String state, String queue, long startTime, long finishTime, int mapsTotal, int mapsCompleted, int reducesTotal, int reducesCompleted) {
        JobReport report = job.getReport();
        WebServicesTestUtils.checkStringMatch((String)"id", (String)MRApps.toString((JobId)job.getID()), (String)id);
        WebServicesTestUtils.checkStringMatch((String)"user", (String)job.getUserName().toString(), (String)user);
        WebServicesTestUtils.checkStringMatch((String)"name", (String)job.getName(), (String)name);
        WebServicesTestUtils.checkStringMatch((String)"state", (String)job.getState().toString(), (String)state);
        WebServicesTestUtils.checkStringMatch((String)"queue", (String)job.getQueueName(), (String)queue);
        Assert.assertEquals((String)"startTime incorrect", (long)report.getStartTime(), (long)startTime);
        Assert.assertEquals((String)"finishTime incorrect", (long)report.getFinishTime(), (long)finishTime);
        Assert.assertEquals((String)"mapsTotal incorrect", (long)job.getTotalMaps(), (long)mapsTotal);
        Assert.assertEquals((String)"mapsCompleted incorrect", (long)job.getCompletedMaps(), (long)mapsCompleted);
        Assert.assertEquals((String)"reducesTotal incorrect", (long)job.getTotalReduces(), (long)reducesTotal);
        Assert.assertEquals((String)"reducesCompleted incorrect", (long)job.getCompletedReduces(), (long)reducesCompleted);
    }

    public static void verifyHsJobGenericSecure(Job job, Boolean uberized, String diagnostics, long avgMapTime, long avgReduceTime, long avgShuffleTime, long avgMergeTime, int failedReduceAttempts, int killedReduceAttempts, int successfulReduceAttempts, int failedMapAttempts, int killedMapAttempts, int successfulMapAttempts) {
        String diagString = "";
        List diagList = job.getDiagnostics();
        if (diagList != null && !diagList.isEmpty()) {
            StringBuffer b = new StringBuffer();
            for (String diag : diagList) {
                b.append(diag);
            }
            diagString = b.toString();
        }
        WebServicesTestUtils.checkStringMatch((String)"diagnostics", (String)diagString, (String)diagnostics);
        Assert.assertEquals((String)"isUber incorrect", (Object)job.isUber(), (Object)uberized);
        Assert.assertTrue((String)"failedReduceAttempts not >= 0", (failedReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"killedReduceAttempts not >= 0", (killedReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"successfulReduceAttempts not >= 0", (successfulReduceAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"failedMapAttempts not >= 0", (failedMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"killedMapAttempts not >= 0", (killedMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"successfulMapAttempts not >= 0", (successfulMapAttempts >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"avgMapTime not >= 0", (avgMapTime >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"avgReduceTime not >= 0", (avgReduceTime >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"avgShuffleTime not >= 0", (avgShuffleTime >= 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"avgMergeTime not >= 0", (avgMergeTime >= 0L ? 1 : 0) != 0);
    }
}

