/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.hs.JobHistory;
import org.apache.hadoop.mapreduce.v2.hs.client.HSAdmin;
import org.apache.hadoop.mapreduce.v2.hs.server.HSAdminServer;
import org.apache.hadoop.mapreduce.v2.hs.server.TestHSAdminServer;
import org.apache.hadoop.security.GroupMappingServiceProvider;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogDeletionService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestHSAdminServer {
    private boolean securityEnabled = true;
    private HSAdminServer hsAdminServer = null;
    private HSAdmin hsAdminClient = null;
    JobConf conf = null;
    private static long groupRefreshTimeoutSec = 1L;
    JobHistory jobHistoryService = null;
    AggregatedLogDeletionService alds = null;

    @Parameterized.Parameters
    public static Collection<Object[]> testParameters() {
        return Arrays.asList({false}, {true});
    }

    public TestHSAdminServer(boolean enableSecurity) {
        this.securityEnabled = enableSecurity;
    }

    @Before
    public void init() throws HadoopIllegalArgumentException, IOException {
        this.conf = new JobConf();
        this.conf.set("mapreduce.jobhistory.admin.address", "0.0.0.0:0");
        this.conf.setClass("hadoop.security.group.mapping", MockUnixGroupsMapping.class, GroupMappingServiceProvider.class);
        this.conf.setLong("hadoop.security.groups.cache.secs", groupRefreshTimeoutSec);
        this.conf.setBoolean("hadoop.security.authorization", this.securityEnabled);
        Groups.getUserToGroupsMappingService((Configuration)this.conf);
        this.jobHistoryService = (JobHistory)Mockito.mock(JobHistory.class);
        this.alds = (AggregatedLogDeletionService)Mockito.mock(AggregatedLogDeletionService.class);
        this.hsAdminServer = new /* Unavailable Anonymous Inner Class!! */;
        this.hsAdminServer.init((Configuration)this.conf);
        this.hsAdminServer.start();
        this.conf.setSocketAddr("mapreduce.jobhistory.admin.address", this.hsAdminServer.clientRpcServer.getListenerAddress());
        this.hsAdminClient = new HSAdmin(this.conf);
    }

    @Test
    public void testGetGroups() throws Exception {
        String user = UserGroupInformation.getCurrentUser().getUserName();
        String[] args = new String[]{"-getGroups", user};
        int exitCode = this.hsAdminClient.run(args);
        Assert.assertEquals((String)("Exit code should be 0 but was: " + exitCode), (long)0L, (long)exitCode);
    }

    @Test
    public void testRefreshUserToGroupsMappings() throws Exception {
        String[] args = new String[]{"-refreshUserToGroupsMappings"};
        Groups groups = Groups.getUserToGroupsMappingService((Configuration)this.conf);
        String user = UserGroupInformation.getCurrentUser().getUserName();
        System.out.println("first attempt:");
        List g1 = groups.getGroups(user);
        Object[] str_groups = new String[g1.size()];
        g1.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        System.out.println("second attempt, should be same:");
        List g2 = groups.getGroups(user);
        g2.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        for (int i = 0; i < g2.size(); ++i) {
            Assert.assertEquals((String)"Should be same group ", g1.get(i), g2.get(i));
        }
        this.hsAdminClient.run(args);
        System.out.println("third attempt(after refresh command), should be different:");
        List g3 = groups.getGroups(user);
        g3.toArray(str_groups);
        System.out.println(Arrays.toString(str_groups));
        for (int i = 0; i < g3.size(); ++i) {
            Assert.assertFalse((String)("Should be different group: " + (String)g1.get(i) + " and " + (String)g3.get(i)), (boolean)((String)g1.get(i)).equals(g3.get(i)));
        }
    }

    @Test
    public void testRefreshSuperUserGroups() throws Exception {
        UserGroupInformation ugi = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        UserGroupInformation superUser = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
        Mockito.when((Object)ugi.getRealUser()).thenReturn((Object)superUser);
        Mockito.when((Object)superUser.getShortUserName()).thenReturn((Object)"superuser");
        Mockito.when((Object)superUser.getUserName()).thenReturn((Object)"superuser");
        Mockito.when((Object)ugi.getGroupNames()).thenReturn((Object)new String[]{"group3"});
        Mockito.when((Object)ugi.getUserName()).thenReturn((Object)"regularUser");
        this.conf.set("hadoop.proxyuser.superuser.groups", "group1,group2");
        this.conf.set("hadoop.proxyuser.superuser.hosts", "127.0.0.1");
        String[] args = new String[]{"-refreshSuperUserGroupsConfiguration"};
        this.hsAdminClient.run(args);
        Exception th = null;
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi, (String)"127.0.0.1");
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof AuthorizationException));
        this.conf.set("hadoop.proxyuser.superuser.groups", "group1,group2,group3");
        th = null;
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi, (String)"127.0.0.1");
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof AuthorizationException));
        this.hsAdminClient.run(args);
        th = null;
        try {
            ProxyUsers.authorize((UserGroupInformation)ugi, (String)"127.0.0.1");
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertNull((String)("Unexpected exception thrown: " + th), (Object)th);
    }

    @Test
    public void testRefreshAdminAcls() throws Exception {
        this.conf.set("mapreduce.jobhistory.admin.acl", UserGroupInformation.getCurrentUser().getUserName());
        String[] args = new String[]{"-refreshAdminAcls"};
        this.hsAdminClient.run(args);
        args[0] = "-refreshSuperUserGroupsConfiguration";
        this.hsAdminClient.run(args);
        this.conf.set("mapreduce.jobhistory.admin.acl", "notCurrentUser");
        args[0] = "-refreshAdminAcls";
        this.hsAdminClient.run(args);
        Exception th = null;
        args[0] = "-refreshSuperUserGroupsConfiguration";
        try {
            this.hsAdminClient.run(args);
        }
        catch (Exception e) {
            th = e;
        }
        Assert.assertTrue((boolean)(th instanceof RemoteException));
    }

    @Test
    public void testRefreshLoadedJobCache() throws Exception {
        String[] args = new String[]{"-refreshLoadedJobCache"};
        this.hsAdminClient.run(args);
        ((JobHistory)Mockito.verify((Object)this.jobHistoryService)).refreshLoadedJobCache();
    }

    @Test
    public void testRefreshLogRetentionSettings() throws Exception {
        String[] args = new String[]{"-refreshLogRetentionSettings"};
        this.hsAdminClient.run(args);
        ((AggregatedLogDeletionService)Mockito.verify((Object)this.alds)).refreshLogRetentionSettings();
    }

    @Test
    public void testRefreshJobRetentionSettings() throws Exception {
        String[] args = new String[]{"-refreshJobRetentionSettings"};
        this.hsAdminClient.run(args);
        ((JobHistory)Mockito.verify((Object)this.jobHistoryService)).refreshJobRetentionSettings();
    }

    @After
    public void cleanUp() {
        if (this.hsAdminServer != null) {
            this.hsAdminServer.stop();
        }
    }
}

