/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerLeveldbStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreServiceFactory;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.server.records.Version;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestHistoryServerLeveldbStateStoreService {
    private static final File testDir = new File(System.getProperty("test.build.data", System.getProperty("java.io.tmpdir")), "TestHistoryServerLeveldbSystemStateStoreService");
    private Configuration conf;

    @Before
    public void setup() {
        FileUtil.fullyDelete((File)testDir);
        testDir.mkdirs();
        this.conf = new Configuration();
        this.conf.setBoolean("mapreduce.jobhistory.recovery.enable", true);
        this.conf.setClass("mapreduce.jobhistory.recovery.store.class", HistoryServerLeveldbStateStoreService.class, HistoryServerStateStoreService.class);
        this.conf.set("mapreduce.jobhistory.recovery.store.leveldb.path", testDir.getAbsoluteFile().toString());
    }

    @After
    public void cleanup() {
        FileUtil.fullyDelete((File)testDir);
    }

    private HistoryServerStateStoreService createAndStartStore() throws IOException {
        HistoryServerStateStoreService store = HistoryServerStateStoreServiceFactory.getStore((Configuration)this.conf);
        Assert.assertTrue((String)"Factory did not create a leveldb store", (boolean)(store instanceof HistoryServerLeveldbStateStoreService));
        store.init(this.conf);
        store.start();
        return store;
    }

    @Test
    public void testCheckVersion() throws IOException {
        HistoryServerLeveldbStateStoreService store = new HistoryServerLeveldbStateStoreService();
        store.init(this.conf);
        store.start();
        Version defaultVersion = store.getCurrentVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        store.dbStoreVersion(compatibleVersion);
        Assert.assertEquals((Object)compatibleVersion, (Object)store.loadVersion());
        store.close();
        store = new HistoryServerLeveldbStateStoreService();
        store.init(this.conf);
        store.start();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        store.dbStoreVersion(incompatibleVersion);
        store.close();
        store = new HistoryServerLeveldbStateStoreService();
        try {
            store.init(this.conf);
            store.start();
            Assert.fail((String)"Incompatible version, should have thrown before here.");
        }
        catch (ServiceStateException e) {
            Assert.assertTrue((String)"Exception message mismatch", (boolean)e.getMessage().contains("Incompatible version for state:"));
        }
        store.close();
    }

    @Test
    public void testTokenStore() throws IOException {
        HistoryServerStateStoreService store = this.createAndStartStore();
        HistoryServerStateStoreService.HistoryServerState state = store.loadState();
        Assert.assertTrue((String)"token state not empty", (boolean)state.tokenState.isEmpty());
        Assert.assertTrue((String)"key state not empty", (boolean)state.tokenMasterKeyState.isEmpty());
        DelegationKey key1 = new DelegationKey(1, 2L, "keyData1".getBytes());
        MRDelegationTokenIdentifier token1 = new MRDelegationTokenIdentifier(new Text("tokenOwner1"), new Text("tokenRenewer1"), new Text("tokenUser1"));
        token1.setSequenceNumber(1);
        Long tokenDate1 = 1L;
        MRDelegationTokenIdentifier token2 = new MRDelegationTokenIdentifier(new Text("tokenOwner2"), new Text("tokenRenewer2"), new Text("tokenUser2"));
        token2.setSequenceNumber(12345678);
        Long tokenDate2 = 87654321L;
        store.storeTokenMasterKey(key1);
        store.storeToken(token1, tokenDate1);
        store.storeToken(token2, tokenDate2);
        store.close();
        store = this.createAndStartStore();
        state = store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertTrue((String)"missing token 1", (boolean)state.tokenState.containsKey(token1));
        Assert.assertEquals((String)"incorrect token 1 date", (Object)tokenDate1, state.tokenState.get(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)tokenDate2, state.tokenState.get(token2));
        Assert.assertEquals((String)"incorrect master key count", (long)1L, (long)state.tokenMasterKeyState.size());
        Assert.assertTrue((String)"missing master key 1", (boolean)state.tokenMasterKeyState.contains(key1));
        DelegationKey key2 = new DelegationKey(3, 4L, "keyData2".getBytes());
        DelegationKey key3 = new DelegationKey(5, 6L, "keyData3".getBytes());
        MRDelegationTokenIdentifier token3 = new MRDelegationTokenIdentifier(new Text("tokenOwner3"), new Text("tokenRenewer3"), new Text("tokenUser3"));
        token3.setSequenceNumber(12345679);
        Long tokenDate3 = 87654321L;
        store.removeToken(token1);
        store.storeTokenMasterKey(key2);
        Long newTokenDate2 = 975318642L;
        store.updateToken(token2, newTokenDate2);
        store.removeTokenMasterKey(key1);
        store.storeTokenMasterKey(key3);
        store.storeToken(token3, tokenDate3);
        store.close();
        store = this.createAndStartStore();
        state = store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertFalse((String)"token 1 not removed", (boolean)state.tokenState.containsKey(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)newTokenDate2, state.tokenState.get(token2));
        Assert.assertTrue((String)"missing token 3", (boolean)state.tokenState.containsKey(token3));
        Assert.assertEquals((String)"incorrect token 3 date", (Object)tokenDate3, state.tokenState.get(token3));
        Assert.assertEquals((String)"incorrect master key count", (long)2L, (long)state.tokenMasterKeyState.size());
        Assert.assertFalse((String)"master key 1 not removed", (boolean)state.tokenMasterKeyState.contains(key1));
        Assert.assertTrue((String)"missing master key 2", (boolean)state.tokenMasterKeyState.contains(key2));
        Assert.assertTrue((String)"missing master key 3", (boolean)state.tokenMasterKeyState.contains(key3));
        store.close();
    }
}

