/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.MRDelegationTokenIdentifier;
import org.apache.hadoop.mapreduce.v2.hs.HistoryServerStateStoreService;
import org.apache.hadoop.security.token.delegation.DelegationKey;

class HistoryServerMemStateStoreService
extends HistoryServerStateStoreService {
    HistoryServerStateStoreService.HistoryServerState state;

    HistoryServerMemStateStoreService() {
    }

    protected void initStorage(Configuration conf) throws IOException {
    }

    protected void startStorage() throws IOException {
        this.state = new HistoryServerStateStoreService.HistoryServerState();
    }

    protected void closeStorage() throws IOException {
        this.state = null;
    }

    public HistoryServerStateStoreService.HistoryServerState loadState() throws IOException {
        HistoryServerStateStoreService.HistoryServerState result = new HistoryServerStateStoreService.HistoryServerState();
        result.tokenState.putAll(this.state.tokenState);
        result.tokenMasterKeyState.addAll(this.state.tokenMasterKeyState);
        return result;
    }

    public void storeToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (this.state.tokenState.containsKey(tokenId)) {
            throw new IOException("token " + tokenId + " was stored twice");
        }
        this.state.tokenState.put(tokenId, renewDate);
    }

    public void updateToken(MRDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        if (!this.state.tokenState.containsKey(tokenId)) {
            throw new IOException("token " + tokenId + " not in store");
        }
        this.state.tokenState.put(tokenId, renewDate);
    }

    public void removeToken(MRDelegationTokenIdentifier tokenId) throws IOException {
        this.state.tokenState.remove(tokenId);
    }

    public void storeTokenMasterKey(DelegationKey key) throws IOException {
        if (this.state.tokenMasterKeyState.contains(key)) {
            throw new IOException("token master key " + key + " was stored twice");
        }
        this.state.tokenMasterKeyState.add(key);
    }

    public void removeTokenMasterKey(DelegationKey key) throws IOException {
        this.state.tokenMasterKeyState.remove(key);
    }
}

