/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.servlet.GuiceFilter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.JerseyTest;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.io.StringReader;
import javax.ws.rs.core.MediaType;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JobHistoryServer;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServices;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestHsWebServices
extends JerseyTest {
    private static Configuration conf = new Configuration();
    private static HistoryContext appContext;
    private static HsWebApp webApp;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new /* Unavailable Anonymous Inner Class!! */});

    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    public TestHsWebServices() {
        super((AppDescriptor)new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.mapreduce.v2.hs.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
    }

    @Test
    public void testHS() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testHSSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testHSDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history/").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testHSXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyHSInfoXML(xml, (AppContext)appContext);
    }

    @Test
    public void testInfo() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("info").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testInfoSlash() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("info/").accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testInfoDefault() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("info/").get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        this.verifyHSInfo(json.getJSONObject("historyInfo"), (AppContext)appContext);
    }

    @Test
    public void testInfoXML() throws JSONException, Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("history").path("info/").accept(new String[]{"application/xml"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_XML_TYPE, (Object)response.getType());
        String xml = (String)response.getEntity(String.class);
        this.verifyHSInfoXML(xml, (AppContext)appContext);
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("history").path("bogus").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("invalid").accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("history").accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    public void verifyHsInfoGeneric(String hadoopVersionBuiltOn, String hadoopBuildVersion, String hadoopVersion, long startedon) {
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersionBuiltOn", (String)VersionInfo.getDate(), (String)hadoopVersionBuiltOn);
        WebServicesTestUtils.checkStringEqual((String)"hadoopBuildVersion", (String)VersionInfo.getBuildVersion(), (String)hadoopBuildVersion);
        WebServicesTestUtils.checkStringMatch((String)"hadoopVersion", (String)VersionInfo.getVersion(), (String)hadoopVersion);
        Assert.assertEquals((String)"startedOn doesn't match: ", (long)JobHistoryServer.historyServerTimeStamp, (long)startedon);
    }

    public void verifyHSInfo(JSONObject info, AppContext ctx) throws JSONException {
        Assert.assertEquals((String)"incorrect number of elements", (long)4L, (long)info.length());
        this.verifyHsInfoGeneric(info.getString("hadoopVersionBuiltOn"), info.getString("hadoopBuildVersion"), info.getString("hadoopVersion"), info.getLong("startedOn"));
    }

    public void verifyHSInfoXML(String xml, AppContext ctx) throws JSONException, Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xml));
        Document dom = db.parse(is);
        NodeList nodes = dom.getElementsByTagName("historyInfo");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element = (Element)nodes.item(i);
            this.verifyHsInfoGeneric(WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersionBuiltOn"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopBuildVersion"), WebServicesTestUtils.getXmlString((Element)element, (String)"hadoopVersion"), WebServicesTestUtils.getXmlLong((Element)element, (String)"startedOn"));
        }
    }

    static /* synthetic */ HistoryContext access$002(HistoryContext x0) {
        appContext = x0;
        return appContext;
    }

    static /* synthetic */ HsWebApp access$102(HsWebApp x0) {
        webApp = x0;
        return webApp;
    }

    static /* synthetic */ HsWebApp access$100() {
        return webApp;
    }

    static /* synthetic */ HistoryContext access$000() {
        return appContext;
    }

    static /* synthetic */ Configuration access$200() {
        return conf;
    }

    static /* synthetic */ Injector access$300(TestHsWebServices x0) {
        return x0.injector;
    }
}

