/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.TaskCompletionEvent;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.hs.CompletedJob;
import org.apache.hadoop.mapreduce.v2.hs.HistoryFileManager;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class TestJobHistoryEntities {
    private final String historyFileName = "job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist";
    private final String confFileName = "job_1329348432655_0001_conf.xml";
    private final Configuration conf = new Configuration();
    private final JobACLsManager jobAclsManager = new JobACLsManager(this.conf);
    private boolean loadTasks;
    private JobId jobId = MRBuilderUtils.newJobId((long)1329348432655L, (int)1, (int)1);
    Path fulleHistoryPath = new Path(this.getClass().getClassLoader().getResource("job_1329348432655_0001-1329348443227-user-Sleep+job-1329348468601-10-1-SUCCEEDED-default.jhist").getFile());
    Path fullConfPath = new Path(this.getClass().getClassLoader().getResource("job_1329348432655_0001_conf.xml").getFile());
    private CompletedJob completedJob;

    public TestJobHistoryEntities(boolean loadTasks) throws Exception {
        this.loadTasks = loadTasks;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>(2);
        list.add(new Object[]{true});
        list.add(new Object[]{false});
        return list;
    }

    @Test(timeout=100000L)
    public void testCompletedJob() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fulleHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        junit.framework.Assert.assertEquals((boolean)this.loadTasks, (boolean)this.completedJob.tasksLoaded.get());
        junit.framework.Assert.assertEquals((int)1, (int)this.completedJob.getAMInfos().size());
        junit.framework.Assert.assertEquals((int)10, (int)this.completedJob.getCompletedMaps());
        junit.framework.Assert.assertEquals((int)1, (int)this.completedJob.getCompletedReduces());
        junit.framework.Assert.assertEquals((int)12, (int)this.completedJob.getTasks().size());
        junit.framework.Assert.assertEquals((boolean)true, (boolean)this.completedJob.tasksLoaded.get());
        junit.framework.Assert.assertEquals((int)10, (int)this.completedJob.getTasks(TaskType.MAP).size());
        junit.framework.Assert.assertEquals((int)2, (int)this.completedJob.getTasks(TaskType.REDUCE).size());
        junit.framework.Assert.assertEquals((String)"user", (String)this.completedJob.getUserName());
        junit.framework.Assert.assertEquals((Object)JobState.SUCCEEDED, (Object)this.completedJob.getState());
        JobReport jobReport = this.completedJob.getReport();
        junit.framework.Assert.assertEquals((String)"user", (String)jobReport.getUser());
        junit.framework.Assert.assertEquals((Object)JobState.SUCCEEDED, (Object)jobReport.getJobState());
    }

    @Test(timeout=10000L)
    public void testCompletedTask() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fulleHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskId mt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.MAP);
        TaskId rt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.REDUCE);
        Map mapTasks = this.completedJob.getTasks(TaskType.MAP);
        Map reduceTasks = this.completedJob.getTasks(TaskType.REDUCE);
        junit.framework.Assert.assertEquals((int)10, (int)mapTasks.size());
        junit.framework.Assert.assertEquals((int)2, (int)reduceTasks.size());
        Task mt1 = (Task)mapTasks.get(mt1Id);
        junit.framework.Assert.assertEquals((int)1, (int)mt1.getAttempts().size());
        junit.framework.Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)mt1.getState());
        TaskReport mt1Report = mt1.getReport();
        junit.framework.Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)mt1Report.getTaskState());
        junit.framework.Assert.assertEquals((Object)mt1Id, (Object)mt1Report.getTaskId());
        Task rt1 = (Task)reduceTasks.get(rt1Id);
        junit.framework.Assert.assertEquals((int)1, (int)rt1.getAttempts().size());
        junit.framework.Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)rt1.getState());
        TaskReport rt1Report = rt1.getReport();
        junit.framework.Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)rt1Report.getTaskState());
        junit.framework.Assert.assertEquals((Object)rt1Id, (Object)rt1Report.getTaskId());
    }

    @Test(timeout=10000L)
    public void testCompletedTaskAttempt() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fulleHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskId mt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.MAP);
        TaskId rt1Id = MRBuilderUtils.newTaskId((JobId)this.jobId, (int)0, (TaskType)TaskType.REDUCE);
        TaskAttemptId mta1Id = MRBuilderUtils.newTaskAttemptId((TaskId)mt1Id, (int)0);
        TaskAttemptId rta1Id = MRBuilderUtils.newTaskAttemptId((TaskId)rt1Id, (int)0);
        Task mt1 = this.completedJob.getTask(mt1Id);
        Task rt1 = this.completedJob.getTask(rt1Id);
        TaskAttempt mta1 = mt1.getAttempt(mta1Id);
        junit.framework.Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)mta1.getState());
        junit.framework.Assert.assertEquals((String)"localhost:45454", (String)mta1.getAssignedContainerMgrAddress());
        junit.framework.Assert.assertEquals((String)"localhost:9999", (String)mta1.getNodeHttpAddress());
        TaskAttemptReport mta1Report = mta1.getReport();
        junit.framework.Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)mta1Report.getTaskAttemptState());
        junit.framework.Assert.assertEquals((String)"localhost", (String)mta1Report.getNodeManagerHost());
        junit.framework.Assert.assertEquals((int)45454, (int)mta1Report.getNodeManagerPort());
        junit.framework.Assert.assertEquals((int)9999, (int)mta1Report.getNodeManagerHttpPort());
        TaskAttempt rta1 = rt1.getAttempt(rta1Id);
        junit.framework.Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)rta1.getState());
        junit.framework.Assert.assertEquals((String)"localhost:45454", (String)rta1.getAssignedContainerMgrAddress());
        junit.framework.Assert.assertEquals((String)"localhost:9999", (String)rta1.getNodeHttpAddress());
        TaskAttemptReport rta1Report = rta1.getReport();
        junit.framework.Assert.assertEquals((Object)TaskAttemptState.SUCCEEDED, (Object)rta1Report.getTaskAttemptState());
        junit.framework.Assert.assertEquals((String)"localhost", (String)rta1Report.getNodeManagerHost());
        junit.framework.Assert.assertEquals((int)45454, (int)rta1Report.getNodeManagerPort());
        junit.framework.Assert.assertEquals((int)9999, (int)rta1Report.getNodeManagerHttpPort());
    }

    @Test(timeout=30000L)
    public void testGetTaskAttemptCompletionEvent() throws Exception {
        HistoryFileManager.HistoryFileInfo info = (HistoryFileManager.HistoryFileInfo)Mockito.mock(HistoryFileManager.HistoryFileInfo.class);
        Mockito.when((Object)info.getConfFile()).thenReturn((Object)this.fullConfPath);
        this.completedJob = new CompletedJob(this.conf, this.jobId, this.fulleHistoryPath, this.loadTasks, "user", info, this.jobAclsManager);
        TaskCompletionEvent[] events = this.completedJob.getMapAttemptCompletionEvents(0, 1000);
        junit.framework.Assert.assertEquals((int)10, (int)this.completedJob.getMapAttemptCompletionEvents(0, 10).length);
        int currentEventId = 0;
        for (TaskCompletionEvent taskAttemptCompletionEvent : events) {
            int eventId = taskAttemptCompletionEvent.getEventId();
            Assert.assertTrue((eventId >= currentEventId ? 1 : 0) != 0);
            currentEventId = eventId;
        }
        Assert.assertNull((Object)this.completedJob.loadConfFile());
        junit.framework.Assert.assertEquals((String)"Sleep job", (String)this.completedJob.getName());
        junit.framework.Assert.assertEquals((String)"default", (String)this.completedJob.getQueueName());
        junit.framework.Assert.assertEquals((double)1.0, (double)this.completedJob.getProgress(), (double)0.001);
        junit.framework.Assert.assertEquals((int)12, (int)this.completedJob.getTaskAttemptCompletionEvents(0, 1000).length);
        junit.framework.Assert.assertEquals((int)10, (int)this.completedJob.getTaskAttemptCompletionEvents(0, 10).length);
        junit.framework.Assert.assertEquals((int)7, (int)this.completedJob.getTaskAttemptCompletionEvents(5, 10).length);
        junit.framework.Assert.assertEquals((int)1, (int)this.completedJob.getDiagnostics().size());
        junit.framework.Assert.assertEquals((String)"", (String)((String)this.completedJob.getDiagnostics().get(0)));
        junit.framework.Assert.assertEquals((int)0, (int)this.completedJob.getJobACLs().size());
    }
}

