/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.mapreduce.v2.api.HSClientProtocol;
import org.apache.hadoop.mapreduce.v2.api.MRClientProtocol;
import org.apache.hadoop.mapreduce.v2.app.security.authorize.ClientHSPolicyProvider;
import org.apache.hadoop.mapreduce.v2.hs.HistoryClientService;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.JHSDelegationTokenSecretManager;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.util.MRWebAppUtil;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;

public class HistoryClientService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(HistoryClientService.class);
    private HSClientProtocol protocolHandler;
    private Server server;
    private WebApp webApp;
    private InetSocketAddress bindAddress;
    private HistoryContext history;
    private JHSDelegationTokenSecretManager jhsDTSecretManager;

    public HistoryClientService(HistoryContext history, JHSDelegationTokenSecretManager jhsDTSecretManager) {
        super("HistoryClientService");
        this.history = history;
        this.protocolHandler = new HSClientProtocolHandler(this, null);
        this.jhsDTSecretManager = jhsDTSecretManager;
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.initializeWebApp(conf);
        InetSocketAddress address = conf.getSocketAddr("mapreduce.jobhistory.address", "0.0.0.0:10020", 10020);
        this.server = rpc.getServer(HSClientProtocol.class, (Object)this.protocolHandler, address, conf, (SecretManager)this.jhsDTSecretManager, conf.getInt("mapreduce.jobhistory.client.thread-count", 10));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new ClientHSPolicyProvider());
        }
        this.server.start();
        this.bindAddress = conf.updateConnectAddr("mapreduce.jobhistory.address", this.server.getListenerAddress());
        LOG.info((Object)("Instantiated MRClientService at " + this.bindAddress));
        super.serviceStart();
    }

    private void initializeWebApp(Configuration conf) {
        this.webApp = new HsWebApp(this.history);
        InetSocketAddress bindAddress = MRWebAppUtil.getJHSWebBindAddress((Configuration)conf);
        WebApps.$for((String)"jobhistory", HistoryClientService.class, (Object)this, (String)"ws").with(conf).withHttpSpnegoKeytabKey("mapreduce.jobhistory.webapp.spnego-keytab-file").withHttpSpnegoPrincipalKey("mapreduce.jobhistory.webapp.spnego-principal").at(NetUtils.getHostPortString((InetSocketAddress)bindAddress)).start(this.webApp);
        MRWebAppUtil.setJHSWebappURLWithoutScheme((Configuration)conf, (String)NetUtils.getHostPortString((InetSocketAddress)this.webApp.getListenerAddress()));
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        if (this.webApp != null) {
            this.webApp.stop();
        }
        super.serviceStop();
    }

    @InterfaceAudience.Private
    public MRClientProtocol getClientHandler() {
        return this.protocolHandler;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    static /* synthetic */ HistoryContext access$100(HistoryClientService x0) {
        return x0.history;
    }

    static /* synthetic */ JHSDelegationTokenSecretManager access$200(HistoryClientService x0) {
        return x0.jhsDTSecretManager;
    }
}

