/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs.webapp;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.hs.HistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.MockHistoryContext;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebApp;
import org.apache.hadoop.mapreduce.v2.hs.webapp.HsWebServices;
import org.apache.hadoop.mapreduce.v2.hs.webapp.TestHsWebServicesAcls;
import org.apache.hadoop.security.Groups;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestHsWebServicesAcls {
    private static String FRIENDLY_USER = "friendly";
    private static String ENEMY_USER = "enemy";
    private JobConf conf;
    private HistoryContext ctx;
    private String jobIdStr;
    private String taskIdStr;
    private String taskAttemptIdStr;
    private HsWebServices hsWebServices;

    @Before
    public void setup() throws IOException {
        this.conf = new JobConf();
        this.conf.set("hadoop.security.group.mapping", NullGroupsProvider.class.getName());
        this.conf.setBoolean("mapreduce.cluster.acls.enabled", true);
        Groups.getUserToGroupsMappingService((Configuration)this.conf);
        this.ctx = TestHsWebServicesAcls.buildHistoryContext((Configuration)this.conf);
        WebApp webApp = (WebApp)Mockito.mock(HsWebApp.class);
        Mockito.when((Object)webApp.name()).thenReturn((Object)"hsmockwebapp");
        this.hsWebServices = new HsWebServices(this.ctx, (Configuration)this.conf, webApp);
        this.hsWebServices.setResponse((HttpServletResponse)Mockito.mock(HttpServletResponse.class));
        Job job = (Job)this.ctx.getAllJobs().values().iterator().next();
        this.jobIdStr = job.getID().toString();
        Task task = (Task)job.getTasks().values().iterator().next();
        this.taskIdStr = task.getID().toString();
        this.taskAttemptIdStr = ((TaskAttemptId)task.getAttempts().keySet().iterator().next()).toString();
    }

    @Test
    public void testGetJobAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJob(hsr, this.jobIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJob(hsr, this.jobIdStr);
    }

    @Test
    public void testGetJobCountersAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobCounters(hsr, this.jobIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobCounters(hsr, this.jobIdStr);
    }

    @Test
    public void testGetJobConfAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobConf(hsr, this.jobIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobConf(hsr, this.jobIdStr);
    }

    @Test
    public void testGetJobTasksAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobTasks(hsr, this.jobIdStr, "m");
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobTasks(hsr, this.jobIdStr, "m");
    }

    @Test
    public void testGetJobTaskAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobTask(hsr, this.jobIdStr, this.taskIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobTask(hsr, this.jobIdStr, this.taskIdStr);
    }

    @Test
    public void testGetSingleTaskCountersAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getSingleTaskCounters(hsr, this.jobIdStr, this.taskIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getSingleTaskCounters(hsr, this.jobIdStr, this.taskIdStr);
    }

    @Test
    public void testGetJobTaskAttemptsAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobTaskAttempts(hsr, this.jobIdStr, this.taskIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobTaskAttempts(hsr, this.jobIdStr, this.taskIdStr);
    }

    @Test
    public void testGetJobTaskAttemptIdAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobTaskAttemptId(hsr, this.jobIdStr, this.taskIdStr, this.taskAttemptIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobTaskAttemptId(hsr, this.jobIdStr, this.taskIdStr, this.taskAttemptIdStr);
    }

    @Test
    public void testGetJobTaskAttemptIdCountersAcls() {
        HttpServletRequest hsr = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)ENEMY_USER);
        try {
            this.hsWebServices.getJobTaskAttemptIdCounters(hsr, this.jobIdStr, this.taskIdStr, this.taskAttemptIdStr);
            Assert.fail((String)"enemy can access job");
        }
        catch (WebApplicationException e) {
            Assert.assertEquals((Object)Response.Status.UNAUTHORIZED, (Object)Response.Status.fromStatusCode((int)e.getResponse().getStatus()));
        }
        Mockito.when((Object)hsr.getRemoteUser()).thenReturn((Object)FRIENDLY_USER);
        this.hsWebServices.getJobTaskAttemptIdCounters(hsr, this.jobIdStr, this.taskIdStr, this.taskAttemptIdStr);
    }

    private static HistoryContext buildHistoryContext(Configuration conf) throws IOException {
        MockHistoryContext ctx = new MockHistoryContext(1, 1, 1);
        Map jobs = ctx.getAllJobs();
        JobId jobId = (JobId)jobs.keySet().iterator().next();
        MockJobForAcls mockJob = new MockJobForAcls((Job)jobs.get(jobId), conf);
        jobs.put(jobId, mockJob);
        return ctx;
    }

    static /* synthetic */ String access$000() {
        return FRIENDLY_USER;
    }
}

