/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.hs;

import java.util.TreeMap;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.jobhistory.JobHistoryParser;
import org.apache.hadoop.mapreduce.v2.api.records.Phase;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTask;
import org.apache.hadoop.mapreduce.v2.hs.CompletedTaskAttempt;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestCompletedTask {
    @Test(timeout=5000L)
    public void testTaskStartTimes() {
        TaskId taskId = (TaskId)Mockito.mock(TaskId.class);
        JobHistoryParser.TaskInfo taskInfo = (JobHistoryParser.TaskInfo)Mockito.mock(JobHistoryParser.TaskInfo.class);
        TreeMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo> taskAttempts = new TreeMap<TaskAttemptID, JobHistoryParser.TaskAttemptInfo>();
        TaskAttemptID id = new TaskAttemptID("0", 0, TaskType.MAP, 0, 0);
        JobHistoryParser.TaskAttemptInfo info = (JobHistoryParser.TaskAttemptInfo)Mockito.mock(JobHistoryParser.TaskAttemptInfo.class);
        Mockito.when((Object)info.getAttemptId()).thenReturn((Object)id);
        Mockito.when((Object)info.getStartTime()).thenReturn((Object)10L);
        taskAttempts.put(id, info);
        id = new TaskAttemptID("1", 0, TaskType.MAP, 1, 1);
        info = (JobHistoryParser.TaskAttemptInfo)Mockito.mock(JobHistoryParser.TaskAttemptInfo.class);
        Mockito.when((Object)info.getAttemptId()).thenReturn((Object)id);
        Mockito.when((Object)info.getStartTime()).thenReturn((Object)20L);
        taskAttempts.put(id, info);
        Mockito.when((Object)taskInfo.getAllTaskAttempts()).thenReturn(taskAttempts);
        CompletedTask task = new CompletedTask(taskId, taskInfo);
        TaskReport report = task.getReport();
        Assert.assertTrue((report.getStartTime() == 10L ? 1 : 0) != 0);
    }

    @Test(timeout=5000L)
    public void testCompletedTaskAttempt() {
        JobHistoryParser.TaskAttemptInfo attemptInfo = (JobHistoryParser.TaskAttemptInfo)Mockito.mock(JobHistoryParser.TaskAttemptInfo.class);
        Mockito.when((Object)attemptInfo.getRackname()).thenReturn((Object)"Rackname");
        Mockito.when((Object)attemptInfo.getShuffleFinishTime()).thenReturn((Object)11L);
        Mockito.when((Object)attemptInfo.getSortFinishTime()).thenReturn((Object)12L);
        Mockito.when((Object)attemptInfo.getShufflePort()).thenReturn((Object)10);
        JobID jobId = new JobID("12345", 0);
        TaskID taskId = new TaskID(jobId, TaskType.REDUCE, 0);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
        Mockito.when((Object)attemptInfo.getAttemptId()).thenReturn((Object)taskAttemptId);
        CompletedTaskAttempt taskAttemt = new CompletedTaskAttempt(null, attemptInfo);
        Assert.assertEquals((Object)"Rackname", (Object)taskAttemt.getNodeRackName());
        Assert.assertEquals((Object)Phase.CLEANUP, (Object)taskAttemt.getPhase());
        Assert.assertTrue((boolean)taskAttemt.isFinished());
        Assert.assertEquals((long)11L, (long)taskAttemt.getShuffleFinishTime());
        Assert.assertEquals((long)12L, (long)taskAttemt.getSortFinishTime());
        Assert.assertEquals((long)10L, (long)taskAttemt.getShufflePort());
    }
}

