/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.HasRawComparablePrefix;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.MapRFsOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.SpillRecord;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

public class MapRFsOutputBuffer<K, V>
implements MapOutputCollector<K, V>,
IndexedSortable {
    private static final Log LOG = LogFactory.getLog(MapRFsOutputBuffer.class);
    private int partitions;
    private JobConf job;
    private Task.TaskReporter reporter;
    private Class<K> keyClass;
    private Class<V> valClass;
    private RawComparator<K> comparator;
    private SerializationFactory serializationFactory;
    private Serializer<K> keySerializer;
    private Serializer<V> valSerializer;
    private Task.CombinerRunner<K, V> combinerRunner;
    private Task.CombineOutputCollector<K, V> combineCollector;
    private CompressionCodec codec;
    private IntBuffer kvmeta;
    volatile int kvstart = 0;
    volatile int kvend = 0;
    int kvindex = 0;
    int equator;
    volatile int bufstart = 0;
    volatile int bufend = 0;
    int bufmark = 0;
    int bufindex = 0;
    volatile int bufvoid = 0;
    byte[] kvbuffer;
    private final byte[] b0 = new byte[0];
    private static final int VALSTART = 0;
    private static final int KEYSTART = 1;
    private static final int PARTITION = 2;
    private static final int VALLEN = 3;
    private static final int NMETA = 4;
    private static final int METASIZE = 16;
    private int maxRec;
    private int softLimit;
    private int softRecordLimit;
    boolean spillInProgress;
    int bufferRemaining;
    volatile Throwable sortSpillException = null;
    volatile int numSpills = 0;
    private int minSpillsForCombine;
    private IndexedSorter sorter;
    final ReentrantLock spillLock = new ReentrantLock();
    final Condition spillDone = this.spillLock.newCondition();
    final Condition spillReady = this.spillLock.newCondition();
    final BlockingBuffer bb = new BlockingBuffer();
    volatile boolean spillThreadRunning = false;
    final MapRSpillThread spillThread = new MapRSpillThread();
    private FileSystem rfs;
    private Counters.Counter mapOutputByteCounter;
    private Counters.Counter mapOutputRecordCounter;
    private Counters.Counter fileOutputByteCounter;
    final ArrayList<SpillRecord> indexCacheList = new ArrayList();
    private int totalIndexCacheMemory;
    private int indexCacheMemoryLimit;
    private static final int INDEX_CACHE_MEMORY_LIMIT_DEFAULT = 0x100000;
    private MapTask mapTask;
    private MapRFsOutputFile mapOutputFile;
    private Progress sortPhase;
    private Counters.Counter spilledRecordsCounter;
    private static final int INT_BYTES = 4;
    private static final int MIN_KEYPREFIX_INTS = 1;
    private static final int MAX_KEYPREFIX_INTS = 4;
    private static final int KEYPREFIX = 0;
    private ExecutorService threadPool;
    private long outputSize = 0L;
    private int kvoffsetTotal;
    private KvOffset[] kvoffsets;
    private KvOffset[] oldKvoffsets = null;
    private int[] kvindices;
    private int currentThreadsNumber;
    private int closerThreadsNumber;
    private int keyPrefixLen;
    private int keyStart;
    private int valStart;
    private int acctSize;
    private int recSize;
    private byte[] prefixdata;
    private TaskAttemptID mapId;
    final byte[] META_BUFFER_TMP = new byte[16];

    private void initFS(TaskAttemptID mapId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initializing MapRFsOutputBuffer");
        }
        this.rfs = FileSystem.get((Configuration)this.job);
        this.mapId = mapId;
        this.currentThreadsNumber = this.job.getInt("mapred.maxthreads.generate.mapoutput", -1);
        if (this.threadPool == null) {
            this.threadPool = new ThreadPoolExecutor(0, this.currentThreadsNumber, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        this.closerThreadsNumber = this.job.getInt("mapred.maxthreads.partition.closer", -1);
        int tmpKeyPrefixInts = this.job.getInt("mapr.map.keyprefix.ints", 1);
        if (tmpKeyPrefixInts > 4 || tmpKeyPrefixInts < 1) {
            throw new IOException(tmpKeyPrefixInts + ": key prefix ints must be in " + "[" + 1 + ", " + 4 + "]");
        }
        this.keyPrefixLen = tmpKeyPrefixInts * 4;
        this.prefixdata = new byte[this.keyPrefixLen];
        this.keyStart = 0 + tmpKeyPrefixInts;
        this.valStart = this.keyStart + 1;
        this.acctSize = this.valStart + 1;
        this.recSize = (this.acctSize + 1) * 4;
    }

    public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing: " + this.getClass().getName()));
        }
        this.job = context.getJobConf();
        this.reporter = context.getReporter();
        this.mapTask = context.getMapTask();
        this.mapTask.setReportOutputSize(false);
        this.mapOutputFile = (MapRFsOutputFile)((Object)ReflectionUtils.newInstance(MapRFsOutputFile.class, (Configuration)this.job));
        this.mapOutputFile.setConf((Configuration)this.job);
        this.sortPhase = this.mapTask.getSortPhase();
        this.spilledRecordsCounter = this.reporter.getCounter((Enum)TaskCounter.SPILLED_RECORDS);
        this.partitions = this.job.getNumReduceTasks();
        this.initFS(this.getTaskID());
        float spillper = this.job.getFloat("mapreduce.map.sort.spill.percent", 0.8f);
        float recper = this.job.getFloat("io.sort.record.percent", -1.0f);
        int sortmb = this.job.getInt("mapreduce.task.io.sort.mb", 100);
        this.indexCacheMemoryLimit = this.job.getInt("mapreduce.task.index.cache.limit.bytes", 0x100000);
        if (spillper > 1.0f || spillper <= 0.0f) {
            throw new IOException("Invalid \"mapreduce.map.sort.spill.percent\": " + spillper);
        }
        if (recper > 1.0f || recper < 0.01f) {
            throw new IOException("Invalid \"io.sort.record.percent\": " + recper);
        }
        if ((sortmb & 0x7FF) != sortmb) {
            throw new IOException("Invalid \"mapreduce.task.io.sort.mb\": " + sortmb);
        }
        this.sorter = (IndexedSorter)ReflectionUtils.newInstance((Class)this.job.getClass("map.sort.class", QuickSort.class, IndexedSorter.class), (Configuration)this.job);
        int maxMemUsage = sortmb << 20;
        int recordCapacity = (int)((float)maxMemUsage * recper);
        recordCapacity -= recordCapacity % this.recSize;
        this.kvbuffer = new byte[maxMemUsage - recordCapacity];
        this.bufvoid = this.kvbuffer.length;
        this.kvoffsetTotal = (recordCapacity /= this.recSize) - recordCapacity % this.partitions;
        this.oldKvoffsets = null;
        this.initKvOffsets();
        this.kvindices = new int[this.kvoffsetTotal * this.acctSize];
        this.kvmeta = ByteBuffer.wrap(this.kvbuffer).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.bufindex = 0;
        this.bufend = 0;
        this.bufstart = 0;
        this.kvindex = 0;
        this.kvend = 0;
        this.kvstart = 0;
        this.maxRec = this.kvmeta.capacity() / 4;
        this.bufferRemaining = this.softLimit = (int)((float)this.kvbuffer.length * spillper);
        this.softRecordLimit = (int)((float)this.kvoffsetTotal * spillper);
        LOG.info((Object)("mapreduce.task.io.sort.mb: " + sortmb));
        LOG.info((Object)("soft limit at " + this.softLimit));
        LOG.info((Object)("bufstart = " + this.bufstart + "; bufvoid = " + this.bufvoid));
        LOG.info((Object)("kvstart = " + this.kvstart + "; length = " + this.maxRec));
        this.comparator = this.job.getOutputKeyComparator();
        this.keyClass = this.job.getMapOutputKeyClass();
        this.valClass = this.job.getMapOutputValueClass();
        this.serializationFactory = new SerializationFactory((Configuration)this.job);
        this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
        this.keySerializer.open((OutputStream)this.bb);
        this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
        this.valSerializer.open((OutputStream)this.bb);
        this.mapOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES);
        this.mapOutputRecordCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.fileOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES);
        if (this.job.getCompressMapOutput()) {
            Class codecClass = this.job.getMapOutputCompressorClass(DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)this.job);
        } else {
            this.codec = null;
        }
        Counters.Counter combineInputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        this.combinerRunner = Task.CombinerRunner.create((JobConf)this.job, (TaskAttemptID)this.getTaskID(), (Counters.Counter)combineInputCounter, (Task.TaskReporter)this.reporter, null);
        if (this.combinerRunner != null) {
            Counters.Counter combineOutputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS);
            this.combineCollector = new Task.CombineOutputCollector(combineOutputCounter, (Progressable)this.reporter, (Configuration)this.job);
        } else {
            this.combineCollector = null;
        }
        this.spillInProgress = false;
        this.minSpillsForCombine = this.job.getInt("mapreduce.map.combine.minspills", 3);
        this.spillThread.setDaemon(true);
        this.spillThread.setName("MapRSpillThread");
        this.spillLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Starting spill thread");
            }
            this.spillThread.start();
            while (!this.spillThreadRunning) {
                this.spillDone.await();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Spill thread failed to initialize", e);
        }
        finally {
            this.spillLock.unlock();
        }
        if (this.sortSpillException != null) {
            throw new IOException("Spill thread failed to initialize", this.sortSpillException);
        }
    }

    private int getIntPrefix(int keyInt, int offset) {
        this.kvindices[keyInt] = (this.prefixdata[offset++] & 0xFF) << 24 | (this.prefixdata[offset++] & 0xFF) << 16 | (this.prefixdata[offset++] & 0xFF) << 8 | this.prefixdata[offset++] & 0xFF;
        return offset;
    }

    private void saveKvOffsets(boolean flush) {
        if (flush) {
            this.freeKvOffsets(this.oldKvoffsets);
            this.oldKvoffsets = null;
            this.oldKvoffsets = this.kvoffsets;
        } else if (this.oldKvoffsets == null) {
            this.oldKvoffsets = this.kvoffsets;
            this.initKvOffsets();
        } else {
            KvOffset[] tmp = this.kvoffsets;
            this.kvoffsets = this.oldKvoffsets;
            this.oldKvoffsets = tmp;
        }
    }

    private void freeKvOffsets(KvOffset[] ko) {
        if (ko != null) {
            for (int i = 0; i < this.partitions; ++i) {
                ko[i] = null;
            }
            ko = null;
        }
    }

    private void initKvOffsets() {
        this.kvoffsets = new KvOffset[this.partitions];
        for (int i = 0; i < this.partitions; ++i) {
            this.kvoffsets[i] = new KvOffset(this.kvoffsetTotal / (4 * this.partitions), this.kvoffsetTotal);
        }
    }

    private TaskAttemptID getTaskID() {
        return this.mapTask.getTaskID();
    }

    private void setEquator(int pos) {
        this.equator = pos;
        int aligned = pos - pos % 16;
        this.kvindex = (aligned - 16 + this.kvbuffer.length) % this.kvbuffer.length / 4;
        LOG.info((Object)("(EQUATOR) " + pos + " kvi " + this.kvindex + "(" + this.kvindex * 4 + ")"));
    }

    private void resetSpill() {
        int e;
        this.bufstart = this.bufend = (e = this.equator);
        int aligned = e - e % 16;
        this.kvstart = this.kvend = (aligned - 16 + this.kvbuffer.length) % this.kvbuffer.length / 4;
        LOG.info((Object)("(RESET) equator " + e + " kv " + this.kvstart + "(" + this.kvstart * 4 + ")" + " kvi " + this.kvindex + "(" + this.kvindex * 4 + ")"));
    }

    final int distanceTo(int i, int j) {
        return this.distanceTo(i, j, this.kvbuffer.length);
    }

    int distanceTo(int i, int j, int mod) {
        return i <= j ? j - i : mod - i + j;
    }

    int offsetFor(int metapos) {
        return metapos * 4;
    }

    public int compare(int mi, int mj) {
        int kvjp;
        int kvi = this.offsetFor(mi % this.maxRec);
        int kvj = this.offsetFor(mj % this.maxRec);
        int kvip = this.kvmeta.get(kvi + 2);
        if (kvip != (kvjp = this.kvmeta.get(kvj + 2))) {
            return kvip - kvjp;
        }
        return this.comparator.compare(this.kvbuffer, this.kvmeta.get(kvi + 1), this.kvmeta.get(kvi + 0) - this.kvmeta.get(kvi + 1), this.kvbuffer, this.kvmeta.get(kvj + 1), this.kvmeta.get(kvj + 0) - this.kvmeta.get(kvj + 1));
    }

    public void swap(int mi, int mj) {
        int iOff = mi % this.maxRec * 16;
        int jOff = mj % this.maxRec * 16;
        System.arraycopy(this.kvbuffer, iOff, this.META_BUFFER_TMP, 0, 16);
        System.arraycopy(this.kvbuffer, jOff, this.kvbuffer, iOff, 16);
        System.arraycopy(this.META_BUFFER_TMP, 0, this.kvbuffer, jOff, 16);
    }

    public void close() {
    }

    private void checkSpillException() throws IOException {
        Throwable lspillException = this.sortSpillException;
        if (lspillException != null) {
            if (lspillException instanceof Error) {
                String logMsg = "Task " + this.getTaskID() + " failed : " + StringUtils.stringifyException((Throwable)lspillException);
                this.mapTask.reportFatalError(this.getTaskID(), lspillException, logMsg);
            }
            throw new IOException("Spill failed", lspillException);
        }
    }

    private synchronized void startSpill() {
        this.kvend = this.kvindex;
        this.bufend = this.bufmark;
        this.saveKvOffsets(false);
        LOG.info((Object)"startSpill: Spilling map output");
        LOG.info((Object)("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid));
        LOG.info((Object)("kvstart = " + this.kvstart + "; kvend = " + this.kvindex + "; length = " + this.kvoffsetTotal));
        this.spillReady.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillSingleRecord(K key, V value, int partition) throws IOException {
        long size = this.kvbuffer.length + this.partitions * 150;
        try (FSDataOutputStream out = null;){
            SpillRecord spillRec = new SpillRecord(this.partitions);
            Path filename = this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
            out = this.rfs.create(filename);
            IndexRecord rec = new IndexRecord();
            for (int i = 0; i < this.partitions; ++i) {
                IFile.Writer writer = null;
                try {
                    long segmentStart = out.getPos();
                    writer = new IFile.Writer((Configuration)this.job, out, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                    if (i == partition) {
                        long recordStart = out.getPos();
                        writer.append(key, value);
                        this.mapOutputByteCounter.increment(out.getPos() - recordStart);
                    }
                    writer.close();
                    rec.startOffset = segmentStart;
                    rec.rawLength = writer.getRawLength();
                    rec.partLength = writer.getCompressedLength();
                    spillRec.putIndex(rec, i);
                    writer = null;
                    continue;
                }
                catch (IOException e) {
                    if (null != writer) {
                        writer.close();
                    }
                    throw e;
                }
            }
            if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                spillRec.writeToFile(indexFilename, this.job);
            } else {
                this.indexCacheList.add(spillRec);
                this.totalIndexCacheMemory += spillRec.size() * 24;
            }
            ++this.numSpills;
        }
    }

    private void getVBytesForOffset(int kvoff, InMemValBytes vbytes) {
        int nextindex = kvoff / this.acctSize == (this.kvend - 1 + this.kvoffsetTotal) % this.kvoffsetTotal ? this.bufend : this.kvindices[(kvoff + this.acctSize + this.keyStart) % this.kvindices.length];
        int vallen = nextindex >= this.kvindices[kvoff + this.valStart] ? nextindex - this.kvindices[kvoff + this.valStart] : this.bufvoid - this.kvindices[kvoff + this.valStart] + nextindex;
        vbytes.reset(this.kvbuffer, this.kvindices[kvoff + this.valStart], vallen);
    }

    protected boolean sortAndSpillWrapper() throws IOException, ClassNotFoundException, InterruptedException {
        if (this.numSpills == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MapRFs: No spills");
            }
            this.saveKvOffsets(true);
            this.sortAndWrite();
            this.threadPool.shutdown();
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MapRFs: Number of spills: " + this.numSpills));
        }
        this.saveKvOffsets(true);
        this.sortAndSpill();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortAndSpill() throws IOException, ClassNotFoundException, InterruptedException {
        long size = (this.bufend >= this.bufstart ? this.bufend - this.bufstart : this.bufvoid - this.bufend + this.bufstart) + this.partitions * 150;
        try (FSDataOutputStream out = null;){
            SpillRecord spillRec = new SpillRecord(this.partitions);
            out = this.rfs.createFid(this.mapOutputFile.getSpillFid(), this.mapOutputFile.getSpillFileForWriteFid(TaskAttemptID.downgrade((org.apache.hadoop.mapreduce.TaskAttemptID)this.mapId), this.numSpills, size));
            IndexRecord rec = new IndexRecord();
            InMemValBytes value = new InMemValBytes();
            byte[] threadLocalPrefix = new byte[2 * this.keyPrefixLen];
            for (int i = 0; i < this.partitions; ++i) {
                KvOffset kvo = this.oldKvoffsets[i];
                kvo.prefixkey = threadLocalPrefix;
                IFile.Writer writer = null;
                try {
                    long segmentStart = out.getPos();
                    writer = new IFile.Writer((Configuration)this.job, out, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                    if (kvo.size() > 0) {
                        this.sorter.sort((IndexedSortable)kvo, 0, kvo.size(), (Progressable)this.reporter);
                        if (this.combinerRunner == null) {
                            DataInputBuffer key = new DataInputBuffer();
                            int j = 0;
                            while (j < kvo.size()) {
                                int kvoff = kvo.get(j++) * this.acctSize;
                                this.getVBytesForOffset(kvoff, value);
                                key.reset(this.kvbuffer, this.kvindices[kvoff + this.keyStart], this.kvindices[kvoff + this.valStart] - this.kvindices[kvoff + this.keyStart]);
                                writer.append(key, (DataInputBuffer)value);
                            }
                        } else if (kvo.size() > 0) {
                            this.combineCollector.setWriter(writer);
                            MapRResultIterator kvIter = new MapRResultIterator(kvo);
                            this.combinerRunner.combine((RawKeyValueIterator)kvIter, this.combineCollector);
                        }
                    }
                    kvo.reset();
                    writer.close();
                    rec.startOffset = segmentStart;
                    rec.rawLength = writer.getRawLength();
                    rec.partLength = writer.getCompressedLength();
                    spillRec.putIndex(rec, i);
                    writer = null;
                    continue;
                }
                finally {
                    if (null != writer) {
                        writer.close();
                    }
                }
            }
            if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, this.partitions * 24);
                spillRec.writeToFile(indexFilename, this.job, null, this.rfs);
            } else {
                this.indexCacheList.add(spillRec);
                this.totalIndexCacheMemory += spillRec.size() * 24;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("sortAndSpill: Finished spill " + this.numSpills + ", kvstart = " + this.kvstart + ", kvend = " + this.kvend));
            }
            ++this.numSpills;
        }
    }

    private void sortAndWrite() throws IOException, ClassNotFoundException, InterruptedException {
        final Random random = new Random();
        final ArrayList<CloserThread> closerList = new ArrayList<CloserThread>(this.closerThreadsNumber);
        for (int i = 0; i < this.closerThreadsNumber; ++i) {
            CloserThread closerThread = new CloserThread();
            closerThread.setDaemon(true);
            closerList.add(closerThread);
            closerThread.start();
        }
        ArrayList<1> calls = new ArrayList<1>();
        final int threadsNumber = this.currentThreadsNumber;
        final int maxLoop = this.partitions / threadsNumber;
        int k = 0;
        while (k < threadsNumber) {
            final int someOff = k++;
            final byte[] threadLocalPrefix = new byte[2 * this.keyPrefixLen];
            Callable<Integer> call = new Callable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer call() throws Exception {
                    InMemValBytes value = new InMemValBytes();
                    int endValue = maxLoop * (someOff + 1);
                    if (someOff == threadsNumber - 1) {
                        endValue = MapRFsOutputBuffer.this.partitions;
                    }
                    for (int i = maxLoop * someOff; i < endValue; ++i) {
                        FSDataOutputStream finalOut = MapRFsOutputBuffer.this.rfs.createFid(MapRFsOutputBuffer.this.mapOutputFile.getOutputFid(), MapRFsOutputBuffer.this.mapOutputFile.getOutputFileForWriteFid(MapRFsOutputBuffer.this.mapId, -1L, i));
                        IFile.Writer writer = null;
                        try {
                            writer = new IFile.Writer((Configuration)MapRFsOutputBuffer.this.job, finalOut, MapRFsOutputBuffer.this.keyClass, MapRFsOutputBuffer.this.valClass, MapRFsOutputBuffer.this.codec, MapRFsOutputBuffer.this.spilledRecordsCounter);
                            KvOffset kvo = MapRFsOutputBuffer.this.oldKvoffsets[i];
                            kvo.prefixkey = threadLocalPrefix;
                            if (kvo.size() > 0) {
                                MapRFsOutputBuffer.this.sorter.sort((IndexedSortable)kvo, 0, kvo.size(), (Progressable)MapRFsOutputBuffer.this.reporter);
                                if (MapRFsOutputBuffer.this.combinerRunner == null) {
                                    DataInputBuffer key = new DataInputBuffer();
                                    int j = 0;
                                    while (j < kvo.size()) {
                                        int kvoff = kvo.get(j++) * MapRFsOutputBuffer.this.acctSize;
                                        MapRFsOutputBuffer.this.getVBytesForOffset(kvoff, value);
                                        key.reset(MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.keyStart], MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.valStart] - MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.keyStart]);
                                        writer.append(key, (DataInputBuffer)value);
                                    }
                                } else if (kvo.size() > 0) {
                                    MapRFsOutputBuffer.this.combineCollector.setWriter(writer);
                                    MapRResultIterator kvIter = new MapRResultIterator(kvo);
                                    MapRFsOutputBuffer.this.combinerRunner.combine((RawKeyValueIterator)kvIter, (OutputCollector)MapRFsOutputBuffer.this.combineCollector);
                                }
                            }
                            kvo.reset();
                            writer.close();
                            MapRFsOutputBuffer.this.outputSize += writer.getRawLength();
                            writer = null;
                        }
                        finally {
                            if (null != writer) {
                                writer.close();
                            }
                        }
                        int threadNumber = random.nextInt(MapRFsOutputBuffer.this.closerThreadsNumber);
                        ((CloserThread)closerList.get(threadNumber)).add(finalOut);
                    }
                    return 0;
                }
            };
            calls.add(call);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Before threading");
            }
            List futures = this.threadPool.invokeAll(calls);
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException exp) {
                    LOG.error((Object)"Exception while processing sortAndWrite", (Throwable)exp);
                    throw new IOException(exp);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After threading");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while trying to write map outputs", (Throwable)e);
            throw new IOException(e);
        }
        finally {
            int i;
            for (i = 0; i < closerList.size(); ++i) {
                ((CloserThread)closerList.get(i)).signalShutdown();
            }
            for (i = 0; i < closerList.size(); ++i) {
                ((CloserThread)closerList.get(i)).awaitTermination();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"End of sortandWrite");
            }
        }
    }

    protected void mergeParts() throws IOException, InterruptedException, ClassNotFoundException {
        int i;
        LOG.info((Object)"mergeParts: Merging partitions");
        this.freeKvOffsets(this.kvoffsets);
        this.freeKvOffsets(this.oldKvoffsets);
        this.oldKvoffsets = null;
        this.kvoffsets = null;
        Path[] filename = new Path[this.numSpills];
        CloserThread closerThread = new CloserThread();
        closerThread.setDaemon(true);
        closerThread.start();
        for (i = 0; i < this.numSpills; ++i) {
            filename[i] = this.mapOutputFile.getSpillFile(i);
        }
        for (i = this.indexCacheList.size(); i < this.numSpills; ++i) {
            Path indexFileName = this.mapOutputFile.getSpillIndexFile(i);
            this.indexCacheList.add(new SpillRecord(indexFileName, this.job, null, UserGroupInformation.getCurrentUser().getShortUserName(), this.rfs));
        }
        this.sortPhase.addPhases(this.partitions);
        for (int parts = 0; parts < this.partitions; ++parts) {
            FSDataOutputStream finalOut = this.rfs.createFid(this.mapOutputFile.getOutputFid(), this.mapOutputFile.getOutputFileForWriteFid(TaskAttemptID.downgrade((org.apache.hadoop.mapreduce.TaskAttemptID)this.mapId), -1L, parts));
            ArrayList<Merger.Segment> segmentList = new ArrayList<Merger.Segment>(this.numSpills);
            for (int i2 = 0; i2 < this.numSpills; ++i2) {
                IndexRecord indexRecord = this.indexCacheList.get(i2).getIndex(parts);
                Merger.Segment s = new Merger.Segment((Configuration)this.job, this.rfs, filename[i2], indexRecord.startOffset, indexRecord.partLength, this.codec, true);
                segmentList.add(i2, s);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("MapId=" + this.mapId + " Reducer=" + parts + "Spill =" + i2 + "(" + indexRecord.startOffset + "," + indexRecord.rawLength + ", " + indexRecord.partLength + ")"));
            }
            Path tmpDir = this.mapOutputFile.getLocalPathForWrite(this.mapId.toString(), -1L);
            RawKeyValueIterator kvIter = Merger.merge((Configuration)this.job, (FileSystem)this.rfs, this.keyClass, this.valClass, (CompressionCodec)this.codec, segmentList, (int)Math.max(2, this.job.getInt("io.sort.factor", -1)), (Path)tmpDir, (RawComparator)this.job.getOutputKeyComparator(), (Progressable)this.reporter, (boolean)false, null, (Counters.Counter)this.spilledRecordsCounter, (Progress)this.sortPhase.phase(), (TaskType)TaskType.MAP);
            IFile.Writer writer = new IFile.Writer((Configuration)this.job, finalOut, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
            if (this.combinerRunner == null || this.numSpills < this.minSpillsForCombine) {
                Merger.writeFile((RawKeyValueIterator)kvIter, (IFile.Writer)writer, (Progressable)this.reporter, (Configuration)this.job);
            } else {
                this.combineCollector.setWriter(writer);
                this.combinerRunner.combine(kvIter, this.combineCollector);
            }
            writer.close();
            this.sortPhase.startNextPhase();
            this.outputSize += writer.getRawLength();
            writer = null;
            closerThread.add(finalOut);
            finalOut = null;
        }
        closerThread.signalShutdown();
        for (i = 0; i < this.numSpills; ++i) {
            this.rfs.delete(filename[i], true);
        }
        closerThread.awaitTermination();
    }

    private void checkKeyValuePartition(K key, V value, int partition) throws IOException {
        if (key.getClass() != this.keyClass) {
            throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
        }
        if (value.getClass() != this.valClass) {
            throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", received " + value.getClass().getName());
        }
        if (partition < 0 || partition >= this.partitions) {
            throw new IOException("Illegal partition for " + key + " (" + partition + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collect(K key, V value, int partition) throws IOException {
        this.reporter.progress();
        this.checkKeyValuePartition(key, value, partition);
        int kvnext = (this.kvindex + 1) % this.kvoffsetTotal;
        this.spillLock.lock();
        try {
            boolean kvfull;
            do {
                boolean kvsoftlimit;
                if (this.sortSpillException != null) {
                    throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
                }
                boolean bl = kvfull = kvnext == this.kvstart;
                boolean bl2 = kvnext > this.kvend ? kvnext - this.kvend > this.softRecordLimit : (kvsoftlimit = this.kvend - kvnext <= this.kvoffsetTotal - this.softRecordLimit);
                if (this.kvstart == this.kvend && kvsoftlimit) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("collect: Spilling map output: record full = " + kvsoftlimit));
                    }
                    this.startSpill();
                }
                if (!kvfull) continue;
                try {
                    while (this.kvstart != this.kvend) {
                        this.reporter.progress();
                        this.spillDone.await();
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Waiting for spillDone interrupted.", (Throwable)e);
                    }
                    throw (IOException)new IOException("Collector interrupted while waiting for the writer").initCause(e);
                }
            } while (kvfull);
        }
        finally {
            this.spillLock.unlock();
        }
        try {
            int keystart = this.bufindex;
            this.keySerializer.serialize(key);
            if (this.bufindex < keystart) {
                this.bb.shiftBufferedKey();
                keystart = 0;
            }
            int valstart = this.bufindex;
            this.valSerializer.serialize(value);
            int valend = this.bb.markRecord();
            this.mapOutputRecordCounter.increment(1L);
            this.mapOutputByteCounter.increment(valend >= keystart ? (long)(valend - keystart) : (long)(this.bufvoid - keystart + valend));
            int ind = this.kvindex * this.acctSize;
            this.kvoffsets[partition].add(this.kvindex);
            int first = ind + 0;
            int last = first + this.keyPrefixLen / 4;
            if (key instanceof HasRawComparablePrefix) {
                HasRawComparablePrefix hrcpKey = (HasRawComparablePrefix)key;
                hrcpKey.getPrefix(this.prefixdata, 0, this.keyPrefixLen);
                int p = 0;
                for (int keyInt = first; keyInt < last; ++keyInt) {
                    p = this.getIntPrefix(keyInt, p);
                }
            } else {
                for (int keyInt = first; keyInt < last; ++keyInt) {
                    this.kvindices[keyInt] = 0;
                }
            }
            this.kvindices[ind + this.keyStart] = keystart;
            this.kvindices[ind + this.valStart] = valstart;
            this.kvindex = kvnext;
        }
        catch (MapTask.MapBufferTooSmallException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Record too large for in-memory buffer", (Throwable)e);
            }
            this.spillSingleRecord(key, value, partition);
            this.mapOutputRecordCounter.increment(1L);
            return;
        }
    }

    public synchronized void flush() throws IOException, ClassNotFoundException, InterruptedException {
        if (!this.spillThreadRunning) {
            return;
        }
        LOG.info((Object)("flush: Starting flush of map output, kvstart = " + this.kvstart + ", kvend = " + this.kvend));
        boolean done = false;
        this.spillLock.lock();
        try {
            while (this.kvstart != this.kvend) {
                this.reporter.progress();
                this.spillDone.await();
            }
            this.checkSpillException();
            if (this.kvindex != this.kvend) {
                this.kvend = this.kvindex;
                this.bufend = this.bufmark;
                LOG.info((Object)"flush: Spilling map output");
                LOG.info((Object)("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid));
                LOG.info((Object)("kvstart = " + this.kvstart + "(" + this.kvstart * 4 + "); kvend = " + this.kvend + "(" + this.kvend * 4 + "); length = " + (this.distanceTo(this.kvend, this.kvstart, this.kvmeta.capacity()) + 1) + "/" + this.maxRec));
                done = this.sortAndSpillWrapper();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for the writer", e);
        }
        finally {
            this.spillLock.unlock();
            this.spillThread.shutdown();
        }
        assert (!this.spillLock.isHeldByCurrentThread());
        this.kvbuffer = null;
        this.freeKvOffsets(this.kvoffsets);
        this.freeKvOffsets(this.oldKvoffsets);
        this.oldKvoffsets = null;
        this.kvoffsets = null;
        if (!done) {
            this.mergeParts();
        }
    }

    static /* synthetic */ TaskAttemptID access$1200(MapRFsOutputBuffer x0) {
        return x0.getTaskID();
    }

    static /* synthetic */ MapTask access$1300(MapRFsOutputBuffer x0) {
        return x0.mapTask;
    }

    private final class MapRSpillThread
    extends Thread {
        private boolean shouldShutdown;

        private MapRSpillThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block16: {
                MapRFsOutputBuffer.this.spillLock.lock();
                MapRFsOutputBuffer.this.spillThreadRunning = true;
                while (true) lbl-1000:
                // 5 sources

                {
                    MapRFsOutputBuffer.this.spillDone.signal();
                    while (MapRFsOutputBuffer.this.kvstart == MapRFsOutputBuffer.this.kvend) {
                        try {
                            MapRFsOutputBuffer.this.spillReady.await();
                        }
                        catch (InterruptedException e) {
                            if (MapRFsOutputBuffer.access$800().isDebugEnabled()) {
                                MapRFsOutputBuffer.access$800().debug((Object)("Interrupted for shutdown? " + this.shouldShutdown), (Throwable)e);
                            }
                            if (!this.shouldShutdown) continue;
                            break block16;
                        }
                    }
                    try {
                        MapRFsOutputBuffer.this.spillLock.unlock();
                        MapRFsOutputBuffer.this.sortAndSpill();
                    }
                    catch (Exception e) {
                        MapRFsOutputBuffer.this.sortSpillException = e;
                    }
                    catch (Throwable t) {
                        MapRFsOutputBuffer.this.sortSpillException = t;
                        logMsg = "Task " + MapRFsOutputBuffer.access$1200(MapRFsOutputBuffer.this) + " failed : " + StringUtils.stringifyException((Throwable)t);
                        MapRFsOutputBuffer.access$1300(MapRFsOutputBuffer.this).reportFatalError(MapRFsOutputBuffer.access$1200(MapRFsOutputBuffer.this), t, logMsg);
                    }
                    finally {
                        MapRFsOutputBuffer.this.spillLock.lock();
                        if (MapRFsOutputBuffer.this.bufend < MapRFsOutputBuffer.this.bufindex && MapRFsOutputBuffer.this.bufindex < MapRFsOutputBuffer.this.bufstart) {
                            MapRFsOutputBuffer.this.bufvoid = MapRFsOutputBuffer.this.kvbuffer.length;
                        }
                        MapRFsOutputBuffer.this.kvstart = MapRFsOutputBuffer.this.kvend;
                        MapRFsOutputBuffer.this.bufstart = MapRFsOutputBuffer.this.bufend;
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    MapRFsOutputBuffer.this.spillLock.unlock();
                    MapRFsOutputBuffer.this.spillThreadRunning = false;
                }
            }
        }

        private void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Shutting down spill thread: " + this));
            }
            this.shouldShutdown = true;
            this.interrupt();
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("Interrupted joining thread: " + this));
                }
            }
        }
    }

    public class Buffer
    extends OutputStream {
        private final byte[] scratch = new byte[1];

        @Override
        public synchronized void write(int v) throws IOException {
            this.scratch[0] = (byte)v;
            this.write(this.scratch, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            boolean buffull = false;
            boolean wrap = false;
            MapRFsOutputBuffer.this.spillLock.lock();
            try {
                do {
                    if (MapRFsOutputBuffer.this.sortSpillException != null) {
                        throw (IOException)new IOException("Spill failed").initCause(MapRFsOutputBuffer.this.sortSpillException);
                    }
                    if (MapRFsOutputBuffer.this.bufstart <= MapRFsOutputBuffer.this.bufend && MapRFsOutputBuffer.this.bufend <= MapRFsOutputBuffer.this.bufindex) {
                        buffull = MapRFsOutputBuffer.this.bufindex + len > MapRFsOutputBuffer.this.bufvoid;
                        wrap = MapRFsOutputBuffer.this.bufvoid - MapRFsOutputBuffer.this.bufindex + MapRFsOutputBuffer.this.bufstart > len;
                    } else {
                        wrap = false;
                        boolean bl = buffull = MapRFsOutputBuffer.this.bufindex + len > MapRFsOutputBuffer.this.bufstart;
                    }
                    if (MapRFsOutputBuffer.this.kvstart == MapRFsOutputBuffer.this.kvend) {
                        if (MapRFsOutputBuffer.this.kvend != MapRFsOutputBuffer.this.kvindex) {
                            boolean bufsoftlimit;
                            boolean bl = MapRFsOutputBuffer.this.bufindex > MapRFsOutputBuffer.this.bufend ? MapRFsOutputBuffer.this.bufindex - MapRFsOutputBuffer.this.bufend > MapRFsOutputBuffer.this.softLimit : (bufsoftlimit = MapRFsOutputBuffer.this.bufend - MapRFsOutputBuffer.this.bufindex < MapRFsOutputBuffer.this.bufvoid - MapRFsOutputBuffer.this.softLimit);
                            if (bufsoftlimit || buffull && !wrap) {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info((Object)("write: Spilling map output: buffer full = " + bufsoftlimit));
                                }
                                MapRFsOutputBuffer.this.startSpill();
                            }
                        } else if (buffull && !wrap) {
                            int size = (MapRFsOutputBuffer.this.bufend <= MapRFsOutputBuffer.this.bufindex ? MapRFsOutputBuffer.this.bufindex - MapRFsOutputBuffer.this.bufend : MapRFsOutputBuffer.this.bufvoid - MapRFsOutputBuffer.this.bufend + MapRFsOutputBuffer.this.bufindex) + len;
                            MapRFsOutputBuffer.this.bufmark = 0;
                            MapRFsOutputBuffer.this.bufindex = 0;
                            MapRFsOutputBuffer.this.bufend = 0;
                            MapRFsOutputBuffer.this.bufstart = 0;
                            MapRFsOutputBuffer.this.kvindex = 0;
                            MapRFsOutputBuffer.this.kvend = 0;
                            MapRFsOutputBuffer.this.kvstart = 0;
                            MapRFsOutputBuffer.this.bufvoid = MapRFsOutputBuffer.this.kvbuffer.length;
                            throw new MapTask.MapBufferTooSmallException(size + " bytes");
                        }
                    }
                    if (!buffull || wrap) continue;
                    try {
                        while (MapRFsOutputBuffer.this.kvstart != MapRFsOutputBuffer.this.kvend) {
                            MapRFsOutputBuffer.this.reporter.progress();
                            MapRFsOutputBuffer.this.spillDone.await();
                        }
                    }
                    catch (InterruptedException e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Waiting for spillDone interrupted.", (Throwable)e);
                        }
                        throw (IOException)new IOException("Buffer interrupted while waiting for the writer").initCause(e);
                    }
                } while (buffull && !wrap);
            }
            finally {
                MapRFsOutputBuffer.this.spillLock.unlock();
            }
            if (buffull) {
                int gaplen = MapRFsOutputBuffer.this.bufvoid - MapRFsOutputBuffer.this.bufindex;
                System.arraycopy(b, off, MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.bufindex, gaplen);
                len -= gaplen;
                off += gaplen;
                MapRFsOutputBuffer.this.bufindex = 0;
            }
            System.arraycopy(b, off, MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.bufindex, len);
            MapRFsOutputBuffer.this.bufindex += len;
        }
    }

    protected class BlockingBuffer
    extends DataOutputStream {
        public BlockingBuffer() {
            super(new Buffer());
        }

        public int markRecord() {
            MapRFsOutputBuffer.this.bufmark = MapRFsOutputBuffer.this.bufindex;
            return MapRFsOutputBuffer.this.bufindex;
        }

        protected synchronized void shiftBufferedKey() throws IOException {
            int headbytelen = MapRFsOutputBuffer.this.bufvoid - MapRFsOutputBuffer.this.bufmark;
            MapRFsOutputBuffer.this.bufvoid = MapRFsOutputBuffer.this.bufmark;
            if (MapRFsOutputBuffer.this.bufindex + headbytelen < MapRFsOutputBuffer.this.bufstart) {
                System.arraycopy(MapRFsOutputBuffer.this.kvbuffer, 0, MapRFsOutputBuffer.this.kvbuffer, headbytelen, MapRFsOutputBuffer.this.bufindex);
                System.arraycopy(MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.bufvoid, MapRFsOutputBuffer.this.kvbuffer, 0, headbytelen);
                MapRFsOutputBuffer.this.bufindex += headbytelen;
                MapRFsOutputBuffer.this.bufferRemaining -= MapRFsOutputBuffer.this.kvbuffer.length - MapRFsOutputBuffer.this.bufvoid;
            } else {
                byte[] keytmp = new byte[MapRFsOutputBuffer.this.bufindex];
                System.arraycopy(MapRFsOutputBuffer.this.kvbuffer, 0, keytmp, 0, MapRFsOutputBuffer.this.bufindex);
                MapRFsOutputBuffer.this.bufindex = 0;
                this.out.write(MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.bufmark, headbytelen);
                this.out.write(keytmp);
            }
        }
    }

    private final class CloserThread
    extends Thread {
        private final FSDataOutputStream[] fsobjs = new FSDataOutputStream[100];
        private int h;
        private int t;
        private Throwable closerException;

        private CloserThread() {
        }

        private synchronized void add(FSDataOutputStream os) {
            while ((this.h + 1) % this.fsobjs.length == this.t) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Spurious wakeup?", (Throwable)e);
                }
            }
            this.fsobjs[this.h] = os;
            if (++this.h >= this.fsobjs.length) {
                this.h = 0;
            }
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSDataOutputStream os = null;
            try {
                while (true) {
                    CloserThread closerThread = this;
                    synchronized (closerThread) {
                        while (this.h == this.t) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)"Spurious wakeup?", (Throwable)e);
                            }
                        }
                        os = this.fsobjs[this.t];
                        if (++this.t >= this.fsobjs.length) {
                            this.t = 0;
                        }
                        this.notify();
                    }
                    if (os == null) {
                        return;
                    }
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)("Failed to close: " + os), (Throwable)e);
                        }
                        if (this.closerException != null) continue;
                        this.closerException = e;
                    }
                }
            }
            catch (Throwable fatal) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)(this + "is exiting due to a fatal exception"), fatal);
                }
                if (this.closerException == null) {
                    this.closerException = fatal;
                }
                return;
            }
        }

        private void signalShutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Shutting down the closer thread:" + this));
            }
            this.add(null);
        }

        private void awaitTermination() throws IOException {
            while (this.isAlive()) {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)"Spurious wakeup?", (Throwable)e);
                }
            }
            if (this.closerException != null) {
                throw new IOException("Failure while closing map outputs.", this.closerException);
            }
        }
    }

    class KvOffset
    implements IndexedSortable {
        int currentCapacity = 0;
        int initialCapacity = 0;
        int maxCapacity = 0;
        int[] offsets;
        int size;
        byte[] prefixkey;

        public KvOffset(int iCap, int mCap) throws IllegalArgumentException {
            if (iCap < 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + iCap);
            }
            this.initialCapacity = iCap;
            this.maxCapacity = mCap > iCap ? mCap : iCap;
            this.offsets = new int[this.initialCapacity];
            this.currentCapacity = this.initialCapacity;
            this.size = 0;
        }

        public void add(int val) throws IndexOutOfBoundsException {
            if (this.size >= this.currentCapacity) {
                this.expand();
            }
            this.offsets[this.size++] = val;
        }

        public int get(int pos) throws IndexOutOfBoundsException {
            this.RangeCheck(pos);
            return this.offsets[pos];
        }

        public void reset() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        private void RangeCheck(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
            }
        }

        private void expand() throws IndexOutOfBoundsException {
            if (this.currentCapacity >= this.maxCapacity) {
                throw new IndexOutOfBoundsException("KvOffset: Limit reached. Current Capacity: " + this.currentCapacity);
            }
            int newsize = this.currentCapacity * 3 / 2 + 1;
            if (newsize >= this.maxCapacity) {
                newsize = this.maxCapacity;
            }
            int[] newarray = new int[newsize];
            System.arraycopy(this.offsets, 0, newarray, 0, this.size);
            this.offsets = null;
            this.offsets = newarray;
            this.currentCapacity = newsize;
        }

        private int putIntPrefix(int keyInt, int offset) {
            int what = MapRFsOutputBuffer.this.kvindices[keyInt];
            this.prefixkey[offset++] = (byte)(what >>> 24);
            this.prefixkey[offset++] = (byte)(what >>> 16);
            this.prefixkey[offset++] = (byte)(what >>> 8);
            this.prefixkey[offset++] = (byte)what;
            return offset;
        }

        public int compare(int i, int j) {
            int keyInt;
            int ii = this.offsets[i] * MapRFsOutputBuffer.this.acctSize + 0;
            int ij = this.offsets[j] * MapRFsOutputBuffer.this.acctSize + 0;
            int p = 0;
            for (keyInt = ii; keyInt < ii + MapRFsOutputBuffer.this.keyPrefixLen / 4; ++keyInt) {
                p = this.putIntPrefix(keyInt, p);
            }
            for (keyInt = ij; keyInt < ij + MapRFsOutputBuffer.this.keyPrefixLen / 4; ++keyInt) {
                p = this.putIntPrefix(keyInt, p);
            }
            int resFromPartitionAndPrefix = WritableComparator.compareBytes((byte[])this.prefixkey, (int)0, (int)MapRFsOutputBuffer.this.keyPrefixLen, (byte[])this.prefixkey, (int)MapRFsOutputBuffer.this.keyPrefixLen, (int)MapRFsOutputBuffer.this.keyPrefixLen);
            if (resFromPartitionAndPrefix != 0) {
                return resFromPartitionAndPrefix;
            }
            return MapRFsOutputBuffer.this.comparator.compare(MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.kvindices[ii + MapRFsOutputBuffer.this.keyStart], MapRFsOutputBuffer.this.kvindices[ii + MapRFsOutputBuffer.this.valStart] - MapRFsOutputBuffer.this.kvindices[ii + MapRFsOutputBuffer.this.keyStart], MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.kvindices[ij + MapRFsOutputBuffer.this.keyStart], MapRFsOutputBuffer.this.kvindices[ij + MapRFsOutputBuffer.this.valStart] - MapRFsOutputBuffer.this.kvindices[ij + MapRFsOutputBuffer.this.keyStart]);
        }

        public void swap(int i, int j) {
            int tmp = this.offsets[i];
            this.offsets[i] = this.offsets[j];
            this.offsets[j] = tmp;
        }
    }

    class MapRResultIterator
    implements RawKeyValueIterator {
        private final DataInputBuffer keybuf = new DataInputBuffer();
        private final InMemValBytes vbytes = new InMemValBytes();
        private KvOffset offsets;
        private int current = 0;
        private int end = 0;

        public MapRResultIterator(KvOffset ko) {
            this.offsets = ko;
            this.current = -1;
            this.end = ko.size();
        }

        public boolean next() throws IOException {
            return ++this.current < this.end;
        }

        public DataInputBuffer getKey() throws IOException {
            int kvoff = this.offsets.get(this.current) * MapRFsOutputBuffer.this.acctSize;
            this.keybuf.reset(MapRFsOutputBuffer.this.kvbuffer, MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.keyStart], MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.valStart] - MapRFsOutputBuffer.this.kvindices[kvoff + MapRFsOutputBuffer.this.keyStart]);
            return this.keybuf;
        }

        public DataInputBuffer getValue() throws IOException {
            MapRFsOutputBuffer.this.getVBytesForOffset(this.offsets.get(this.current) * MapRFsOutputBuffer.this.acctSize, this.vbytes);
            return this.vbytes;
        }

        public Progress getProgress() {
            return null;
        }

        public void close() {
        }
    }

    protected class InMemValBytes
    extends DataInputBuffer {
        private byte[] buffer;
        private int start;
        private int length;

        protected InMemValBytes() {
        }

        public void reset(byte[] buffer, int start, int length) {
            this.buffer = buffer;
            this.start = start;
            this.length = length;
            if (start + length > MapRFsOutputBuffer.this.bufvoid) {
                this.buffer = new byte[this.length];
                int taillen = MapRFsOutputBuffer.this.bufvoid - start;
                System.arraycopy(buffer, start, this.buffer, 0, taillen);
                System.arraycopy(buffer, 0, this.buffer, taillen, length - taillen);
                this.start = 0;
            }
            super.reset(this.buffer, this.start, this.length);
        }
    }
}

