/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.conf;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.mapred.MapRFsOutputBuffer;
import org.apache.hadoop.mapred.MapRFsOutputFile;
import org.apache.hadoop.mapred.MapRIFileInputStream;
import org.apache.hadoop.mapred.MapRIFileOutputStream;
import org.apache.hadoop.mapreduce.task.reduce.DirectShuffle;

public class MapReduceDefaultProperties
extends Properties {
    private static final Map<String, String> props = new HashMap<String, String>();
    private static final long IO_SORT_XMX_THRESHOLD = 0x32000000L;
    private static final String IO_SORT_MB_MIN = "100";
    private static final String IO_SORT_MB_MAX = "480";

    private static String getIoSortMb() {
        return Runtime.getRuntime().maxMemory() >= 0x32000000L ? IO_SORT_MB_MAX : IO_SORT_MB_MIN;
    }

    public MapReduceDefaultProperties() {
        this.putAll(props);
    }

    static {
        props.put("mapreduce.framework.name", "yarn");
        props.put("yarn.app.mapreduce.am.staging-dir", "${fs.defaultFS}/tmp/staging");
        props.put("mapreduce.task.local.output.class", MapRFsOutputFile.class.getName());
        props.put("mapreduce.job.map.output.collector.class", MapRFsOutputBuffer.class.getName());
        props.put("mapreduce.job.map.output.collector.class", MapRFsOutputBuffer.class.getName());
        props.put("mapreduce.job.reduce.shuffle.consumer.plugin.class", DirectShuffle.class.getName());
        props.put("mapred.ifile.outputstream", MapRIFileOutputStream.class.getName());
        props.put("mapred.ifile.inputstream", MapRIFileInputStream.class.getName());
        props.put("mapred.local.mapoutput", "false");
        props.put("mapreduce.job.shuffle.provider.services", "mapr_direct_shuffle");
        props.put("mapr.mapred.localvolume.root.dir.name", "nodeManager");
        props.put("mapr.localoutput.dir", "output");
        props.put("mapr.localspill.dir", "spill");
        props.put("mapred.maxthreads.generate.mapoutput", "1");
        props.put("mapred.maxthreads.partition.closer", "1");
        props.put("mapr.map.keyprefix.ints", "1");
        props.put("mapreduce.map.output.compress", "false");
        props.put("mapreduce.map.speculative", "true");
        props.put("mapreduce.reduce.speculative", "true");
        props.put("mapreduce.map.memory.mb", "1024");
        props.put("mapreduce.map.java.opts", "-Xmx900m");
        props.put("mapreduce.task.io.sort.mb", MapReduceDefaultProperties.getIoSortMb());
        props.put("mapreduce.task.io.sort.factor", "256");
        props.put("mapreduce.map.sort.spill.percent", "0.99");
        props.put("io.sort.record.percent", "0.17");
        props.put("mapreduce.reduce.memory.mb", "2048");
        props.put("mapreduce.reduce.java.opts", "-Xmx1500m");
        props.put("mapreduce.job.reduce.slowstart.completedmaps", "0.95");
        props.put("mapreduce.reduce.shuffle.parallelcopies", "12");
    }
}

