/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.HasRawComparablePrefix;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.IFile;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputCollector;
import org.apache.hadoop.mapred.MapRFsOutputBuffer;
import org.apache.hadoop.mapred.MapRFsOutputFile;
import org.apache.hadoop.mapred.MapTask;
import org.apache.hadoop.mapred.Merger;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.SpillRecord;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.IndexedSortable;
import org.apache.hadoop.util.IndexedSorter;
import org.apache.hadoop.util.Progress;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.QuickSort;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class MapRFsOutputBuffer<K, V>
implements MapOutputCollector<K, V>,
IndexedSortable {
    private static final Log LOG = LogFactory.getLog(MapRFsOutputBuffer.class);
    private int partitions;
    private JobConf job;
    private Task.TaskReporter reporter;
    private Class<K> keyClass;
    private Class<V> valClass;
    private RawComparator<K> comparator;
    private SerializationFactory serializationFactory;
    private Serializer<K> keySerializer;
    private Serializer<V> valSerializer;
    private Task.CombinerRunner<K, V> combinerRunner;
    private Task.CombineOutputCollector<K, V> combineCollector;
    private CompressionCodec codec;
    private IntBuffer kvmeta;
    volatile int kvstart = 0;
    volatile int kvend = 0;
    int kvindex = 0;
    int equator;
    volatile int bufstart = 0;
    volatile int bufend = 0;
    int bufmark = 0;
    int bufindex = 0;
    volatile int bufvoid = 0;
    byte[] kvbuffer;
    private final byte[] b0 = new byte[0];
    private static final int VALSTART = 0;
    private static final int KEYSTART = 1;
    private static final int PARTITION = 2;
    private static final int VALLEN = 3;
    private static final int NMETA = 4;
    private static final int METASIZE = 16;
    private int maxRec;
    private int softLimit;
    private int softRecordLimit;
    boolean spillInProgress;
    int bufferRemaining;
    volatile Throwable sortSpillException = null;
    volatile int numSpills = 0;
    private int minSpillsForCombine;
    private IndexedSorter sorter;
    final ReentrantLock spillLock = new ReentrantLock();
    final Condition spillDone = this.spillLock.newCondition();
    final Condition spillReady = this.spillLock.newCondition();
    final BlockingBuffer bb = new BlockingBuffer(this);
    volatile boolean spillThreadRunning = false;
    final MapRSpillThread spillThread = new MapRSpillThread(this, null);
    private FileSystem rfs;
    private Counters.Counter mapOutputByteCounter;
    private Counters.Counter mapOutputRecordCounter;
    private Counters.Counter fileOutputByteCounter;
    final ArrayList<SpillRecord> indexCacheList = new ArrayList();
    private int totalIndexCacheMemory;
    private int indexCacheMemoryLimit;
    private static final int INDEX_CACHE_MEMORY_LIMIT_DEFAULT = 0x100000;
    private MapTask mapTask;
    private MapRFsOutputFile mapOutputFile;
    private Progress sortPhase;
    private Counters.Counter spilledRecordsCounter;
    private static final int INT_BYTES = 4;
    private static final int MIN_KEYPREFIX_INTS = 1;
    private static final int MAX_KEYPREFIX_INTS = 4;
    private static final int KEYPREFIX = 0;
    private ExecutorService threadPool;
    private long outputSize = 0L;
    private int kvoffsetTotal;
    private KvOffset[] kvoffsets;
    private KvOffset[] oldKvoffsets = null;
    private int[] kvindices;
    private int currentThreadsNumber;
    private int closerThreadsNumber;
    private int keyPrefixLen;
    private int keyStart;
    private int valStart;
    private int acctSize;
    private int recSize;
    private byte[] prefixdata;
    private TaskAttemptID mapId;
    final byte[] META_BUFFER_TMP = new byte[16];

    private void initFS(TaskAttemptID mapId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initializing MapRFsOutputBuffer");
        }
        this.rfs = FileSystem.get((Configuration)this.job);
        this.mapId = mapId;
        this.currentThreadsNumber = this.job.getInt("mapred.maxthreads.generate.mapoutput", -1);
        if (this.threadPool == null) {
            this.threadPool = new ThreadPoolExecutor(0, this.currentThreadsNumber, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }
        this.closerThreadsNumber = this.job.getInt("mapred.maxthreads.partition.closer", -1);
        int tmpKeyPrefixInts = this.job.getInt("mapr.map.keyprefix.ints", 1);
        if (tmpKeyPrefixInts > 4 || tmpKeyPrefixInts < 1) {
            throw new IOException(tmpKeyPrefixInts + ": key prefix ints must be in " + "[" + 1 + ", " + 4 + "]");
        }
        this.keyPrefixLen = tmpKeyPrefixInts * 4;
        this.prefixdata = new byte[this.keyPrefixLen];
        this.keyStart = 0 + tmpKeyPrefixInts;
        this.valStart = this.keyStart + 1;
        this.acctSize = this.valStart + 1;
        this.recSize = (this.acctSize + 1) * 4;
    }

    public void init(MapOutputCollector.Context context) throws IOException, ClassNotFoundException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initializing: " + this.getClass().getName()));
        }
        this.job = context.getJobConf();
        this.reporter = context.getReporter();
        this.mapTask = context.getMapTask();
        this.mapTask.setReportOutputSize(false);
        this.mapOutputFile = (MapRFsOutputFile)ReflectionUtils.newInstance(MapRFsOutputFile.class, (Configuration)this.job);
        this.mapOutputFile.setConf((Configuration)this.job);
        this.sortPhase = this.mapTask.getSortPhase();
        this.spilledRecordsCounter = this.reporter.getCounter((Enum)TaskCounter.SPILLED_RECORDS);
        this.partitions = this.job.getNumReduceTasks();
        this.initFS(this.getTaskID());
        float spillper = this.job.getFloat("mapreduce.map.sort.spill.percent", 0.8f);
        float recper = this.job.getFloat("io.sort.record.percent", -1.0f);
        int sortmb = this.job.getInt("mapreduce.task.io.sort.mb", 100);
        this.indexCacheMemoryLimit = this.job.getInt("mapreduce.task.index.cache.limit.bytes", 0x100000);
        if (spillper > 1.0f || spillper <= 0.0f) {
            throw new IOException("Invalid \"mapreduce.map.sort.spill.percent\": " + spillper);
        }
        if (recper > 1.0f || recper < 0.01f) {
            throw new IOException("Invalid \"io.sort.record.percent\": " + recper);
        }
        if ((sortmb & 0x7FF) != sortmb) {
            throw new IOException("Invalid \"mapreduce.task.io.sort.mb\": " + sortmb);
        }
        this.sorter = (IndexedSorter)ReflectionUtils.newInstance((Class)this.job.getClass("map.sort.class", QuickSort.class, IndexedSorter.class), (Configuration)this.job);
        int maxMemUsage = sortmb << 20;
        int recordCapacity = (int)((float)maxMemUsage * recper);
        recordCapacity -= recordCapacity % this.recSize;
        this.kvbuffer = new byte[maxMemUsage - recordCapacity];
        this.bufvoid = this.kvbuffer.length;
        this.kvoffsetTotal = (recordCapacity /= this.recSize) - recordCapacity % this.partitions;
        this.oldKvoffsets = null;
        this.initKvOffsets();
        this.kvindices = new int[this.kvoffsetTotal * this.acctSize];
        this.kvmeta = ByteBuffer.wrap(this.kvbuffer).order(ByteOrder.nativeOrder()).asIntBuffer();
        this.bufindex = 0;
        this.bufend = 0;
        this.bufstart = 0;
        this.kvindex = 0;
        this.kvend = 0;
        this.kvstart = 0;
        this.maxRec = this.kvmeta.capacity() / 4;
        this.bufferRemaining = this.softLimit = (int)((float)this.kvbuffer.length * spillper);
        this.softRecordLimit = (int)((float)this.kvoffsetTotal * spillper);
        LOG.info((Object)("mapreduce.task.io.sort.mb: " + sortmb));
        LOG.info((Object)("soft limit at " + this.softLimit));
        LOG.info((Object)("bufstart = " + this.bufstart + "; bufvoid = " + this.bufvoid));
        LOG.info((Object)("kvstart = " + this.kvstart + "; length = " + this.maxRec));
        this.comparator = this.job.getOutputKeyComparator();
        this.keyClass = this.job.getMapOutputKeyClass();
        this.valClass = this.job.getMapOutputValueClass();
        this.serializationFactory = new SerializationFactory((Configuration)this.job);
        this.keySerializer = this.serializationFactory.getSerializer(this.keyClass);
        this.keySerializer.open((OutputStream)this.bb);
        this.valSerializer = this.serializationFactory.getSerializer(this.valClass);
        this.valSerializer.open((OutputStream)this.bb);
        this.mapOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_BYTES);
        this.mapOutputRecordCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_RECORDS);
        this.fileOutputByteCounter = this.reporter.getCounter((Enum)TaskCounter.MAP_OUTPUT_MATERIALIZED_BYTES);
        if (this.job.getCompressMapOutput()) {
            Class codecClass = this.job.getMapOutputCompressorClass(DefaultCodec.class);
            this.codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)this.job);
        } else {
            this.codec = null;
        }
        Counters.Counter combineInputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_INPUT_RECORDS);
        this.combinerRunner = Task.CombinerRunner.create((JobConf)this.job, (TaskAttemptID)this.getTaskID(), (Counters.Counter)combineInputCounter, (Task.TaskReporter)this.reporter, null);
        if (this.combinerRunner != null) {
            Counters.Counter combineOutputCounter = this.reporter.getCounter((Enum)TaskCounter.COMBINE_OUTPUT_RECORDS);
            this.combineCollector = new Task.CombineOutputCollector(combineOutputCounter, (Progressable)this.reporter, (Configuration)this.job);
        } else {
            this.combineCollector = null;
        }
        this.spillInProgress = false;
        this.minSpillsForCombine = this.job.getInt("mapreduce.map.combine.minspills", 3);
        this.spillThread.setDaemon(true);
        this.spillThread.setName("MapRSpillThread");
        this.spillLock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Starting spill thread");
            }
            this.spillThread.start();
            while (!this.spillThreadRunning) {
                this.spillDone.await();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Spill thread failed to initialize", e);
        }
        finally {
            this.spillLock.unlock();
        }
        if (this.sortSpillException != null) {
            throw new IOException("Spill thread failed to initialize", this.sortSpillException);
        }
    }

    private int getIntPrefix(int keyInt, int offset) {
        this.kvindices[keyInt] = (this.prefixdata[offset++] & 0xFF) << 24 | (this.prefixdata[offset++] & 0xFF) << 16 | (this.prefixdata[offset++] & 0xFF) << 8 | this.prefixdata[offset++] & 0xFF;
        return offset;
    }

    private void saveKvOffsets(boolean flush) {
        if (flush) {
            this.freeKvOffsets(this.oldKvoffsets);
            this.oldKvoffsets = null;
            this.oldKvoffsets = this.kvoffsets;
        } else if (this.oldKvoffsets == null) {
            this.oldKvoffsets = this.kvoffsets;
            this.initKvOffsets();
        } else {
            KvOffset[] tmp = this.kvoffsets;
            this.kvoffsets = this.oldKvoffsets;
            this.oldKvoffsets = tmp;
        }
    }

    private void freeKvOffsets(KvOffset[] ko) {
        if (ko != null) {
            for (int i = 0; i < this.partitions; ++i) {
                ko[i] = null;
            }
            ko = null;
        }
    }

    private void initKvOffsets() {
        this.kvoffsets = new KvOffset[this.partitions];
        for (int i = 0; i < this.partitions; ++i) {
            this.kvoffsets[i] = new KvOffset(this, this.kvoffsetTotal / (4 * this.partitions), this.kvoffsetTotal);
        }
    }

    private TaskAttemptID getTaskID() {
        return this.mapTask.getTaskID();
    }

    private void setEquator(int pos) {
        this.equator = pos;
        int aligned = pos - pos % 16;
        this.kvindex = (aligned - 16 + this.kvbuffer.length) % this.kvbuffer.length / 4;
        LOG.info((Object)("(EQUATOR) " + pos + " kvi " + this.kvindex + "(" + this.kvindex * 4 + ")"));
    }

    private void resetSpill() {
        int e;
        this.bufstart = this.bufend = (e = this.equator);
        int aligned = e - e % 16;
        this.kvstart = this.kvend = (aligned - 16 + this.kvbuffer.length) % this.kvbuffer.length / 4;
        LOG.info((Object)("(RESET) equator " + e + " kv " + this.kvstart + "(" + this.kvstart * 4 + ")" + " kvi " + this.kvindex + "(" + this.kvindex * 4 + ")"));
    }

    final int distanceTo(int i, int j) {
        return this.distanceTo(i, j, this.kvbuffer.length);
    }

    int distanceTo(int i, int j, int mod) {
        return i <= j ? j - i : mod - i + j;
    }

    int offsetFor(int metapos) {
        return metapos * 4;
    }

    public int compare(int mi, int mj) {
        int kvjp;
        int kvi = this.offsetFor(mi % this.maxRec);
        int kvj = this.offsetFor(mj % this.maxRec);
        int kvip = this.kvmeta.get(kvi + 2);
        if (kvip != (kvjp = this.kvmeta.get(kvj + 2))) {
            return kvip - kvjp;
        }
        return this.comparator.compare(this.kvbuffer, this.kvmeta.get(kvi + 1), this.kvmeta.get(kvi + 0) - this.kvmeta.get(kvi + 1), this.kvbuffer, this.kvmeta.get(kvj + 1), this.kvmeta.get(kvj + 0) - this.kvmeta.get(kvj + 1));
    }

    public void swap(int mi, int mj) {
        int iOff = mi % this.maxRec * 16;
        int jOff = mj % this.maxRec * 16;
        System.arraycopy(this.kvbuffer, iOff, this.META_BUFFER_TMP, 0, 16);
        System.arraycopy(this.kvbuffer, jOff, this.kvbuffer, iOff, 16);
        System.arraycopy(this.META_BUFFER_TMP, 0, this.kvbuffer, jOff, 16);
    }

    public void close() {
    }

    private void checkSpillException() throws IOException {
        Throwable lspillException = this.sortSpillException;
        if (lspillException != null) {
            if (lspillException instanceof Error) {
                String logMsg = "Task " + this.getTaskID() + " failed : " + StringUtils.stringifyException((Throwable)lspillException);
                this.mapTask.reportFatalError(this.getTaskID(), lspillException, logMsg);
            }
            throw new IOException("Spill failed", lspillException);
        }
    }

    private synchronized void startSpill() {
        this.kvend = this.kvindex;
        this.bufend = this.bufmark;
        this.saveKvOffsets(false);
        LOG.info((Object)"startSpill: Spilling map output");
        LOG.info((Object)("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid));
        LOG.info((Object)("kvstart = " + this.kvstart + "; kvend = " + this.kvindex + "; length = " + this.kvoffsetTotal));
        this.spillReady.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spillSingleRecord(K key, V value, int partition) throws IOException {
        long size = this.kvbuffer.length + this.partitions * 150;
        FSDataOutputStream out = null;
        try {
            SpillRecord spillRec = new SpillRecord(this.partitions);
            Path filename = this.mapOutputFile.getSpillFileForWrite(this.numSpills, size);
            out = this.rfs.create(filename);
            IndexRecord rec = new IndexRecord();
            for (int i = 0; i < this.partitions; ++i) {
                IFile.Writer writer = null;
                try {
                    long segmentStart = out.getPos();
                    writer = new IFile.Writer((Configuration)this.job, out, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                    if (i == partition) {
                        long recordStart = out.getPos();
                        writer.append(key, value);
                        this.mapOutputByteCounter.increment(out.getPos() - recordStart);
                    }
                    writer.close();
                    rec.startOffset = segmentStart;
                    rec.rawLength = writer.getRawLength();
                    rec.partLength = writer.getCompressedLength();
                    spillRec.putIndex(rec, i);
                    writer = null;
                    continue;
                }
                catch (IOException e) {
                    if (null != writer) {
                        writer.close();
                    }
                    throw e;
                }
            }
            if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, (long)(this.partitions * 24));
                spillRec.writeToFile(indexFilename, this.job);
            } else {
                this.indexCacheList.add(spillRec);
                this.totalIndexCacheMemory += spillRec.size() * 24;
            }
            ++this.numSpills;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void getVBytesForOffset(int kvoff, InMemValBytes vbytes) {
        int nextindex = kvoff / this.acctSize == (this.kvend - 1 + this.kvoffsetTotal) % this.kvoffsetTotal ? this.bufend : this.kvindices[(kvoff + this.acctSize + this.keyStart) % this.kvindices.length];
        int vallen = nextindex >= this.kvindices[kvoff + this.valStart] ? nextindex - this.kvindices[kvoff + this.valStart] : this.bufvoid - this.kvindices[kvoff + this.valStart] + nextindex;
        vbytes.reset(this.kvbuffer, this.kvindices[kvoff + this.valStart], vallen);
    }

    protected boolean sortAndSpillWrapper() throws IOException, ClassNotFoundException, InterruptedException {
        if (this.numSpills == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MapRFs: No spills");
            }
            this.saveKvOffsets(true);
            this.sortAndWrite();
            this.threadPool.shutdown();
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("MapRFs: Number of spills: " + this.numSpills));
        }
        this.saveKvOffsets(true);
        this.sortAndSpill();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sortAndSpill() throws IOException, ClassNotFoundException, InterruptedException {
        long size = (this.bufend >= this.bufstart ? this.bufend - this.bufstart : this.bufvoid - this.bufend + this.bufstart) + this.partitions * 150;
        FSDataOutputStream out = null;
        try {
            SpillRecord spillRec = new SpillRecord(this.partitions);
            out = this.rfs.createFid(this.mapOutputFile.getSpillFid(), this.mapOutputFile.getSpillFileForWriteFid(TaskAttemptID.downgrade((org.apache.hadoop.mapreduce.TaskAttemptID)this.mapId), this.numSpills, size));
            IndexRecord rec = new IndexRecord();
            InMemValBytes value = new InMemValBytes(this);
            byte[] threadLocalPrefix = new byte[2 * this.keyPrefixLen];
            for (int i = 0; i < this.partitions; ++i) {
                KvOffset kvo = this.oldKvoffsets[i];
                kvo.prefixkey = threadLocalPrefix;
                IFile.Writer writer = null;
                try {
                    long segmentStart = out.getPos();
                    writer = new IFile.Writer((Configuration)this.job, out, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
                    if (kvo.size() > 0) {
                        this.sorter.sort((IndexedSortable)kvo, 0, kvo.size(), (Progressable)this.reporter);
                        if (this.combinerRunner == null) {
                            DataInputBuffer key = new DataInputBuffer();
                            int j = 0;
                            while (j < kvo.size()) {
                                int kvoff = kvo.get(j++) * this.acctSize;
                                this.getVBytesForOffset(kvoff, value);
                                key.reset(this.kvbuffer, this.kvindices[kvoff + this.keyStart], this.kvindices[kvoff + this.valStart] - this.kvindices[kvoff + this.keyStart]);
                                writer.append(key, (DataInputBuffer)value);
                            }
                        } else if (kvo.size() > 0) {
                            this.combineCollector.setWriter(writer);
                            MapRResultIterator kvIter = new MapRResultIterator(this, kvo);
                            this.combinerRunner.combine((RawKeyValueIterator)kvIter, (OutputCollector)this.combineCollector);
                        }
                    }
                    kvo.reset();
                    writer.close();
                    rec.startOffset = segmentStart;
                    rec.rawLength = writer.getRawLength();
                    rec.partLength = writer.getCompressedLength();
                    spillRec.putIndex(rec, i);
                    writer = null;
                    continue;
                }
                finally {
                    if (null != writer) {
                        writer.close();
                    }
                }
            }
            if (this.totalIndexCacheMemory >= this.indexCacheMemoryLimit) {
                Path indexFilename = this.mapOutputFile.getSpillIndexFileForWrite(this.numSpills, (long)(this.partitions * 24));
                spillRec.writeToFile(indexFilename, this.job, null, this.rfs);
            } else {
                this.indexCacheList.add(spillRec);
                this.totalIndexCacheMemory += spillRec.size() * 24;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("sortAndSpill: Finished spill " + this.numSpills + ", kvstart = " + this.kvstart + ", kvend = " + this.kvend));
            }
            ++this.numSpills;
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void sortAndWrite() throws IOException, ClassNotFoundException, InterruptedException {
        int i;
        Random random = new Random();
        ArrayList<CloserThread> closerList = new ArrayList<CloserThread>(this.closerThreadsNumber);
        for (int i2 = 0; i2 < this.closerThreadsNumber; ++i2) {
            CloserThread closerThread = new CloserThread(this, null);
            closerThread.setDaemon(true);
            closerList.add(closerThread);
            closerThread.start();
        }
        ArrayList<1> calls = new ArrayList<1>();
        int threadsNumber = this.currentThreadsNumber;
        int maxLoop = this.partitions / threadsNumber;
        int k = 0;
        while (k < threadsNumber) {
            int someOff = k++;
            byte[] threadLocalPrefix = new byte[2 * this.keyPrefixLen];
            1 call = new /* Unavailable Anonymous Inner Class!! */;
            calls.add(call);
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Before threading");
            }
            this.threadPool.invokeAll(calls);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"After threading");
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)"Exception while trying to write map outputs", (Throwable)e);
            throw new IOException(e);
        }
        for (i = 0; i < closerList.size(); ++i) {
            CloserThread.access$3100((CloserThread)((CloserThread)closerList.get(i)));
        }
        for (i = 0; i < closerList.size(); ++i) {
            CloserThread.access$3200((CloserThread)((CloserThread)closerList.get(i)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"End of sortandWrite");
        }
    }

    protected void mergeParts() throws IOException, InterruptedException, ClassNotFoundException {
        int i;
        LOG.info((Object)"mergeParts: Merging partitions");
        this.freeKvOffsets(this.kvoffsets);
        this.freeKvOffsets(this.oldKvoffsets);
        this.oldKvoffsets = null;
        this.kvoffsets = null;
        Path[] filename = new Path[this.numSpills];
        CloserThread closerThread = new CloserThread(this, null);
        closerThread.setDaemon(true);
        closerThread.start();
        for (i = 0; i < this.numSpills; ++i) {
            filename[i] = this.mapOutputFile.getSpillFile(i);
        }
        for (i = this.indexCacheList.size(); i < this.numSpills; ++i) {
            Path indexFileName = this.mapOutputFile.getSpillIndexFile(i);
            this.indexCacheList.add(new SpillRecord(indexFileName, this.job, null, UserGroupInformation.getCurrentUser().getShortUserName(), this.rfs));
        }
        this.sortPhase.addPhases(this.partitions);
        for (int parts = 0; parts < this.partitions; ++parts) {
            FSDataOutputStream finalOut = this.rfs.createFid(this.mapOutputFile.getOutputFid(), this.mapOutputFile.getOutputFileForWriteFid(TaskAttemptID.downgrade((org.apache.hadoop.mapreduce.TaskAttemptID)this.mapId), -1L, parts));
            ArrayList<Merger.Segment> segmentList = new ArrayList<Merger.Segment>(this.numSpills);
            for (int i2 = 0; i2 < this.numSpills; ++i2) {
                IndexRecord indexRecord = ((SpillRecord)this.indexCacheList.get(i2)).getIndex(parts);
                Merger.Segment s = new Merger.Segment((Configuration)this.job, this.rfs, filename[i2], indexRecord.startOffset, indexRecord.partLength, this.codec, true);
                segmentList.add(i2, s);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("MapId=" + this.mapId + " Reducer=" + parts + "Spill =" + i2 + "(" + indexRecord.startOffset + "," + indexRecord.rawLength + ", " + indexRecord.partLength + ")"));
            }
            Path tmpDir = this.mapOutputFile.getLocalPathForWrite(this.mapId.toString(), -1L);
            RawKeyValueIterator kvIter = Merger.merge((Configuration)this.job, (FileSystem)this.rfs, (Class)this.keyClass, (Class)this.valClass, (CompressionCodec)this.codec, segmentList, (int)Math.max(2, this.job.getInt("io.sort.factor", -1)), (Path)tmpDir, (RawComparator)this.job.getOutputKeyComparator(), (Progressable)this.reporter, (boolean)false, null, (Counters.Counter)this.spilledRecordsCounter, (Progress)this.sortPhase.phase());
            IFile.Writer writer = new IFile.Writer((Configuration)this.job, finalOut, this.keyClass, this.valClass, this.codec, this.spilledRecordsCounter);
            if (this.combinerRunner == null || this.numSpills < this.minSpillsForCombine) {
                Merger.writeFile((RawKeyValueIterator)kvIter, (IFile.Writer)writer, (Progressable)this.reporter, (Configuration)this.job);
            } else {
                this.combineCollector.setWriter(writer);
                this.combinerRunner.combine(kvIter, (OutputCollector)this.combineCollector);
            }
            writer.close();
            this.sortPhase.startNextPhase();
            this.outputSize += writer.getRawLength();
            writer = null;
            CloserThread.access$3000((CloserThread)closerThread, (FSDataOutputStream)finalOut);
            finalOut = null;
        }
        CloserThread.access$3100((CloserThread)closerThread);
        for (i = 0; i < this.numSpills; ++i) {
            this.rfs.delete(filename[i], true);
        }
        CloserThread.access$3200((CloserThread)closerThread);
    }

    private void checkKeyValuePartition(K key, V value, int partition) throws IOException {
        if (key.getClass() != this.keyClass) {
            throw new IOException("Type mismatch in key from map: expected " + this.keyClass.getName() + ", received " + key.getClass().getName());
        }
        if (value.getClass() != this.valClass) {
            throw new IOException("Type mismatch in value from map: expected " + this.valClass.getName() + ", received " + value.getClass().getName());
        }
        if (partition < 0 || partition >= this.partitions) {
            throw new IOException("Illegal partition for " + key + " (" + partition + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void collect(K key, V value, int partition) throws IOException {
        this.reporter.progress();
        this.checkKeyValuePartition(key, value, partition);
        int kvnext = (this.kvindex + 1) % this.kvoffsetTotal;
        this.spillLock.lock();
        try {
            boolean kvfull;
            do {
                boolean kvsoftlimit;
                if (this.sortSpillException != null) {
                    throw (IOException)new IOException("Spill failed").initCause(this.sortSpillException);
                }
                boolean bl = kvfull = kvnext == this.kvstart;
                boolean bl2 = kvnext > this.kvend ? kvnext - this.kvend > this.softRecordLimit : (kvsoftlimit = this.kvend - kvnext <= this.kvoffsetTotal - this.softRecordLimit);
                if (this.kvstart == this.kvend && kvsoftlimit) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("collect: Spilling map output: record full = " + kvsoftlimit));
                    }
                    this.startSpill();
                }
                if (!kvfull) continue;
                try {
                    while (this.kvstart != this.kvend) {
                        this.reporter.progress();
                        this.spillDone.await();
                    }
                }
                catch (InterruptedException e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Waiting for spillDone interrupted.", (Throwable)e);
                    }
                    throw (IOException)new IOException("Collector interrupted while waiting for the writer").initCause(e);
                }
            } while (kvfull);
        }
        finally {
            this.spillLock.unlock();
        }
        try {
            int keystart = this.bufindex;
            this.keySerializer.serialize(key);
            if (this.bufindex < keystart) {
                this.bb.shiftBufferedKey();
                keystart = 0;
            }
            int valstart = this.bufindex;
            this.valSerializer.serialize(value);
            int valend = this.bb.markRecord();
            this.mapOutputRecordCounter.increment(1L);
            this.mapOutputByteCounter.increment(valend >= keystart ? (long)(valend - keystart) : (long)(this.bufvoid - keystart + valend));
            int ind = this.kvindex * this.acctSize;
            this.kvoffsets[partition].add(this.kvindex);
            int first = ind + 0;
            int last = first + this.keyPrefixLen / 4;
            if (key instanceof HasRawComparablePrefix) {
                HasRawComparablePrefix hrcpKey = (HasRawComparablePrefix)key;
                hrcpKey.getPrefix(this.prefixdata, 0, this.keyPrefixLen);
                int p = 0;
                for (int keyInt = first; keyInt < last; ++keyInt) {
                    p = this.getIntPrefix(keyInt, p);
                }
            } else {
                for (int keyInt = first; keyInt < last; ++keyInt) {
                    this.kvindices[keyInt] = 0;
                }
            }
            this.kvindices[ind + this.keyStart] = keystart;
            this.kvindices[ind + this.valStart] = valstart;
            this.kvindex = kvnext;
        }
        catch (MapTask.MapBufferTooSmallException e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Record too large for in-memory buffer", (Throwable)e);
            }
            this.spillSingleRecord(key, value, partition);
            this.mapOutputRecordCounter.increment(1L);
            return;
        }
    }

    public synchronized void flush() throws IOException, ClassNotFoundException, InterruptedException {
        if (!this.spillThreadRunning) {
            return;
        }
        LOG.info((Object)("flush: Starting flush of map output, kvstart = " + this.kvstart + ", kvend = " + this.kvend));
        boolean done = false;
        this.spillLock.lock();
        try {
            while (this.kvstart != this.kvend) {
                this.reporter.progress();
                this.spillDone.await();
            }
            this.checkSpillException();
            if (this.kvindex != this.kvend) {
                this.kvend = this.kvindex;
                this.bufend = this.bufmark;
                LOG.info((Object)"flush: Spilling map output");
                LOG.info((Object)("bufstart = " + this.bufstart + "; bufend = " + this.bufmark + "; bufvoid = " + this.bufvoid));
                LOG.info((Object)("kvstart = " + this.kvstart + "(" + this.kvstart * 4 + "); kvend = " + this.kvend + "(" + this.kvend * 4 + "); length = " + (this.distanceTo(this.kvend, this.kvstart, this.kvmeta.capacity()) + 1) + "/" + this.maxRec));
                done = this.sortAndSpillWrapper();
            }
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted while waiting for the writer", e);
        }
        finally {
            this.spillLock.unlock();
        }
        assert (!this.spillLock.isHeldByCurrentThread());
        MapRSpillThread.access$3300((MapRSpillThread)this.spillThread);
        this.kvbuffer = null;
        this.freeKvOffsets(this.kvoffsets);
        this.freeKvOffsets(this.oldKvoffsets);
        this.oldKvoffsets = null;
        this.kvoffsets = null;
        if (!done) {
            this.mergeParts();
        }
    }

    static /* synthetic */ int access$100(MapRFsOutputBuffer x0) {
        return x0.acctSize;
    }

    static /* synthetic */ int[] access$200(MapRFsOutputBuffer x0) {
        return x0.kvindices;
    }

    static /* synthetic */ int access$300(MapRFsOutputBuffer x0) {
        return x0.keyStart;
    }

    static /* synthetic */ int access$400(MapRFsOutputBuffer x0) {
        return x0.valStart;
    }

    static /* synthetic */ void access$500(MapRFsOutputBuffer x0, int x1, InMemValBytes x2) {
        x0.getVBytesForOffset(x1, x2);
    }

    static /* synthetic */ int access$600(MapRFsOutputBuffer x0) {
        return x0.keyPrefixLen;
    }

    static /* synthetic */ RawComparator access$700(MapRFsOutputBuffer x0) {
        return x0.comparator;
    }

    static /* synthetic */ Log access$800() {
        return LOG;
    }

    static /* synthetic */ int access$900(MapRFsOutputBuffer x0) {
        return x0.softLimit;
    }

    static /* synthetic */ void access$1000(MapRFsOutputBuffer x0) {
        x0.startSpill();
    }

    static /* synthetic */ Task.TaskReporter access$1100(MapRFsOutputBuffer x0) {
        return x0.reporter;
    }

    static /* synthetic */ TaskAttemptID access$1200(MapRFsOutputBuffer x0) {
        return x0.getTaskID();
    }

    static /* synthetic */ MapTask access$1300(MapRFsOutputBuffer x0) {
        return x0.mapTask;
    }

    static /* synthetic */ int access$1500(MapRFsOutputBuffer x0) {
        return x0.partitions;
    }

    static /* synthetic */ MapRFsOutputFile access$1600(MapRFsOutputBuffer x0) {
        return x0.mapOutputFile;
    }

    static /* synthetic */ TaskAttemptID access$1700(MapRFsOutputBuffer x0) {
        return x0.mapId;
    }

    static /* synthetic */ FileSystem access$1800(MapRFsOutputBuffer x0) {
        return x0.rfs;
    }

    static /* synthetic */ JobConf access$1900(MapRFsOutputBuffer x0) {
        return x0.job;
    }

    static /* synthetic */ Class access$2000(MapRFsOutputBuffer x0) {
        return x0.keyClass;
    }

    static /* synthetic */ Class access$2100(MapRFsOutputBuffer x0) {
        return x0.valClass;
    }

    static /* synthetic */ CompressionCodec access$2200(MapRFsOutputBuffer x0) {
        return x0.codec;
    }

    static /* synthetic */ Counters.Counter access$2300(MapRFsOutputBuffer x0) {
        return x0.spilledRecordsCounter;
    }

    static /* synthetic */ KvOffset[] access$2400(MapRFsOutputBuffer x0) {
        return x0.oldKvoffsets;
    }

    static /* synthetic */ IndexedSorter access$2500(MapRFsOutputBuffer x0) {
        return x0.sorter;
    }

    static /* synthetic */ Task.CombinerRunner access$2600(MapRFsOutputBuffer x0) {
        return x0.combinerRunner;
    }

    static /* synthetic */ Task.CombineOutputCollector access$2700(MapRFsOutputBuffer x0) {
        return x0.combineCollector;
    }

    static /* synthetic */ long access$2814(MapRFsOutputBuffer x0, long x1) {
        return x0.outputSize += x1;
    }

    static /* synthetic */ int access$2900(MapRFsOutputBuffer x0) {
        return x0.closerThreadsNumber;
    }
}

