/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TypeConverter;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.MRAppMaster;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobFinishEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMCommunicator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMHeartbeatHandler;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStagingCleanup {
    private Configuration conf = new Configuration();
    private FileSystem fs;
    private String stagingJobDir = "tmpJobDir";
    private Path stagingJobPath = new Path(this.stagingJobDir);
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testDeletionofStagingOnUnregistrationFailure() throws IOException {
        this.testDeletionofStagingOnUnregistrationFailure(2, false);
        this.testDeletionofStagingOnUnregistrationFailure(1, false);
    }

    private void testDeletionofStagingOnUnregistrationFailure(int maxAttempts, boolean shouldHaveDeleted) throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        TestMRApp appMaster = new TestMRApp(attemptId, null, JobStateInternal.RUNNING, maxAttempts);
        appMaster.crushUnregistration = true;
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        ((MRAppMaster.RunningAppContext)appMaster.getContext()).resetIsLastAMRetry();
        if (shouldHaveDeleted) {
            Assert.assertEquals((Object)new Boolean(true), (Object)appMaster.isLastAMRetry());
            ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
        } else {
            Assert.assertEquals((Object)new Boolean(false), (Object)appMaster.isLastAMRetry());
            ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.never())).delete(this.stagingJobPath, true);
        }
    }

    @Test
    public void testDeletionofStaging() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        Assert.assertTrue((boolean)true);
        TestMRApp appMaster = new TestMRApp(attemptId, mockAlloc, JobStateInternal.RUNNING, 3);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((Object)true, (Object)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testNoDeletionofStagingOnReboot() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        Assert.assertTrue((boolean)true);
        TestMRApp appMaster = new TestMRApp(attemptId, mockAlloc, JobStateInternal.REBOOT, 3);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((Object)false, (Object)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.times((int)0))).delete(this.stagingJobPath, true);
    }

    public void testDeletionofStagingOnReboot() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(attemptId, mockAlloc, JobStateInternal.REBOOT, 1);
        appMaster.init(this.conf);
        appMaster.start();
        appMaster.shutDownJob();
        Assert.assertEquals((Object)true, (Object)appMaster.getTestIsLastAMRetry());
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    @Test(timeout=30000L)
    public void testDeletionofStagingOnKill() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)0);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(attemptId, mockAlloc);
        appMaster.init(this.conf);
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        ((FileSystem)Mockito.verify((Object)this.fs, (VerificationMode)Mockito.times((int)0))).delete(this.stagingJobPath, true);
    }

    public void testDeletionofStagingOnKillLastTry() throws IOException {
        this.conf.set("mapreduce.job.dir", this.stagingJobDir);
        this.fs = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)this.fs.delete((Path)Matchers.any(Path.class), Matchers.anyBoolean())).thenReturn((Object)true);
        String user = UserGroupInformation.getCurrentUser().getShortUserName();
        Path stagingDir = MRApps.getStagingAreaDir((Configuration)this.conf, (String)user);
        Mockito.when((Object)this.fs.exists(stagingDir)).thenReturn((Object)true);
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)0);
        ApplicationAttemptId attemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobid = (JobId)recordFactory.newRecordInstance(JobId.class);
        jobid.setAppId(appId);
        ContainerAllocator mockAlloc = (ContainerAllocator)Mockito.mock(ContainerAllocator.class);
        TestMRApp appMaster = new TestMRApp(attemptId, mockAlloc);
        appMaster.init(this.conf);
        Assert.assertTrue((String)"appMaster.isLastAMRetry() is false", (boolean)appMaster.isLastAMRetry());
        MRAppMaster.MRAppMasterShutdownHook hook = new MRAppMaster.MRAppMasterShutdownHook((MRAppMaster)appMaster);
        hook.run();
        Assert.assertTrue((String)"MRAppMaster isn't stopped", (boolean)appMaster.isInState(Service.STATE.STOPPED));
        ((FileSystem)Mockito.verify((Object)this.fs)).delete(this.stagingJobPath, true);
    }

    private static RMHeartbeatHandler getStubbedHeartbeatHandler(final AppContext appContext) {
        return new RMHeartbeatHandler(){

            public long getLastHeartbeatTime() {
                return appContext.getClock().getTime();
            }

            public void runOnNextHeartbeat(Runnable callback) {
                callback.run();
            }
        };
    }

    @Test(timeout=20000L)
    public void testStagingCleanupOrder() throws Exception {
        MRAppTestCleanup app = new MRAppTestCleanup(1, 1, true, this.getClass().getName(), true);
        JobImpl job = (JobImpl)app.submit(new Configuration());
        app.waitForState((Job)job, JobState.SUCCEEDED);
        app.verifyCompleted();
        for (int waitTime = 20000; waitTime > 0 && app.numStops < 2; waitTime -= 100) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)1L, (long)app.ContainerAllocatorStopped);
        Assert.assertEquals((long)2L, (long)app.stagingDirCleanedup);
    }

    private final class MRAppTestCleanup
    extends MRApp {
        int stagingDirCleanedup;
        int ContainerAllocatorStopped;
        int numStops;

        public MRAppTestCleanup(int maps, int reduces, boolean autoComplete, String testName, boolean cleanOnStart) {
            super(maps, reduces, autoComplete, testName, cleanOnStart);
            this.stagingDirCleanedup = 0;
            this.ContainerAllocatorStopped = 0;
            this.numStops = 0;
        }

        @Override
        protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
            UserGroupInformation currentUser = null;
            try {
                currentUser = UserGroupInformation.getCurrentUser();
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            MRApp.TestJob newJob = new MRApp.TestJob(this, this.getJobId(), this.getAttemptID(), conf, this.getDispatcher().getEventHandler(), this.getTaskAttemptListener(), this.getContext().getClock(), this.getCommitter(), this.isNewApiCommitter(), currentUser.getUserName(), this.getContext(), forcedState, diagnostic);
            this.getContext().getAllJobs().put(newJob.getID(), newJob);
            this.getDispatcher().register(JobFinishEvent.Type.class, this.createJobFinishEventHandler());
            return newJob;
        }

        @Override
        protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
            return new TestCleanupContainerAllocator();
        }

        public RMHeartbeatHandler getRMHeartbeatHandler() {
            return TestStagingCleanup.getStubbedHeartbeatHandler(this.getContext());
        }

        public void cleanupStagingDir() throws IOException {
            ++this.numStops;
            this.stagingDirCleanedup = this.numStops;
        }

        protected void sysexit() {
        }

        private class TestCleanupContainerAllocator
        extends AbstractService
        implements ContainerAllocator {
            private MRApp.MRAppContainerAllocator allocator;

            TestCleanupContainerAllocator() {
                super(TestCleanupContainerAllocator.class.getName());
                this.allocator = new MRApp.MRAppContainerAllocator(MRAppTestCleanup.this);
            }

            public void handle(ContainerAllocatorEvent event) {
                this.allocator.handle(event);
            }

            protected void serviceStop() throws Exception {
                ++MRAppTestCleanup.this.numStops;
                MRAppTestCleanup.this.ContainerAllocatorStopped = MRAppTestCleanup.this.numStops;
                super.serviceStop();
            }
        }
    }

    private class TestMRApp
    extends MRAppMaster {
        ContainerAllocator allocator;
        boolean testIsLastAMRetry;
        JobStateInternal jobStateInternal;
        boolean crushUnregistration;

        public TestMRApp(ApplicationAttemptId applicationAttemptId, ContainerAllocator allocator) {
            super(applicationAttemptId, ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)1L), "testhost", 2222, 3333, System.currentTimeMillis());
            this.testIsLastAMRetry = false;
            this.crushUnregistration = false;
            this.allocator = allocator;
            this.successfullyUnregistered.set(true);
        }

        public TestMRApp(ApplicationAttemptId applicationAttemptId, ContainerAllocator allocator, JobStateInternal jobStateInternal, int maxAppAttempts) {
            this(applicationAttemptId, allocator);
            this.jobStateInternal = jobStateInternal;
        }

        protected FileSystem getFileSystem(Configuration conf) {
            return TestStagingCleanup.this.fs;
        }

        protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
            if (this.allocator == null) {
                if (this.crushUnregistration) {
                    return new CustomContainerAllocator(context);
                }
                return super.createContainerAllocator(clientService, context);
            }
            return this.allocator;
        }

        protected Job createJob(Configuration conf, JobStateInternal forcedState, String diagnostic) {
            JobImpl jobImpl = (JobImpl)Mockito.mock(JobImpl.class);
            Mockito.when((Object)jobImpl.getInternalState()).thenReturn((Object)this.jobStateInternal);
            Mockito.when((Object)jobImpl.getAllCounters()).thenReturn((Object)new Counters());
            JobID jobID = JobID.forName((String)"job_1234567890000_0001");
            JobId jobId = TypeConverter.toYarn((JobID)jobID);
            Mockito.when((Object)jobImpl.getID()).thenReturn((Object)jobId);
            this.getContext().getAllJobs().put(jobImpl.getID(), jobImpl);
            return jobImpl;
        }

        public void serviceStart() throws Exception {
            super.serviceStart();
            DefaultMetricsSystem.shutdown();
        }

        public void notifyIsLastAMRetry(boolean isLastAMRetry) {
            this.testIsLastAMRetry = isLastAMRetry;
            super.notifyIsLastAMRetry(isLastAMRetry);
        }

        public RMHeartbeatHandler getRMHeartbeatHandler() {
            return TestStagingCleanup.getStubbedHeartbeatHandler(this.getContext());
        }

        protected void sysexit() {
        }

        public Configuration getConfig() {
            return TestStagingCleanup.this.conf;
        }

        protected void initJobCredentialsAndUGI(Configuration conf) {
        }

        public boolean getTestIsLastAMRetry() {
            return this.testIsLastAMRetry;
        }

        private class CustomContainerAllocator
        extends RMCommunicator
        implements ContainerAllocator {
            public CustomContainerAllocator(AppContext context) {
                super(null, context);
            }

            public void serviceInit(Configuration conf) {
            }

            public void serviceStart() {
            }

            public void serviceStop() {
                this.unregister();
            }

            protected void doUnregistration() throws YarnException, IOException, InterruptedException {
                throw new YarnException("test exception");
            }

            protected void heartbeat() throws Exception {
            }

            public void handle(ContainerAllocatorEvent event) {
            }
        }
    }
}

