/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.event;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.ShuffleHandler;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;

public class TaskAttemptContainerLaunchedEvent
extends TaskAttemptEvent {
    static final Log LOG = LogFactory.getLog(TaskAttemptContainerLaunchedEvent.class);
    private int shufflePort;
    private Map<String, ByteBuffer> servicesMetaInfo;

    public TaskAttemptContainerLaunchedEvent(TaskAttemptId id, int shufflePort) {
        super(id, TaskAttemptEventType.TA_CONTAINER_LAUNCHED);
        this.servicesMetaInfo = Collections.synchronizedMap(new HashMap());
        this.shufflePort = shufflePort;
    }

    public TaskAttemptContainerLaunchedEvent(TaskAttemptId id, Map<String, ByteBuffer> servicesMetaInfo) {
        int port;
        block4: {
            super(id, TaskAttemptEventType.TA_CONTAINER_LAUNCHED);
            this.servicesMetaInfo = Collections.synchronizedMap(new HashMap());
            this.setServicesMetaInfo(servicesMetaInfo);
            ByteBuffer portInfo = servicesMetaInfo.get("mapreduce_shuffle");
            port = -1;
            if (portInfo != null) {
                try {
                    port = ShuffleHandler.deserializeMetaData((ByteBuffer)portInfo);
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.info((Object)"Shuffle port is not found - possibly different shuffle service is used", (Throwable)e);
                }
            }
        }
        LOG.info((Object)("Shuffle port returned by ContainerManager for " + id + " : " + port));
        this.shufflePort = port;
        if (port < 0) {
            LOG.info((Object)"Shuffle port is not found - possibly different shuffle service is used");
        }
    }

    public int getShufflePort() {
        return this.shufflePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ByteBuffer> getServicesMetaInfo() {
        HashMap<String, ByteBuffer> metaClone = new HashMap<String, ByteBuffer>(this.servicesMetaInfo.size());
        Map map = this.servicesMetaInfo;
        synchronized (map) {
            for (Map.Entry entry : this.servicesMetaInfo.entrySet()) {
                metaClone.put((String)entry.getKey(), ((ByteBuffer)entry.getValue()).duplicate());
            }
        }
        return metaClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServicesMetaInfo(Map<String, ByteBuffer> serviceMetaData) {
        Map map = this.servicesMetaInfo;
        synchronized (map) {
            for (Map.Entry<String, ByteBuffer> entry : serviceMetaData.entrySet()) {
                this.servicesMetaInfo.put(entry.getKey(), entry.getValue().duplicate());
            }
        }
    }
}

