/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.JobState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.ClusterInfo;
import org.apache.hadoop.mapreduce.v2.app.MRApp;
import org.apache.hadoop.mapreduce.v2.app.client.ClientService;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.JobStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttemptStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.JobUpdatedNodesEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptContainerAssignedEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskAttemptKillEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.JobImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerAllocatorEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerFailedEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.ContainerRequestEvent;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerAllocator;
import org.apache.hadoop.mapreduce.v2.app.rm.RMContainerRequestor;
import org.apache.hadoop.mapreduce.v2.util.MRBuilderUtils;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.MemoryRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.AMRMTokenSecretManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ControlledClock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRMContainerAllocator {
    static final Log LOG = LogFactory.getLog(TestRMContainerAllocator.class);
    static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Before
    public void setup() {
        MyContainerAllocator.getJobUpdatedNodeEvents().clear();
        MyContainerAllocator.getTaskAttemptKillEvents().clear();
        UserGroupInformation.setLoginUser(null);
    }

    @After
    public void tearDown() {
        DefaultMetricsSystem.shutdown();
    }

    @Test
    public void testSimple() throws Exception {
        LOG.info((Object)"Running testSimple");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 1024, new String[]{"h2"});
        allocator.sendRequest(event2);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        Assert.assertEquals((long)4L, (long)rm.getMyFifoScheduler().lastAsk.size());
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h3"});
        allocator.sendRequest(event3);
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        Assert.assertEquals((long)3L, (long)rm.getMyFifoScheduler().lastAsk.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((long)0L, (long)rm.getMyFifoScheduler().lastAsk.size());
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2, event3}, assigned, false);
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((long)5L, (long)rm.getMyFifoScheduler().lastAsk.size());
    }

    @Test
    public void testMapNodeLocality() throws Exception {
        LOG.info((Object)"Running testMapNodeLocality");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 3072);
        rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 1536);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 1024, new String[]{"h1"});
        allocator.sendRequest(event2);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h2"});
        allocator.sendRequest(event3);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        nodeManager3.nodeHeartbeat(true);
        nodeManager1.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2, event3}, assigned, false);
        for (TaskAttemptContainerAssignedEvent event : assigned) {
            if (!event.getTaskAttemptID().equals((Object)event3.getAttemptID())) continue;
            assigned.remove(event);
            Assert.assertTrue((boolean)event.getContainer().getNodeId().getHost().equals("h3"));
            break;
        }
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2}, assigned, true);
    }

    @Test
    public void testResource() throws Exception {
        LOG.info((Object)"Running testResource");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 2048, new String[]{"h2"});
        allocator.sendRequest(event2);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event2}, assigned, false);
    }

    @Test(timeout=30000L)
    public void testReducerRampdownDiagnostics() throws Exception {
        LOG.info((Object)"Running tesReducerRampdownDiagnostics");
        Configuration conf = new Configuration();
        conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 0.0f);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        String host = "host1";
        MockNM nm = rm.registerNode(String.format("%s:1234", "host1"), 2048);
        nm.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        dispatcher.await();
        String[] locations = new String[]{"host1"};
        allocator.sendRequest(this.createReq(jobId, 0, 1024, locations, false, true));
        for (int i = 0; i < 1; i += allocator.schedule().size()) {
            dispatcher.await();
            nm.nodeHeartbeat(true);
        }
        allocator.sendRequest(this.createReq(jobId, 0, 1024, locations, true, false));
        while (allocator.getTaskAttemptKillEvents().size() == 0) {
            dispatcher.await();
            allocator.schedule().size();
            nm.nodeHeartbeat(true);
        }
        String killEventMessage = allocator.getTaskAttemptKillEvents().get(0).getMessage();
        Assert.assertTrue((String)"No reducer rampDown preemption message", (boolean)killEventMessage.contains("Reducer preempted to make room for pending map attempts"));
    }

    @Test(timeout=30000L)
    public void testPreemptReducers() throws Exception {
        LOG.info((Object)"Running testPreemptReducers");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob, (Clock)new SystemClock());
        allocator.setMapResourceRequest(BuilderUtils.newResource((int)1024, (int)1));
        allocator.setReduceResourceRequest(BuilderUtils.newResource((int)1024, (int)1));
        RMContainerAllocator.AssignedRequests assignedRequests = allocator.getAssignedRequests();
        RMContainerAllocator.ScheduledRequests scheduledRequests = allocator.getScheduledRequests();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 2048, new String[]{"h1"}, false, false);
        scheduledRequests.maps.put(Mockito.mock(TaskAttemptId.class), new RMContainerRequestor.ContainerRequest(event1, null));
        assignedRequests.reduces.put(Mockito.mock(TaskAttemptId.class), Mockito.mock(Container.class));
        allocator.preemptReducesIfNeeded();
        Assert.assertEquals((String)"The reducer is not preempted", (long)1L, (long)assignedRequests.preemptionWaitingReduces.size());
    }

    @Test(timeout=30000L)
    public void testNonAggressivelyPreemptReducers() throws Exception {
        LOG.info((Object)"Running testNonAggressivelyPreemptReducers");
        int preemptThreshold = 2;
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.reducer.preempt.delay.sec", 2);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        ControlledClock clock = new ControlledClock(null);
        clock.setTime(1L);
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob, (Clock)clock);
        allocator.setMapResourceRequest(BuilderUtils.newResource((int)1024, (int)1));
        allocator.setReduceResourceRequest(BuilderUtils.newResource((int)1024, (int)1));
        RMContainerAllocator.AssignedRequests assignedRequests = allocator.getAssignedRequests();
        RMContainerAllocator.ScheduledRequests scheduledRequests = allocator.getScheduledRequests();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 2048, new String[]{"h1"}, false, false);
        scheduledRequests.maps.put(Mockito.mock(TaskAttemptId.class), new RMContainerRequestor.ContainerRequest(event1, null, clock.getTime()));
        assignedRequests.reduces.put(Mockito.mock(TaskAttemptId.class), Mockito.mock(Container.class));
        clock.setTime(clock.getTime() + 1L);
        allocator.preemptReducesIfNeeded();
        Assert.assertEquals((String)"The reducer is aggressively preeempted", (long)0L, (long)assignedRequests.preemptionWaitingReduces.size());
        clock.setTime(clock.getTime() + 2000L);
        allocator.preemptReducesIfNeeded();
        Assert.assertEquals((String)"The reducer is not preeempted", (long)1L, (long)assignedRequests.preemptionWaitingReduces.size());
    }

    @Test
    public void testMapReduceScheduling() throws Exception {
        LOG.info((Object)"Running testMapReduceScheduling");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 1024);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 2048, new String[]{"h1", "h2"}, true, false);
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 3000, new String[]{"h1"}, false, true);
        allocator.sendRequest(event2);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 2048, new String[]{"h3"}, false, false);
        allocator.sendRequest(event3);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        this.checkAssignments(new ContainerRequestEvent[]{event1, event3}, assigned, false);
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertFalse((String)"Assigned count not correct", (boolean)"h1".equals(assig.getContainer().getNodeId().getHost()));
        }
    }

    @Test
    public void testReportedAppProgress() throws Exception {
        LOG.info((Object)"Running testReportedAppProgress");
        Configuration conf = new Configuration();
        final MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher rmDispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp rmApp = rm.submitApp(1024);
        rmDispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 21504);
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        final ApplicationAttemptId appAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        rmDispatcher.await();
        MRApp mrApp = new MRApp(appAttemptId, ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L), 10, 10, false, this.getClass().getName(), true, 1){

            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }

            @Override
            protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
                return new MyContainerAllocator(rm, appAttemptId, context);
            }
        };
        Assert.assertEquals((double)0.0, (double)rmApp.getProgress(), (double)0.0);
        mrApp.submit(conf);
        Job job = (Job)mrApp.getContext().getAllJobs().entrySet().iterator().next().getValue();
        DrainDispatcher amDispatcher = (DrainDispatcher)mrApp.getDispatcher();
        MyContainerAllocator allocator = (MyContainerAllocator)mrApp.getContainerAllocator();
        mrApp.waitForInternalState((JobImpl)job, JobStateInternal.RUNNING);
        amDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.MAP) continue;
            mrApp.waitForInternalState((TaskAttemptImpl)t.getAttempts().values().iterator().next(), TaskAttemptStateInternal.UNASSIGNED);
        }
        amDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.MAP) continue;
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.05f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.05f, (float)rmApp.getProgress(), (float)0.001f);
        Iterator<Task> it = job.getTasks().values().iterator();
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 1);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.095f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.095f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 7);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.41f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.41f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 2);
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            if (t.getType() != TaskType.REDUCE) continue;
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 2);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.59f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.59f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 8);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.95f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.95f, (float)rmApp.getProgress(), (float)0.001f);
    }

    private void finishNextNTasks(DrainDispatcher rmDispatcher, MockNM node, MRApp mrApp, Iterator<Task> it, int nextN) throws Exception {
        for (int i = 0; i < nextN; ++i) {
            Task task = it.next();
            this.finishTask(rmDispatcher, node, mrApp, task);
        }
    }

    private void finishTask(DrainDispatcher rmDispatcher, MockNM node, MRApp mrApp, Task task) throws Exception {
        TaskAttempt attempt = (TaskAttempt)task.getAttempts().values().iterator().next();
        ArrayList<ContainerStatus> contStatus = new ArrayList<ContainerStatus>(1);
        contStatus.add(ContainerStatus.newInstance((ContainerId)attempt.getAssignedContainerID(), (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        HashMap<ApplicationId, ArrayList<ContainerStatus>> statusUpdate = new HashMap<ApplicationId, ArrayList<ContainerStatus>>(1);
        statusUpdate.put(mrApp.getAppID(), contStatus);
        node.nodeHeartbeat(statusUpdate, true);
        rmDispatcher.await();
        mrApp.getContext().getEventHandler().handle((Event)new TaskAttemptEvent(attempt.getID(), TaskAttemptEventType.TA_DONE));
        mrApp.waitForState(task, TaskState.SUCCEEDED);
    }

    @Test
    public void testReportedAppProgressWithOnlyMaps() throws Exception {
        LOG.info((Object)"Running testReportedAppProgressWithOnlyMaps");
        Configuration conf = new Configuration();
        final MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher rmDispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp rmApp = rm.submitApp(1024);
        rmDispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 11264);
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        final ApplicationAttemptId appAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        rmDispatcher.await();
        MRApp mrApp = new MRApp(appAttemptId, ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L), 10, 0, false, this.getClass().getName(), true, 1){

            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }

            @Override
            protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
                return new MyContainerAllocator(rm, appAttemptId, context);
            }
        };
        Assert.assertEquals((double)0.0, (double)rmApp.getProgress(), (double)0.0);
        mrApp.submit(conf);
        Job job = (Job)mrApp.getContext().getAllJobs().entrySet().iterator().next().getValue();
        DrainDispatcher amDispatcher = (DrainDispatcher)mrApp.getDispatcher();
        MyContainerAllocator allocator = (MyContainerAllocator)mrApp.getContainerAllocator();
        mrApp.waitForInternalState((JobImpl)job, JobStateInternal.RUNNING);
        amDispatcher.await();
        for (Task t : job.getTasks().values()) {
            mrApp.waitForInternalState((TaskAttemptImpl)t.getAttempts().values().iterator().next(), TaskAttemptStateInternal.UNASSIGNED);
        }
        amDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        allocator.schedule();
        rmDispatcher.await();
        for (Task t : job.getTasks().values()) {
            mrApp.waitForState(t, TaskState.RUNNING);
        }
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.05f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.05f, (float)rmApp.getProgress(), (float)0.001f);
        Iterator<Task> it = job.getTasks().values().iterator();
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 1);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.14f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.14f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 5);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.59f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.59f, (float)rmApp.getProgress(), (float)0.001f);
        this.finishNextNTasks(rmDispatcher, amNodeManager, mrApp, it, 4);
        allocator.schedule();
        rmDispatcher.await();
        Assert.assertEquals((float)0.95f, (float)job.getProgress(), (float)0.001f);
        Assert.assertEquals((float)0.95f, (float)rmApp.getProgress(), (float)0.001f);
    }

    @Test
    public void testUpdatedNodes() throws Exception {
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nm1 = rm.registerNode("h1:1234", 10240);
        MockNM nm2 = rm.registerNode("h2:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event);
        TaskAttemptId attemptId = event.getAttemptID();
        TaskAttempt mockTaskAttempt = (TaskAttempt)Mockito.mock(TaskAttempt.class);
        Mockito.when((Object)mockTaskAttempt.getNodeId()).thenReturn((Object)nm1.getNodeId());
        Task mockTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)mockTask.getAttempt(attemptId)).thenReturn((Object)mockTaskAttempt);
        Mockito.when((Object)mockJob.getTask(attemptId.getTaskId())).thenReturn((Object)mockTask);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        Assert.assertEquals((long)1L, (long)allocator.getJobUpdatedNodeEvents().size());
        Assert.assertEquals((long)3L, (long)allocator.getJobUpdatedNodeEvents().get(0).getUpdatedNodes().size());
        allocator.getJobUpdatedNodeEvents().clear();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((long)1L, (long)assigned.size());
        Assert.assertEquals((Object)nm1.getNodeId(), (Object)assigned.get(0).getContainer().getNodeId());
        Assert.assertTrue((boolean)allocator.getJobUpdatedNodeEvents().isEmpty());
        Assert.assertTrue((boolean)allocator.getTaskAttemptKillEvents().isEmpty());
        nm1.nodeHeartbeat(false);
        nm2.nodeHeartbeat(false);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((long)0L, (long)assigned.size());
        Assert.assertEquals((long)1L, (long)allocator.getJobUpdatedNodeEvents().size());
        Assert.assertEquals((long)1L, (long)allocator.getTaskAttemptKillEvents().size());
        Assert.assertEquals((long)2L, (long)allocator.getJobUpdatedNodeEvents().get(0).getUpdatedNodes().size());
        Assert.assertEquals((Object)attemptId, (Object)allocator.getTaskAttemptKillEvents().get(0).getTaskAttemptID());
        allocator.getJobUpdatedNodeEvents().clear();
        allocator.getTaskAttemptKillEvents().clear();
        assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((long)0L, (long)assigned.size());
        Assert.assertTrue((boolean)allocator.getJobUpdatedNodeEvents().isEmpty());
        Assert.assertTrue((boolean)allocator.getTaskAttemptKillEvents().isEmpty());
    }

    @Test
    public void testBlackListedNodes() throws Exception {
        LOG.info((Object)"Running testBlackListedNodes");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", -1);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager2 = rm.registerNode("h2:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 1024, new String[]{"h2"});
        allocator.sendRequest(event2);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h3"});
        allocator.sendRequest(event3);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        ContainerFailedEvent f2 = this.createFailEvent(jobId, 1, "h2", false);
        allocator.sendFailure(f2);
        nodeManager1.nodeHeartbeat(true);
        nodeManager2.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(2, 0, rm);
        nodeManager1.nodeHeartbeat(false);
        nodeManager2.nodeHeartbeat(false);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        Assert.assertTrue((String)"No of assignments must be 3", (assigned.size() == 3 ? 1 : 0) != 0);
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertTrue((String)"Assigned container host not correct", (boolean)"h3".equals(assig.getContainer().getNodeId().getHost()));
        }
    }

    @Test
    public void testIgnoreBlacklisting() throws Exception {
        LOG.info((Object)"Running testIgnoreBlacklisting");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", 33);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM[] nodeManagers = new MockNM[10];
        int nmNum = 0;
        List<TaskAttemptContainerAssignedEvent> assigned = null;
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        nodeManagers[0].nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        assigned = this.getContainerOnHost(jobId, 1, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        LOG.info((Object)"Failing container _1 on H1 (Node should be blacklisted and ignore blacklisting enabled");
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        assigned = this.getContainerOnHost(jobId, 2, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 1, 0, 0, 1, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        assigned = this.getContainerOnHost(jobId, 2, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 3, 1024, new String[]{"h2"}, nodeManagers[1], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 4, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        assigned = this.getContainerOnHost(jobId, 5, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 6, 1024, new String[]{"h4"}, nodeManagers[3], dispatcher, allocator, 0, 0, 1, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        assigned = this.getContainerOnHost(jobId, 7, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        ContainerFailedEvent f2 = this.createFailEvent(jobId, 3, "h2", false);
        allocator.sendFailure(f2);
        assigned = this.getContainerOnHost(jobId, 8, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 1, 0, 0, 2, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        assigned = this.getContainerOnHost(jobId, 8, 1024, new String[]{"h1"}, nodeManagers[0], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 2", (long)2L, (long)assigned.size());
        assigned = this.getContainerOnHost(jobId, 9, 1024, new String[]{"h2"}, nodeManagers[1], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        ContainerFailedEvent f3 = this.createFailEvent(jobId, 4, "h3", false);
        allocator.sendFailure(f3);
        nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
        assigned = this.getContainerOnHost(jobId, 10, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        for (int i = 0; i < 5; ++i) {
            nodeManagers[nmNum] = this.registerNodeManager(nmNum++, rm, dispatcher);
            assigned = this.getContainerOnHost(jobId, 11 + i, 1024, new String[]{String.valueOf(5 + i)}, nodeManagers[4 + i], dispatcher, allocator, 0, 0, i == 4 ? 3 : 0, 0, rm);
            Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        }
        assigned = this.getContainerOnHost(jobId, 20, 1024, new String[]{"h3"}, nodeManagers[2], dispatcher, allocator, 0, 0, 0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
    }

    private MockNM registerNodeManager(int i, MyResourceManager rm, DrainDispatcher dispatcher) throws Exception {
        MockNM nm = rm.registerNode("h" + (i + 1) + ":1234", 10240);
        dispatcher.await();
        return nm;
    }

    private List<TaskAttemptContainerAssignedEvent> getContainerOnHost(JobId jobId, int taskAttemptId, int memory, String[] hosts, MockNM mockNM, DrainDispatcher dispatcher, MyContainerAllocator allocator, int expectedAdditions1, int expectedRemovals1, int expectedAdditions2, int expectedRemovals2, MyResourceManager rm) throws Exception {
        ContainerRequestEvent reqEvent = this.createReq(jobId, taskAttemptId, memory, hosts);
        allocator.sendRequest(reqEvent);
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(expectedAdditions1, expectedRemovals1, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        mockNM.nodeHeartbeat(true);
        dispatcher.await();
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(expectedAdditions2, expectedRemovals2, rm);
        return assigned;
    }

    @Test
    public void testBlackListedNodesWithSchedulingToThatNode() throws Exception {
        LOG.info((Object)"Running testBlackListedNodesWithSchedulingToThatNode");
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", -1);
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm, conf, appAttemptId, mockJob);
        MockNM nodeManager1 = rm.registerNode("h1:1234", 10240);
        MockNM nodeManager3 = rm.registerNode("h3:1234", 10240);
        dispatcher.await();
        LOG.info((Object)"Requesting 1 Containers _1 on H1");
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        LOG.info((Object)"RM Heartbeat (to send the container requests)");
        List<TaskAttemptContainerAssignedEvent> assigned = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        LOG.info((Object)"h1 Heartbeat (To actually schedule the containers)");
        nodeManager1.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 1", (long)1L, (long)assigned.size());
        LOG.info((Object)"Failing container _1 on H1 (should blacklist the node)");
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h1", false);
        allocator.sendFailure(f1);
        ContainerRequestEvent event1f = this.createReq(jobId, 1, 1024, new String[]{"h1"}, true, false);
        allocator.sendRequest(event1f);
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(1, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1024, new String[]{"h1", "h3"});
        allocator.sendRequest(event3);
        LOG.info((Object)"h1 Heartbeat (To actually schedule the containers)");
        nodeManager1.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        LOG.info((Object)"RM Heartbeat (To process the re-scheduled containers)");
        assigned = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assigned.size());
        LOG.info((Object)"h3 Heartbeat (To re-schedule the containers)");
        nodeManager3.nodeHeartbeat(true);
        dispatcher.await();
        LOG.info((Object)"RM Heartbeat (To process the re-scheduled containers for H3)");
        assigned = allocator.schedule();
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm);
        dispatcher.await();
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            LOG.info((Object)(assig.getTaskAttemptID() + " assgined to " + assig.getContainer().getId() + " with priority " + assig.getContainer().getPriority()));
        }
        Assert.assertEquals((String)"No of assignments must be 2", (long)2L, (long)assigned.size());
        for (TaskAttemptContainerAssignedEvent assig : assigned) {
            Assert.assertEquals((String)("Assigned container " + assig.getContainer().getId() + " host not correct"), (Object)"h3", (Object)assig.getContainer().getNodeId().getHost());
        }
    }

    private static void assertBlacklistAdditionsAndRemovals(int expectedAdditions, int expectedRemovals, MyResourceManager rm) {
        Assert.assertEquals((long)expectedAdditions, (long)rm.getMyFifoScheduler().lastBlacklistAdditions.size());
        Assert.assertEquals((long)expectedRemovals, (long)rm.getMyFifoScheduler().lastBlacklistRemovals.size());
    }

    private static void assertAsksAndReleases(int expectedAsk, int expectedRelease, MyResourceManager rm) {
        Assert.assertEquals((long)expectedAsk, (long)rm.getMyFifoScheduler().lastAsk.size());
        Assert.assertEquals((long)expectedRelease, (long)rm.getMyFifoScheduler().lastRelease.size());
    }

    private ContainerRequestEvent createReq(JobId jobId, int taskAttemptId, int memory, String[] hosts) {
        return this.createReq(jobId, taskAttemptId, memory, hosts, false, false);
    }

    private ContainerRequestEvent createReq(JobId jobId, int taskAttemptId, int memory, String[] hosts, boolean earlierFailedAttempt, boolean reduce) {
        TaskId taskId = reduce ? MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.REDUCE) : MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)taskAttemptId);
        Resource containerNeed = Resource.newInstance((int)memory, (int)1);
        if (earlierFailedAttempt) {
            return ContainerRequestEvent.createContainerRequestEventForFailedContainer((TaskAttemptId)attemptId, (Resource)containerNeed);
        }
        return new ContainerRequestEvent(attemptId, containerNeed, hosts, new String[]{"/default-rack"});
    }

    private ContainerFailedEvent createFailEvent(JobId jobId, int taskAttemptId, String host, boolean reduce) {
        TaskId taskId = reduce ? MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.REDUCE) : MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)taskAttemptId);
        return new ContainerFailedEvent(attemptId, host);
    }

    private ContainerAllocatorEvent createDeallocateEvent(JobId jobId, int taskAttemptId, boolean reduce) {
        TaskId taskId = reduce ? MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.REDUCE) : MRBuilderUtils.newTaskId((JobId)jobId, (int)0, (TaskType)TaskType.MAP);
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)taskId, (int)taskAttemptId);
        return new ContainerAllocatorEvent(attemptId, ContainerAllocator.EventType.CONTAINER_DEALLOCATE);
    }

    private void checkAssignments(ContainerRequestEvent[] requests, List<TaskAttemptContainerAssignedEvent> assignments, boolean checkHostMatch) {
        Assert.assertNotNull((String)"Container not assigned", assignments);
        Assert.assertEquals((String)"Assigned count not correct", (long)requests.length, (long)assignments.size());
        HashSet<ContainerId> containerIds = new HashSet<ContainerId>();
        for (TaskAttemptContainerAssignedEvent assigned : assignments) {
            containerIds.add(assigned.getContainer().getId());
        }
        Assert.assertEquals((String)"Assigned containers must be different", (long)assignments.size(), (long)containerIds.size());
        for (ContainerRequestEvent req : requests) {
            TaskAttemptContainerAssignedEvent assigned = null;
            for (TaskAttemptContainerAssignedEvent ass : assignments) {
                if (!ass.getTaskAttemptID().equals((Object)req.getAttemptID())) continue;
                assigned = ass;
                break;
            }
            this.checkAssignment(req, assigned, checkHostMatch);
        }
    }

    private void checkAssignment(ContainerRequestEvent request, TaskAttemptContainerAssignedEvent assigned, boolean checkHostMatch) {
        Assert.assertNotNull((String)("Nothing assigned to attempt " + request.getAttemptID()), (Object)assigned);
        Assert.assertEquals((String)"assigned to wrong attempt", (Object)request.getAttemptID(), (Object)assigned.getTaskAttemptID());
        if (checkHostMatch) {
            Assert.assertTrue((String)"Not assigned to requested host", (boolean)Arrays.asList(request.getHosts()).contains(assigned.getContainer().getNodeId().getHost()));
        }
    }

    @Test
    public void testReduceScheduling() throws Exception {
        int totalMaps = 10;
        int succeededMaps = 1;
        int scheduledMaps = 10;
        int scheduledReduces = 0;
        int assignedMaps = 2;
        int assignedReduces = 0;
        Resource mapResourceReqt = BuilderUtils.newResource((int)1024, (int)1);
        Resource reduceResourceReqt = BuilderUtils.newResource((int)2048, (int)1);
        int numPendingReduces = 4;
        float maxReduceRampupLimit = 0.5f;
        float reduceSlowStart = 0.2f;
        RMContainerAllocator allocator = (RMContainerAllocator)Mockito.mock(RMContainerAllocator.class);
        ((RMContainerAllocator)Mockito.doCallRealMethod().when((Object)allocator)).scheduleReduces(Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), Matchers.anyInt(), (Resource)Matchers.any(Resource.class), (Resource)Matchers.any(Resource.class), Matchers.anyInt(), Matchers.anyFloat(), Matchers.anyFloat());
        ((RMContainerAllocator)Mockito.doReturn(EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY)).when((Object)allocator)).getSchedulerResourceTypes();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).setIsReduceStarted(true);
        allocator.scheduleReduces(totalMaps, succeededMaps, 0, scheduledReduces, totalMaps - succeededMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).setIsReduceStarted(true);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).scheduleAllReduces();
        succeededMaps = 3;
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)0, (int)0)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.times((int)1))).setIsReduceStarted(true);
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)102400, (int)100)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator)).rampUpReduces(Matchers.anyInt());
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.never())).rampDownReduces(Matchers.anyInt());
        scheduledReduces = 3;
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)10240, (int)10)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator)).rampDownReduces(Matchers.anyInt());
        scheduledMaps = 2;
        assignedReduces = 2;
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)10240, (int)10)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.times((int)2))).rampDownReduces(Matchers.anyInt());
        ((RMContainerAllocator)Mockito.doReturn(EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU)).when((Object)allocator)).getSchedulerResourceTypes();
        scheduledMaps = 10;
        assignedReduces = 0;
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)102400, (int)5)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.times((int)3))).rampDownReduces(Matchers.anyInt());
        ((RMContainerAllocator)Mockito.doReturn((Object)BuilderUtils.newResource((int)10240, (int)100)).when((Object)allocator)).getResourceLimit();
        allocator.scheduleReduces(totalMaps, succeededMaps, scheduledMaps, scheduledReduces, assignedMaps, assignedReduces, mapResourceReqt, reduceResourceReqt, numPendingReduces, maxReduceRampupLimit, reduceSlowStart);
        ((RMContainerAllocator)Mockito.verify((Object)allocator, (VerificationMode)Mockito.times((int)4))).rampDownReduces(Matchers.anyInt());
    }

    @Test
    public void testCompletedTasksRecalculateSchedule() throws Exception {
        LOG.info((Object)"Running testCompletedTasksRecalculateSchedule");
        Configuration conf = new Configuration();
        MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job job = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)job.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        ((Job)Mockito.doReturn((Object)10).when((Object)job)).getTotalMaps();
        ((Job)Mockito.doReturn((Object)10).when((Object)job)).getTotalReduces();
        ((Job)Mockito.doReturn((Object)0).when((Object)job)).getCompletedMaps();
        RecalculateContainerAllocator allocator = new RecalculateContainerAllocator(rm, conf, appAttemptId, job);
        allocator.schedule();
        allocator.recalculatedReduceSchedule = false;
        allocator.schedule();
        Assert.assertFalse((String)"Unexpected recalculate of reduce schedule", (boolean)allocator.recalculatedReduceSchedule);
        ((Job)Mockito.doReturn((Object)1).when((Object)job)).getCompletedMaps();
        allocator.schedule();
        Assert.assertTrue((String)"Expected recalculate of reduce schedule", (boolean)allocator.recalculatedReduceSchedule);
    }

    @Test
    public void testHeartbeatHandler() throws Exception {
        int timeToWaitMs;
        LOG.info((Object)"Running testHeartbeatHandler");
        Configuration conf = new Configuration();
        conf.setInt("yarn.app.mapreduce.am.scheduler.heartbeat.interval-ms", 1);
        ControlledClock clock = new ControlledClock((Clock)new SystemClock());
        AppContext appContext = (AppContext)Mockito.mock(AppContext.class);
        Mockito.when((Object)appContext.getClock()).thenReturn((Object)clock);
        Mockito.when((Object)appContext.getApplicationID()).thenReturn((Object)ApplicationId.newInstance((long)1L, (int)1));
        RMContainerAllocator allocator = new RMContainerAllocator((ClientService)Mockito.mock(ClientService.class), appContext){

            protected void register() {
            }

            protected ApplicationMasterProtocol createSchedulerProxy() {
                return (ApplicationMasterProtocol)Mockito.mock(ApplicationMasterProtocol.class);
            }

            protected synchronized void heartbeat() throws Exception {
            }
        };
        allocator.init(conf);
        allocator.start();
        clock.setTime(5L);
        for (timeToWaitMs = 5000; allocator.getLastHeartbeatTime() != 5L && timeToWaitMs > 0; timeToWaitMs -= 10) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)5L, (long)allocator.getLastHeartbeatTime());
        clock.setTime(7L);
        for (timeToWaitMs = 5000; allocator.getLastHeartbeatTime() != 7L && timeToWaitMs > 0; timeToWaitMs -= 10) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)7L, (long)allocator.getLastHeartbeatTime());
        final AtomicBoolean callbackCalled = new AtomicBoolean(false);
        allocator.runOnNextHeartbeat(new Runnable(){

            @Override
            public void run() {
                callbackCalled.set(true);
            }
        });
        clock.setTime(8L);
        for (timeToWaitMs = 5000; allocator.getLastHeartbeatTime() != 8L && timeToWaitMs > 0; timeToWaitMs -= 10) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)8L, (long)allocator.getLastHeartbeatTime());
        Assert.assertTrue((boolean)callbackCalled.get());
    }

    @Test
    public void testCompletedContainerEvent() {
        RMContainerAllocator allocator = new RMContainerAllocator((ClientService)Mockito.mock(ClientService.class), (AppContext)Mockito.mock(AppContext.class));
        TaskAttemptId attemptId = MRBuilderUtils.newTaskAttemptId((TaskId)MRBuilderUtils.newTaskId((JobId)MRBuilderUtils.newJobId((long)1L, (int)1, (int)1), (int)1, (TaskType)TaskType.MAP), (int)1);
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)1L);
        ContainerStatus status = ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        ContainerStatus abortedStatus = ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.RUNNING, (String)"", (int)-100);
        TaskAttemptEvent event = allocator.createContainerFinishedEvent(status, attemptId);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (Object)event.getType());
        TaskAttemptEvent abortedEvent = allocator.createContainerFinishedEvent(abortedStatus, attemptId);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_KILL, (Object)abortedEvent.getType());
        ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)2L);
        ContainerStatus status2 = ContainerStatus.newInstance((ContainerId)containerId2, (ContainerState)ContainerState.RUNNING, (String)"", (int)0);
        ContainerStatus preemptedStatus = ContainerStatus.newInstance((ContainerId)containerId2, (ContainerState)ContainerState.RUNNING, (String)"", (int)-102);
        TaskAttemptEvent event2 = allocator.createContainerFinishedEvent(status2, attemptId);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_CONTAINER_COMPLETED, (Object)event2.getType());
        TaskAttemptEvent abortedEvent2 = allocator.createContainerFinishedEvent(preemptedStatus, attemptId);
        Assert.assertEquals((Object)TaskAttemptEventType.TA_KILL, (Object)abortedEvent2.getType());
    }

    @Test
    public void testUnregistrationOnlyIfRegistered() throws Exception {
        Configuration conf = new Configuration();
        final MyResourceManager rm = new MyResourceManager(conf);
        rm.start();
        DrainDispatcher rmDispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp rmApp = rm.submitApp(1024);
        rmDispatcher.await();
        MockNM amNodeManager = rm.registerNode("127.0.0.1:1234", 11264);
        amNodeManager.nodeHeartbeat(true);
        rmDispatcher.await();
        final ApplicationAttemptId appAttemptId = rmApp.getCurrentAppAttempt().getAppAttemptId();
        rm.sendAMLaunched(appAttemptId);
        rmDispatcher.await();
        MRApp mrApp = new MRApp(appAttemptId, ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)0L), 10, 0, false, this.getClass().getName(), true, 1){

            protected Dispatcher createDispatcher() {
                return new DrainDispatcher();
            }

            @Override
            protected ContainerAllocator createContainerAllocator(ClientService clientService, AppContext context) {
                return new MyContainerAllocator(rm, appAttemptId, context);
            }
        };
        mrApp.submit(conf);
        DrainDispatcher amDispatcher = (DrainDispatcher)mrApp.getDispatcher();
        MyContainerAllocator allocator = (MyContainerAllocator)mrApp.getContainerAllocator();
        amDispatcher.await();
        Assert.assertTrue((boolean)allocator.isApplicationMasterRegistered());
        mrApp.stop();
        Assert.assertTrue((boolean)allocator.isUnregistered());
    }

    @Test
    public void testRMContainerAllocatorResendsRequestsOnRMRestart() throws Exception {
        Configuration conf = new Configuration();
        conf.set("yarn.resourcemanager.recovery.enabled", "true");
        conf.set("yarn.resourcemanager.store.class", MemoryRMStateStore.class.getName());
        conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
        conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        conf.setLong("yarn.resourcemanager.work-preserving-recovery.scheduling-wait-ms", 0L);
        conf.setBoolean("yarn.app.mapreduce.am.job.node-blacklisting.enable", true);
        conf.setInt("mapreduce.job.maxtaskfailures.per.tracker", 1);
        conf.setInt("yarn.app.mapreduce.am.job.node-blacklisting.ignore-threshold-node-percent", -1);
        MemoryRMStateStore memStore = new MemoryRMStateStore();
        memStore.init(conf);
        MyResourceManager rm1 = new MyResourceManager(conf, (RMStateStore)memStore);
        rm1.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm1.getRMContext().getDispatcher();
        RMApp app = rm1.submitApp(1024);
        dispatcher.await();
        MockNM nm1 = new MockNM("h1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm1.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator allocator = new MyContainerAllocator(rm1, conf, appAttemptId, mockJob);
        ContainerRequestEvent event1 = this.createReq(jobId, 1, 1024, new String[]{"h1"});
        allocator.sendRequest(event1);
        ContainerRequestEvent event2 = this.createReq(jobId, 2, 2048, new String[]{"h1", "h2"});
        allocator.sendRequest(event2);
        ContainerFailedEvent f1 = this.createFailEvent(jobId, 1, "h2", false);
        allocator.sendFailure(f1);
        List<TaskAttemptContainerAssignedEvent> assignedContainers = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assignedContainers.size());
        TestRMContainerAllocator.assertAsksAndReleases(3, 0, rm1);
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(1, 0, rm1);
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        assignedContainers = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"No of assignments must be 2", (long)2L, (long)assignedContainers.size());
        TestRMContainerAllocator.assertAsksAndReleases(0, 0, rm1);
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm1);
        assignedContainers = allocator.schedule();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assignedContainers.size());
        TestRMContainerAllocator.assertAsksAndReleases(3, 0, rm1);
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm1);
        ContainerRequestEvent event3 = this.createReq(jobId, 3, 1000, new String[]{"h1"});
        allocator.sendRequest(event3);
        ContainerAllocatorEvent deallocate1 = this.createDeallocateEvent(jobId, 1, false);
        allocator.sendDeallocate(deallocate1);
        assignedContainers = allocator.schedule();
        Assert.assertEquals((String)"No of assignments must be 0", (long)0L, (long)assignedContainers.size());
        TestRMContainerAllocator.assertAsksAndReleases(3, 1, rm1);
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(0, 0, rm1);
        MyResourceManager rm2 = new MyResourceManager(conf, (RMStateStore)memStore);
        rm2.start();
        nm1.setResourceTrackerService(rm2.getResourceTrackerService());
        allocator.updateSchedulerProxy(rm2);
        dispatcher = (DrainDispatcher)rm2.getRMContext().getDispatcher();
        NodeHeartbeatResponse hbResponse = nm1.nodeHeartbeat(true);
        Assert.assertEquals((Object)NodeAction.RESYNC, (Object)hbResponse.getNodeAction());
        nm1 = new MockNM("h1:1234", 10240, rm2.getResourceTrackerService());
        nm1.registerNode();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        ContainerAllocatorEvent deallocate2 = this.createDeallocateEvent(jobId, 2, false);
        allocator.sendDeallocate(deallocate2);
        ContainerFailedEvent f2 = this.createFailEvent(jobId, 1, "h3", false);
        allocator.sendFailure(f2);
        ContainerRequestEvent event4 = this.createReq(jobId, 4, 2000, new String[]{"h1", "h2"});
        allocator.sendRequest(event4);
        allocator.schedule();
        dispatcher.await();
        ContainerRequestEvent event5 = this.createReq(jobId, 5, 3000, new String[]{"h1", "h2", "h3"});
        allocator.sendRequest(event5);
        assignedContainers = allocator.schedule();
        dispatcher.await();
        TestRMContainerAllocator.assertAsksAndReleases(3, 2, rm2);
        TestRMContainerAllocator.assertBlacklistAdditionsAndRemovals(2, 0, rm2);
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        assignedContainers = allocator.schedule();
        dispatcher.await();
        Assert.assertEquals((String)"Number of container should be 3", (long)3L, (long)assignedContainers.size());
        for (TaskAttemptContainerAssignedEvent assig : assignedContainers) {
            Assert.assertTrue((String)"Assigned count not correct", (boolean)"h1".equals(assig.getContainer().getNodeId().getHost()));
        }
        rm1.stop();
        rm2.stop();
    }

    @Test
    public void testRMUnavailable() throws Exception {
        Configuration conf = new Configuration();
        conf.setInt("yarn.app.mapreduce.am.scheduler.connection.wait.interval-ms", 0);
        MyResourceManager rm1 = new MyResourceManager(conf);
        rm1.start();
        DrainDispatcher dispatcher = (DrainDispatcher)rm1.getRMContext().getDispatcher();
        RMApp app = rm1.submitApp(1024);
        dispatcher.await();
        MockNM nm1 = new MockNM("h1:1234", 15120, rm1.getResourceTrackerService());
        nm1.registerNode();
        nm1.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        rm1.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        MyContainerAllocator2 allocator = new MyContainerAllocator2(rm1, conf, appAttemptId, mockJob);
        MyContainerAllocator2.jobEvents.clear();
        try {
            allocator.schedule();
            Assert.fail((String)"Should Have Exception");
        }
        catch (YarnRuntimeException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Could not contact RM after"));
        }
        dispatcher.await();
        Assert.assertEquals((String)"Should Have 1 Job Event", (long)1L, (long)MyContainerAllocator2.jobEvents.size());
        JobEvent event = (JobEvent)MyContainerAllocator2.jobEvents.get(0);
        Assert.assertTrue((String)"Should Reboot", (boolean)((JobEventType)event.getType()).equals((Object)JobEventType.JOB_AM_REBOOT));
    }

    @Test(timeout=60000L)
    public void testAMRMTokenUpdate() throws Exception {
        LOG.info((Object)"Running testAMRMTokenUpdate");
        String rmAddr = "somermaddress:1234";
        YarnConfiguration conf = new YarnConfiguration();
        conf.setLong("yarn.resourcemanager.am-rm-tokens.master-key-rolling-interval-secs", 8L);
        conf.setLong("yarn.am.liveness-monitor.expiry-interval-ms", 2000L);
        conf.set("yarn.resourcemanager.scheduler.address", "somermaddress:1234");
        final MyResourceManager rm = new MyResourceManager((Configuration)conf);
        rm.start();
        AMRMTokenSecretManager secretMgr = rm.getRMContext().getAMRMTokenSecretManager();
        DrainDispatcher dispatcher = (DrainDispatcher)rm.getRMContext().getDispatcher();
        RMApp app = rm.submitApp(1024);
        dispatcher.await();
        MockNM amNodeManager = rm.registerNode("amNM:1234", 2048);
        amNodeManager.nodeHeartbeat(true);
        dispatcher.await();
        ApplicationAttemptId appAttemptId = app.getCurrentAppAttempt().getAppAttemptId();
        ApplicationId appId = app.getApplicationId();
        rm.sendAMLaunched(appAttemptId);
        dispatcher.await();
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        Token oldToken = ((RMApp)rm.getRMContext().getRMApps().get(appId)).getRMAppAttempt(appAttemptId).getAMRMToken();
        Assert.assertNotNull((String)"app should have a token", (Object)oldToken);
        UserGroupInformation testUgi = UserGroupInformation.createUserForTesting((String)"someuser", (String[])new String[0]);
        Token newToken = (Token)testUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Token<AMRMTokenIdentifier>>((Configuration)conf, appAttemptId, mockJob, oldToken, appId){
            final /* synthetic */ Configuration val$conf;
            final /* synthetic */ ApplicationAttemptId val$appAttemptId;
            final /* synthetic */ Job val$mockJob;
            final /* synthetic */ Token val$oldToken;
            final /* synthetic */ ApplicationId val$appId;
            {
                this.val$conf = configuration;
                this.val$appAttemptId = applicationAttemptId;
                this.val$mockJob = job;
                this.val$oldToken = token;
                this.val$appId = applicationId;
            }

            @Override
            public Token<AMRMTokenIdentifier> run() throws Exception {
                MyContainerAllocator allocator = new MyContainerAllocator(rm, this.val$conf, this.val$appAttemptId, this.val$mockJob);
                Token currentToken = this.val$oldToken;
                long startTime = Time.monotonicNow();
                while (currentToken == this.val$oldToken) {
                    if (Time.monotonicNow() - startTime > 20000L) {
                        Assert.fail((String)"Took to long to see AMRM token change");
                    }
                    Thread.sleep(100L);
                    allocator.schedule();
                    currentToken = ((RMApp)rm.getRMContext().getRMApps().get(this.val$appId)).getRMAppAttempt(this.val$appAttemptId).getAMRMToken();
                }
                return currentToken;
            }
        });
        int tokenCount = 0;
        Token ugiToken = null;
        for (Token token : testUgi.getTokens()) {
            if (!AMRMTokenIdentifier.KIND_NAME.equals((Object)token.getKind())) continue;
            ugiToken = token;
            ++tokenCount;
        }
        Assert.assertEquals((String)"too many AMRM tokens", (long)1L, (long)tokenCount);
        Assert.assertArrayEquals((String)"token identifier not updated", (byte[])newToken.getIdentifier(), (byte[])ugiToken.getIdentifier());
        Assert.assertArrayEquals((String)"token password not updated", (byte[])newToken.getPassword(), (byte[])ugiToken.getPassword());
        Assert.assertEquals((String)"AMRM token service not updated", (Object)new Text("somermaddress:1234"), (Object)ugiToken.getService());
    }

    @Test
    public void testConcurrentTaskLimits() throws Exception {
        int MAP_LIMIT = 3;
        boolean REDUCE_LIMIT = true;
        LOG.info((Object)"Running testConcurrentTaskLimits");
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.job.running.map.limit", 3);
        conf.setInt("mapreduce.job.running.reduce.limit", 1);
        conf.setFloat("mapreduce.job.reduce.slowstart.completedmaps", 1.0f);
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        JobId jobId = MRBuilderUtils.newJobId((ApplicationId)appAttemptId.getApplicationId(), (int)0);
        Job mockJob = (Job)Mockito.mock(Job.class);
        Mockito.when((Object)mockJob.getReport()).thenReturn((Object)MRBuilderUtils.newJobReport((JobId)jobId, (String)"job", (String)"user", (JobState)JobState.RUNNING, (long)0L, (long)0L, (long)0L, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (String)"jobfile", null, (boolean)false, (String)""));
        final MockScheduler mockScheduler = new MockScheduler(appAttemptId);
        MyContainerAllocator allocator = new MyContainerAllocator(null, conf, appAttemptId, mockJob){

            @Override
            protected void register() {
            }

            @Override
            protected ApplicationMasterProtocol createSchedulerProxy() {
                return mockScheduler;
            }
        };
        ContainerRequestEvent[] reqMapEvents = new ContainerRequestEvent[5];
        for (int i = 0; i < reqMapEvents.length; ++i) {
            reqMapEvents[i] = this.createReq(jobId, i, 1024, new String[]{"h" + i});
        }
        allocator.sendRequests(Arrays.asList(reqMapEvents));
        ContainerRequestEvent[] reqReduceEvents = new ContainerRequestEvent[2];
        for (int i = 0; i < reqReduceEvents.length; ++i) {
            reqReduceEvents[i] = this.createReq(jobId, i, 1024, new String[0], false, true);
        }
        allocator.sendRequests(Arrays.asList(reqReduceEvents));
        allocator.schedule();
        Assert.assertEquals((long)(reqMapEvents.length + 2), (long)mockScheduler.lastAsk.size());
        Assert.assertEquals((long)3L, (long)mockScheduler.lastAnyAskMap);
        ContainerId cid0 = mockScheduler.assignContainer("h0", false);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)2L, (long)mockScheduler.lastAnyAskMap);
        mockScheduler.completeContainer(cid0);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)3L, (long)mockScheduler.lastAnyAskMap);
        ContainerId cid1 = mockScheduler.assignContainer("h1", false);
        ContainerId cid2 = mockScheduler.assignContainer("h2", false);
        ContainerId cid3 = mockScheduler.assignContainer("h3", false);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskMap);
        mockScheduler.completeContainer(cid2);
        mockScheduler.completeContainer(cid3);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)1L, (long)mockScheduler.lastAnyAskMap);
        mockScheduler.completeContainer(cid1);
        ContainerId cid4 = mockScheduler.assignContainer("h4", false);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskMap);
        mockScheduler.completeContainer(cid4);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskMap);
        Assert.assertEquals((long)1L, (long)mockScheduler.lastAnyAskReduce);
        cid0 = mockScheduler.assignContainer("h0", true);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskReduce);
        mockScheduler.completeContainer(cid0);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)1L, (long)mockScheduler.lastAnyAskReduce);
        cid0 = mockScheduler.assignContainer("h0", true);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskReduce);
        mockScheduler.completeContainer(cid0);
        allocator.schedule();
        allocator.schedule();
        Assert.assertEquals((long)0L, (long)mockScheduler.lastAnyAskReduce);
        allocator.close();
    }

    public static void main(String[] args) throws Exception {
        TestRMContainerAllocator t = new TestRMContainerAllocator();
        t.testSimple();
        t.testResource();
        t.testMapReduceScheduling();
        t.testReportedAppProgress();
        t.testReportedAppProgressWithOnlyMaps();
        t.testBlackListedNodes();
        t.testCompletedTasksRecalculateSchedule();
        t.testAMRMTokenUpdate();
    }

    private static class MockScheduler
    implements ApplicationMasterProtocol {
        ApplicationAttemptId attemptId;
        long nextContainerId = 10L;
        List<ResourceRequest> lastAsk = null;
        int lastAnyAskMap = 0;
        int lastAnyAskReduce = 0;
        List<ContainerStatus> containersToComplete = new ArrayList<ContainerStatus>();
        List<Container> containersToAllocate = new ArrayList<Container>();

        public MockScheduler(ApplicationAttemptId attemptId) {
            this.attemptId = attemptId;
        }

        public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
            return RegisterApplicationMasterResponse.newInstance((Resource)Resource.newInstance((int)512, (int)1), (Resource)Resource.newInstance((int)512000, (int)1024), Collections.emptyMap(), (ByteBuffer)ByteBuffer.wrap("fake_key".getBytes()), Collections.emptyList(), (String)"default", Collections.emptyList());
        }

        public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
            return FinishApplicationMasterResponse.newInstance((boolean)false);
        }

        public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
            this.lastAsk = request.getAskList();
            for (ResourceRequest req : this.lastAsk) {
                if (!"*".equals(req.getResourceName())) continue;
                Priority priority = req.getPriority();
                if (priority.equals((Object)RMContainerAllocator.PRIORITY_MAP)) {
                    this.lastAnyAskMap = req.getNumContainers();
                    continue;
                }
                if (!priority.equals((Object)RMContainerAllocator.PRIORITY_REDUCE)) continue;
                this.lastAnyAskReduce = req.getNumContainers();
            }
            AllocateResponse response = AllocateResponse.newInstance((int)request.getResponseId(), this.containersToComplete, this.containersToAllocate, Collections.emptyList(), (Resource)Resource.newInstance((int)512000, (int)1024), null, (int)10, null, Collections.emptyList());
            this.containersToComplete.clear();
            this.containersToAllocate.clear();
            return response;
        }

        public ContainerId assignContainer(String nodeName, boolean isReduce) {
            ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)this.attemptId, (long)this.nextContainerId++);
            Priority priority = isReduce ? RMContainerAllocator.PRIORITY_REDUCE : RMContainerAllocator.PRIORITY_MAP;
            Container container = Container.newInstance((ContainerId)containerId, (NodeId)NodeId.newInstance((String)nodeName, (int)1234), (String)(nodeName + ":5678"), (Resource)Resource.newInstance((int)1024, (int)1), (Priority)priority, null);
            this.containersToAllocate.add(container);
            return containerId;
        }

        public void completeContainer(ContainerId containerId) {
            this.containersToComplete.add(ContainerStatus.newInstance((ContainerId)containerId, (ContainerState)ContainerState.COMPLETE, (String)"", (int)0));
        }
    }

    private static class RecalculateContainerAllocator
    extends MyContainerAllocator {
        public boolean recalculatedReduceSchedule = false;

        public RecalculateContainerAllocator(MyResourceManager rm, Configuration conf, ApplicationAttemptId appAttemptId, Job job) {
            super(rm, conf, appAttemptId, job);
        }

        public void scheduleReduces(int totalMaps, int completedMaps, int scheduledMaps, int scheduledReduces, int assignedMaps, int assignedReduces, Resource mapResourceReqt, Resource reduceResourceReqt, int numPendingReduces, float maxReduceRampupLimit, float reduceSlowStart) {
            this.recalculatedReduceSchedule = true;
        }
    }

    private static class MyContainerAllocator2
    extends MyContainerAllocator {
        public MyContainerAllocator2(MyResourceManager rm, Configuration conf, ApplicationAttemptId appAttemptId, Job job) {
            super(rm, conf, appAttemptId, job);
        }

        @Override
        protected AllocateResponse makeRemoteRequest() throws IOException, YarnException {
            throw new YarnRuntimeException("for testing");
        }
    }

    private static class MyContainerAllocator
    extends RMContainerAllocator {
        static final List<TaskAttemptContainerAssignedEvent> events = new ArrayList<TaskAttemptContainerAssignedEvent>();
        static final List<TaskAttemptKillEvent> taskAttemptKillEvents = new ArrayList<TaskAttemptKillEvent>();
        static final List<JobUpdatedNodesEvent> jobUpdatedNodeEvents = new ArrayList<JobUpdatedNodesEvent>();
        static final List<JobEvent> jobEvents = new ArrayList<JobEvent>();
        private MyResourceManager rm;
        private boolean isUnregistered = false;
        private AllocateResponse allocateResponse;

        private static AppContext createAppContext(ApplicationAttemptId appAttemptId, Job job) {
            AppContext context = (AppContext)Mockito.mock(AppContext.class);
            ApplicationId appId = appAttemptId.getApplicationId();
            Mockito.when((Object)context.getApplicationID()).thenReturn((Object)appId);
            Mockito.when((Object)context.getApplicationAttemptId()).thenReturn((Object)appAttemptId);
            Mockito.when((Object)context.getJob((JobId)Matchers.isA(JobId.class))).thenReturn((Object)job);
            Mockito.when((Object)context.getClusterInfo()).thenReturn((Object)new ClusterInfo(Resource.newInstance((int)10240, (int)1)));
            Mockito.when((Object)context.getEventHandler()).thenReturn((Object)new EventHandler(){

                public void handle(Event event) {
                    if (event instanceof TaskAttemptContainerAssignedEvent) {
                        events.add((TaskAttemptContainerAssignedEvent)event);
                    } else if (event instanceof TaskAttemptKillEvent) {
                        taskAttemptKillEvents.add((TaskAttemptKillEvent)event);
                    } else if (event instanceof JobUpdatedNodesEvent) {
                        jobUpdatedNodeEvents.add((JobUpdatedNodesEvent)event);
                    } else if (event instanceof JobEvent) {
                        jobEvents.add((JobEvent)event);
                    }
                }
            });
            return context;
        }

        private static AppContext createAppContext(ApplicationAttemptId appAttemptId, Job job, Clock clock) {
            AppContext context = MyContainerAllocator.createAppContext(appAttemptId, job);
            Mockito.when((Object)context.getClock()).thenReturn((Object)clock);
            return context;
        }

        private static ClientService createMockClientService() {
            ClientService service = (ClientService)Mockito.mock(ClientService.class);
            Mockito.when((Object)service.getBindAddress()).thenReturn((Object)NetUtils.createSocketAddr((String)"localhost:4567"));
            Mockito.when((Object)service.getHttpPort()).thenReturn((Object)890);
            return service;
        }

        MyContainerAllocator(MyResourceManager rm, ApplicationAttemptId appAttemptId, AppContext context) {
            super(MyContainerAllocator.createMockClientService(), context);
            this.rm = rm;
        }

        public MyContainerAllocator(MyResourceManager rm, Configuration conf, ApplicationAttemptId appAttemptId, Job job) {
            super(MyContainerAllocator.createMockClientService(), MyContainerAllocator.createAppContext(appAttemptId, job));
            this.rm = rm;
            super.init(conf);
            super.start();
        }

        public MyContainerAllocator(MyResourceManager rm, Configuration conf, ApplicationAttemptId appAttemptId, Job job, Clock clock) {
            super(MyContainerAllocator.createMockClientService(), MyContainerAllocator.createAppContext(appAttemptId, job, clock));
            this.rm = rm;
            super.init(conf);
            super.start();
        }

        protected ApplicationMasterProtocol createSchedulerProxy() {
            return this.rm.getApplicationMasterService();
        }

        protected void register() {
            ApplicationAttemptId attemptId = this.getContext().getApplicationAttemptId();
            Token token = ((RMApp)this.rm.getRMContext().getRMApps().get(attemptId.getApplicationId())).getRMAppAttempt(attemptId).getAMRMToken();
            try {
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                ugi.addTokenIdentifier(token.decodeIdentifier());
            }
            catch (IOException e) {
                throw new YarnRuntimeException((Throwable)e);
            }
            super.register();
        }

        protected void unregister() {
            this.isUnregistered = true;
        }

        protected Resource getMaxContainerCapability() {
            return Resource.newInstance((int)10240, (int)1);
        }

        public void sendRequest(ContainerRequestEvent req) {
            this.sendRequests(Arrays.asList(req));
        }

        public void sendRequests(List<ContainerRequestEvent> reqs) {
            for (ContainerRequestEvent req : reqs) {
                super.handleEvent((ContainerAllocatorEvent)req);
            }
        }

        public void sendFailure(ContainerFailedEvent f) {
            super.handleEvent((ContainerAllocatorEvent)f);
        }

        public void sendDeallocate(ContainerAllocatorEvent f) {
            super.handleEvent(f);
        }

        public List<TaskAttemptContainerAssignedEvent> schedule() throws Exception {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return MyContainerAllocator.this.eventQueue.isEmpty();
                }
            }, (int)100, (int)10000);
            try {
                super.heartbeat();
            }
            catch (Exception e) {
                LOG.error((Object)"error in heartbeat ", (Throwable)e);
                throw new YarnRuntimeException((Throwable)e);
            }
            ArrayList<TaskAttemptContainerAssignedEvent> result = new ArrayList<TaskAttemptContainerAssignedEvent>(events);
            events.clear();
            return result;
        }

        static List<TaskAttemptKillEvent> getTaskAttemptKillEvents() {
            return taskAttemptKillEvents;
        }

        static List<JobUpdatedNodesEvent> getJobUpdatedNodeEvents() {
            return jobUpdatedNodeEvents;
        }

        protected void startAllocatorThread() {
        }

        protected boolean isApplicationMasterRegistered() {
            return super.isApplicationMasterRegistered();
        }

        public boolean isUnregistered() {
            return this.isUnregistered;
        }

        public void updateSchedulerProxy(MyResourceManager rm) {
            this.scheduler = rm.getApplicationMasterService();
        }

        protected AllocateResponse makeRemoteRequest() throws IOException, YarnException {
            this.allocateResponse = super.makeRemoteRequest();
            return this.allocateResponse;
        }
    }

    private static class MyFifoScheduler
    extends FifoScheduler {
        List<ResourceRequest> lastAsk;
        List<ContainerId> lastRelease;
        List<String> lastBlacklistAdditions;
        List<String> lastBlacklistRemovals;

        public MyFifoScheduler(RMContext rmContext) {
            block2: {
                this.lastAsk = null;
                this.lastRelease = null;
                try {
                    Configuration conf = new Configuration();
                    this.reinitialize(conf, rmContext);
                }
                catch (IOException ie) {
                    LOG.info((Object)"add application failed with ", (Throwable)ie);
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        public synchronized Allocation allocate(ApplicationAttemptId applicationAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
            ArrayList<ResourceRequest> askCopy = new ArrayList<ResourceRequest>();
            for (ResourceRequest req : ask) {
                ResourceRequest reqCopy = ResourceRequest.newInstance((Priority)req.getPriority(), (String)req.getResourceName(), (Resource)req.getCapability(), (int)req.getNumContainers(), (boolean)req.getRelaxLocality());
                askCopy.add(reqCopy);
            }
            this.lastAsk = ask;
            this.lastRelease = release;
            this.lastBlacklistAdditions = blacklistAdditions;
            this.lastBlacklistRemovals = blacklistRemovals;
            return super.allocate(applicationAttemptId, askCopy, release, blacklistAdditions, blacklistRemovals);
        }
    }

    private static class MyResourceManager
    extends MockRM {
        private static long fakeClusterTimeStamp = System.currentTimeMillis();

        public MyResourceManager(Configuration conf) {
            super(conf);
        }

        public MyResourceManager(Configuration conf, RMStateStore store) {
            super(conf, store);
        }

        public void serviceStart() throws Exception {
            super.serviceStart();
            MyResourceManager.setClusterTimeStamp((long)fakeClusterTimeStamp);
        }

        protected Dispatcher createDispatcher() {
            return new DrainDispatcher();
        }

        protected EventHandler<SchedulerEvent> createSchedulerEventDispatcher() {
            return new EventHandler<SchedulerEvent>(){

                public void handle(SchedulerEvent event) {
                    MyResourceManager.this.scheduler.handle((Event)event);
                }
            };
        }

        protected ResourceScheduler createScheduler() {
            return new MyFifoScheduler(this.getRMContext());
        }

        MyFifoScheduler getMyFifoScheduler() {
            return (MyFifoScheduler)this.scheduler;
        }
    }
}

