/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.EnumSet;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceCalculatorUtils {
    private static final double ZERO_LIMIT = 0.0099999999999999;

    public static int divideAndCeil(int a, int b) {
        if (b == 0) {
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    private static boolean isZero(double a) {
        return !(Math.abs(a) > 0.0099999999999999);
    }

    public static double divideAndCeil(double a, double b) {
        if (ResourceCalculatorUtils.isZero((double)b)) {
            return 0.0;
        }
        return a / b;
    }

    public static int computeAvailableContainers(Resource available, Resource required, EnumSet<YarnServiceProtos.SchedulerResourceTypes> resourceTypes) {
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU) && resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.DISK)) {
            return (int)Math.min((double)Math.min(ResourceCalculatorUtils.calculateRatioOrMaxValue((int)available.getMemory(), (int)required.getMemory()), ResourceCalculatorUtils.calculateRatioOrMaxValue((int)available.getVirtualCores(), (int)required.getVirtualCores())), ResourceCalculatorUtils.calculateRatioOrMaxValue((double)available.getDisks(), (double)required.getDisks()));
        }
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU)) {
            return Math.min(ResourceCalculatorUtils.calculateRatioOrMaxValue((int)available.getMemory(), (int)required.getMemory()), ResourceCalculatorUtils.calculateRatioOrMaxValue((int)available.getVirtualCores(), (int)required.getVirtualCores()));
        }
        return ResourceCalculatorUtils.calculateRatioOrMaxValue((int)available.getMemory(), (int)required.getMemory());
    }

    public static int divideAndCeilContainers(Resource required, Resource factor, EnumSet<YarnServiceProtos.SchedulerResourceTypes> resourceTypes) {
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU) && resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.DISK)) {
            return (int)Math.max((double)Math.max(ResourceCalculatorUtils.divideAndCeil((int)required.getMemory(), (int)factor.getMemory()), ResourceCalculatorUtils.divideAndCeil((int)required.getVirtualCores(), (int)factor.getVirtualCores())), ResourceCalculatorUtils.divideAndCeil((double)required.getDisks(), (double)factor.getDisks()));
        }
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU)) {
            return Math.max(ResourceCalculatorUtils.divideAndCeil((int)required.getMemory(), (int)factor.getMemory()), ResourceCalculatorUtils.divideAndCeil((int)required.getVirtualCores(), (int)factor.getVirtualCores()));
        }
        return ResourceCalculatorUtils.divideAndCeil((int)required.getMemory(), (int)factor.getMemory());
    }

    private static int calculateRatioOrMaxValue(int numerator, int denominator) {
        if (denominator == 0) {
            return Integer.MAX_VALUE;
        }
        return numerator / denominator;
    }

    private static double calculateRatioOrMaxValue(double numerator, double denominator) {
        if (denominator == 0.0) {
            return 2.147483647E9;
        }
        return numerator / denominator;
    }
}

