/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.job.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Task;
import org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.TaskCounter;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.split.JobSplit;
import org.apache.hadoop.mapreduce.v2.api.records.Avataar;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.TaskAttemptListener;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.app.job.TaskStateInternal;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEvent;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskEventType;
import org.apache.hadoop.mapreduce.v2.app.job.event.TaskTAttemptEvent;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskAttemptImpl;
import org.apache.hadoop.mapreduce.v2.app.job.impl.TaskImpl;
import org.apache.hadoop.mapreduce.v2.app.metrics.MRAppMetrics;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.SystemClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestTaskImpl {
    private static final Log LOG = LogFactory.getLog(TestTaskImpl.class);
    private JobConf conf;
    private TaskAttemptListener taskAttemptListener;
    private Token<JobTokenIdentifier> jobToken;
    private JobId jobId;
    private Path remoteJobConfFile;
    private Credentials credentials;
    private Clock clock;
    private MRAppMetrics metrics;
    private TaskImpl mockTask;
    private ApplicationId appId;
    private JobSplit.TaskSplitMetaInfo taskSplitMetaInfo;
    private String[] dataLocations = new String[0];
    private AppContext appContext;
    private int startCount = 0;
    private int taskCounter = 0;
    private final int partition = 1;
    private InlineDispatcher dispatcher;
    private List<MockTaskAttemptImpl> taskAttempts;

    @Before
    public void setup() {
        this.dispatcher = new InlineDispatcher();
        ++this.startCount;
        this.conf = new JobConf();
        this.taskAttemptListener = (TaskAttemptListener)Mockito.mock(TaskAttemptListener.class);
        this.jobToken = (Token)Mockito.mock(Token.class);
        this.remoteJobConfFile = (Path)Mockito.mock(Path.class);
        this.credentials = null;
        this.clock = new SystemClock();
        this.metrics = (MRAppMetrics)Mockito.mock(MRAppMetrics.class);
        this.dataLocations = new String[1];
        this.appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        this.jobId = (JobId)Records.newRecord(JobId.class);
        this.jobId.setId(1);
        this.jobId.setAppId(this.appId);
        this.appContext = (AppContext)Mockito.mock(AppContext.class);
        this.taskSplitMetaInfo = (JobSplit.TaskSplitMetaInfo)Mockito.mock(JobSplit.TaskSplitMetaInfo.class);
        Mockito.when((Object)this.taskSplitMetaInfo.getLocations()).thenReturn((Object)this.dataLocations);
        this.taskAttempts = new ArrayList<MockTaskAttemptImpl>();
    }

    private MockTaskImpl createMockTask(TaskType taskType) {
        return new MockTaskImpl(this.jobId, 1, this.dispatcher.getEventHandler(), this.remoteJobConfFile, this.conf, this.taskAttemptListener, this.jobToken, this.credentials, this.clock, this.startCount, this.metrics, this.appContext, taskType);
    }

    @After
    public void teardown() {
        this.taskAttempts.clear();
    }

    private TaskId getNewTaskID() {
        TaskId taskId = (TaskId)Records.newRecord(TaskId.class);
        taskId.setId(++this.taskCounter);
        taskId.setJobId(this.jobId);
        taskId.setTaskType(this.mockTask.getType());
        return taskId;
    }

    private void scheduleTaskAttempt(TaskId taskId) {
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_SCHEDULE));
        this.assertTaskScheduledState();
        this.assertTaskAttemptAvataar(Avataar.VIRGIN);
    }

    private void killTask(TaskId taskId) {
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_KILL));
        this.assertTaskKillWaitState();
    }

    private void killScheduledTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskScheduledState();
    }

    private void launchTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_LAUNCHED));
        this.assertTaskRunningState();
    }

    private void commitTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        this.assertTaskRunningState();
    }

    private MockTaskAttemptImpl getLastAttempt() {
        return this.taskAttempts.get(this.taskAttempts.size() - 1);
    }

    private void updateLastAttemptProgress(float p) {
        this.getLastAttempt().setProgress(p);
    }

    private void updateLastAttemptState(TaskAttemptState s) {
        this.getLastAttempt().setState(s);
    }

    private void killRunningTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_KILLED));
        this.assertTaskRunningState();
    }

    private void failRunningTaskAttempt(TaskAttemptId attemptId) {
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(attemptId, TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskRunningState();
    }

    private void assertTaskNewState() {
        Assert.assertEquals((Object)TaskState.NEW, (Object)this.mockTask.getState());
    }

    private void assertTaskScheduledState() {
        Assert.assertEquals((Object)TaskState.SCHEDULED, (Object)this.mockTask.getState());
    }

    private void assertTaskRunningState() {
        Assert.assertEquals((Object)TaskState.RUNNING, (Object)this.mockTask.getState());
    }

    private void assertTaskKillWaitState() {
        Assert.assertEquals((Object)TaskStateInternal.KILL_WAIT, (Object)this.mockTask.getInternalState());
    }

    private void assertTaskSucceededState() {
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
    }

    private void assertTaskAttemptAvataar(Avataar avataar) {
        for (TaskAttempt taskAttempt : this.mockTask.getAttempts().values()) {
            if (((TaskAttemptImpl)taskAttempt).getAvataar() != avataar) continue;
            return;
        }
        Assert.fail((String)("There is no " + (avataar == Avataar.VIRGIN ? "virgin" : "speculative") + "task attempt"));
    }

    @Test
    public void testInit() {
        LOG.info((Object)"--- START: testInit ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.assertTaskNewState();
        assert (this.taskAttempts.size() == 0);
    }

    @Test
    public void testScheduleTask() {
        LOG.info((Object)"--- START: testScheduleTask ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
    }

    @Test
    public void testKillScheduledTask() {
        LOG.info((Object)"--- START: testKillScheduledTask ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killTask(taskId);
    }

    @Test
    public void testKillScheduledTaskAttempt() {
        LOG.info((Object)"--- START: testKillScheduledTaskAttempt ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.killScheduledTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testLaunchTaskAttempt() {
        LOG.info((Object)"--- START: testLaunchTaskAttempt ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testKillRunningTaskAttempt() {
        LOG.info((Object)"--- START: testKillRunningTaskAttempt ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.killRunningTaskAttempt(this.getLastAttempt().getAttemptId());
    }

    @Test
    public void testKillSuccessfulTask() {
        LOG.info((Object)"--- START: testKillSuccesfulTask ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_KILL));
        this.assertTaskSucceededState();
    }

    @Test
    public void testTaskProgress() {
        LOG.info((Object)"--- START: testTaskProgress ---");
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        float progress = 0.0f;
        assert (this.mockTask.getProgress() == progress);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        progress = 50.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 100.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
        progress = 0.0f;
        this.updateLastAttemptState(TaskAttemptState.KILLED);
        assert (this.mockTask.getProgress() == progress);
        this.killRunningTaskAttempt(this.getLastAttempt().getAttemptId());
        assert (this.taskAttempts.size() == 2);
        assert (this.mockTask.getProgress() == 0.0f);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        progress = 50.0f;
        this.updateLastAttemptProgress(progress);
        assert (this.mockTask.getProgress() == progress);
    }

    @Test
    public void testKillDuringTaskAttemptCommit() {
        this.mockTask = this.createMockTask(TaskType.REDUCE);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.COMMIT_PENDING);
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        TaskAttemptId commitAttempt = this.getLastAttempt().getAttemptId();
        this.updateLastAttemptState(TaskAttemptState.KILLED);
        this.killRunningTaskAttempt(commitAttempt);
        Assert.assertFalse((boolean)this.mockTask.canCommit(commitAttempt));
    }

    @Test
    public void testFailureDuringTaskAttemptCommit() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.COMMIT_PENDING);
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.FAILED);
        this.failRunningTaskAttempt(this.getLastAttempt().getAttemptId());
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.updateLastAttemptState(TaskAttemptState.SUCCEEDED);
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        Assert.assertFalse((String)"First attempt should not commit", (boolean)this.mockTask.canCommit(this.taskAttempts.get(0).getAttemptId()));
        Assert.assertTrue((String)"Second attempt should commit", (boolean)this.mockTask.canCommit(this.getLastAttempt().getAttemptId()));
        this.assertTaskSucceededState();
    }

    private void runSpeculativeTaskAttemptSucceeds(TaskEventType firstAttemptFinishEvent) {
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.RUNNING);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.commitTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        this.assertTaskSucceededState();
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.taskAttempts.get(0).getAttemptId(), firstAttemptFinishEvent));
        this.assertTaskSucceededState();
        this.assertTaskAttemptAvataar(Avataar.SPECULATIVE);
    }

    @Test
    public void testMapSpeculativeTaskAttemptSucceedsEvenIfFirstFails() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_FAILED);
    }

    @Test
    public void testReduceSpeculativeTaskAttemptSucceedsEvenIfFirstFails() {
        this.mockTask = this.createMockTask(TaskType.REDUCE);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_FAILED);
    }

    @Test
    public void testMapSpeculativeTaskAttemptSucceedsEvenIfFirstIsKilled() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_KILLED);
    }

    @Test
    public void testReduceSpeculativeTaskAttemptSucceedsEvenIfFirstIsKilled() {
        this.mockTask = this.createMockTask(TaskType.REDUCE);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_KILLED);
    }

    @Test
    public void testMultipleTaskAttemptsSucceed() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_SUCCEEDED);
    }

    @Test
    public void testCommitAfterSucceeds() {
        this.mockTask = this.createMockTask(TaskType.REDUCE);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_COMMIT_PENDING);
    }

    @Test
    public void testSpeculativeMapFetchFailure() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_KILLED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.taskAttempts.get(1).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    @Test
    public void testSpeculativeMapMultipleSucceedFetchFailure() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_SUCCEEDED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.taskAttempts.get(1).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    @Test
    public void testSpeculativeMapFailedFetchFailure() {
        this.mockTask = this.createMockTask(TaskType.MAP);
        this.runSpeculativeTaskAttemptSucceeds(TaskEventType.T_ATTEMPT_FAILED);
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.taskAttempts.get(1).getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        this.assertTaskScheduledState();
        Assert.assertEquals((long)3L, (long)this.taskAttempts.size());
    }

    @Test
    public void testFailedTransitions() {
        this.mockTask = new MockTaskImpl(this.jobId, 1, this.dispatcher.getEventHandler(), this.remoteJobConfFile, this.conf, this.taskAttemptListener, (Token)this.jobToken, this.credentials, this.clock, this.startCount, this.metrics, this.appContext, TaskType.MAP){

            @Override
            protected int getMaxAttempts() {
                return 1;
            }
        };
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        Assert.assertEquals((long)4L, (long)this.taskAttempts.size());
        MockTaskAttemptImpl taskAttempt = this.taskAttempts.get(0);
        taskAttempt.setState(TaskAttemptState.FAILED);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(taskAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        this.mockTask.handle(new TaskEvent(taskId, TaskEventType.T_KILL));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ATTEMPT_LAUNCHED));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        Assert.assertEquals((long)4L, (long)this.taskAttempts.size());
        taskAttempt = this.taskAttempts.get(1);
        taskAttempt.setState(TaskAttemptState.COMMIT_PENDING);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(taskAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_COMMIT_PENDING));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        taskAttempt.setState(TaskAttemptState.FAILED);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(taskAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_FAILED));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        taskAttempt = this.taskAttempts.get(2);
        taskAttempt.setState(TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(taskAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
        taskAttempt = this.taskAttempts.get(3);
        taskAttempt.setState(TaskAttemptState.KILLED);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(taskAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_KILLED));
        Assert.assertEquals((Object)TaskState.FAILED, (Object)this.mockTask.getState());
    }

    @Test
    public void testCountersWithSpeculation() {
        this.mockTask = new MockTaskImpl(this.jobId, 1, this.dispatcher.getEventHandler(), this.remoteJobConfFile, this.conf, this.taskAttemptListener, (Token)this.jobToken, this.credentials, this.clock, this.startCount, this.metrics, this.appContext, TaskType.MAP){

            @Override
            protected int getMaxAttempts() {
                return 1;
            }
        };
        TaskId taskId = this.getNewTaskID();
        this.scheduleTaskAttempt(taskId);
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.RUNNING);
        MockTaskAttemptImpl baseAttempt = this.getLastAttempt();
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(this.getLastAttempt().getAttemptId(), TaskEventType.T_ADD_SPEC_ATTEMPT));
        this.launchTaskAttempt(this.getLastAttempt().getAttemptId());
        this.updateLastAttemptState(TaskAttemptState.RUNNING);
        MockTaskAttemptImpl specAttempt = this.getLastAttempt();
        Assert.assertEquals((long)2L, (long)this.taskAttempts.size());
        Counters specAttemptCounters = new Counters();
        Counter cpuCounter = specAttemptCounters.findCounter((Enum)TaskCounter.CPU_MILLISECONDS);
        cpuCounter.setValue(1000L);
        specAttempt.setCounters(specAttemptCounters);
        this.commitTaskAttempt(specAttempt.getAttemptId());
        specAttempt.setProgress(1.0f);
        specAttempt.setState(TaskAttemptState.SUCCEEDED);
        this.mockTask.handle((TaskEvent)new TaskTAttemptEvent(specAttempt.getAttemptId(), TaskEventType.T_ATTEMPT_SUCCEEDED));
        Assert.assertEquals((Object)TaskState.SUCCEEDED, (Object)this.mockTask.getState());
        baseAttempt.setProgress(1.0f);
        Counters taskCounters = this.mockTask.getCounters();
        Assert.assertEquals((String)"wrong counters for task", (Object)specAttemptCounters, (Object)taskCounters);
    }

    private class MockTask
    extends Task {
        private TaskType taskType;

        MockTask(TaskType taskType) {
            this.taskType = taskType;
        }

        public void run(JobConf job, TaskUmbilicalProtocol umbilical) throws IOException, ClassNotFoundException, InterruptedException {
        }

        public boolean isMapTask() {
            return this.taskType == TaskType.MAP;
        }
    }

    private class MockTaskAttemptImpl
    extends TaskAttemptImpl {
        private float progress;
        private TaskAttemptState state;
        private TaskType taskType;
        private Counters attemptCounters;

        public MockTaskAttemptImpl(TaskId taskId, int id, EventHandler eventHandler, TaskAttemptListener taskAttemptListener, Path jobFile, int partition, JobConf conf, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, AppContext appContext, TaskType taskType) {
            super(taskId, id, eventHandler, taskAttemptListener, jobFile, partition, conf, TestTaskImpl.this.dataLocations, jobToken, credentials, clock, appContext);
            this.progress = 0.0f;
            this.state = TaskAttemptState.NEW;
            this.attemptCounters = TaskAttemptImpl.EMPTY_COUNTERS;
            this.taskType = taskType;
        }

        public TaskAttemptId getAttemptId() {
            return this.getID();
        }

        protected Task createRemoteTask() {
            return new MockTask(this.taskType);
        }

        public float getProgress() {
            return this.progress;
        }

        public void setProgress(float progress) {
            this.progress = progress;
        }

        public void setState(TaskAttemptState state) {
            this.state = state;
        }

        public TaskAttemptState getState() {
            return this.state;
        }

        public Counters getCounters() {
            return this.attemptCounters;
        }

        public void setCounters(Counters counters) {
            this.attemptCounters = counters;
        }
    }

    private class MockTaskImpl
    extends TaskImpl {
        private int taskAttemptCounter;
        TaskType taskType;

        public MockTaskImpl(JobId jobId, int partition, EventHandler eventHandler, Path remoteJobConfFile, JobConf conf, TaskAttemptListener taskAttemptListener, Token<JobTokenIdentifier> jobToken, Credentials credentials, Clock clock, int startCount, MRAppMetrics metrics, AppContext appContext, TaskType taskType) {
            super(jobId, taskType, partition, eventHandler, remoteJobConfFile, conf, taskAttemptListener, jobToken, credentials, clock, startCount, metrics, appContext);
            this.taskAttemptCounter = 0;
            this.taskType = taskType;
        }

        public TaskType getType() {
            return this.taskType;
        }

        protected TaskAttemptImpl createAttempt() {
            MockTaskAttemptImpl attempt = new MockTaskAttemptImpl(this.getID(), ++this.taskAttemptCounter, this.eventHandler, this.taskAttemptListener, TestTaskImpl.this.remoteJobConfFile, this.partition, this.conf, (Token<JobTokenIdentifier>)this.jobToken, this.credentials, this.clock, this.appContext, this.taskType);
            TestTaskImpl.this.taskAttempts.add(attempt);
            return attempt;
        }

        protected int getMaxAttempts() {
            return 100;
        }

        protected void internalError(TaskEventType type) {
            super.internalError(type);
            Assert.fail((String)("Internal error: " + type));
        }
    }
}

